#include <windows.h>
#define _WIN32_IE 0x0500
#include <commctrl.h>
#include <stdlib.h>
#include <dirent.h>
#include "../../winproject/resource.h"
#include "../plugin.h"
#include "../rom.h"
#include "../../r4300/r4300.h"
#include "../../memory/memory.h"
#include "translation.h"
#include "rombrowser.h"
#include "main_win.h"
#include "configdialog.h"
#include "../guifuncs.h"
#include "../mupenIniApi.h"
#include "../savestates.h"


/*#ifdef __CYGWIN__
WinMainCRTStartup() { mainCRTStartup(); }
#endif*/
CONTROL Controls[4];

static GFX_INFO gfx_info;
static CONTROL_INFO control_info;
static AUDIO_INFO audio_info;
static int currentSaveState = 0 ;

void (*getDllInfo)(PLUGIN_INFO *PluginInfo);
void (*dllConfig)(HWND hParent);
void (*dllTest)(HWND hParent);
void (*dllAbout)(HWND hParent);

void (*changeWindow)();
void (*closeDLL_gfx)();
BOOL (*initiateGFX)(GFX_INFO Gfx_Info);
void (*processDList)();
void (*processRDPList)();
void (*romClosed_gfx)();
void (*romOpen_gfx)();
void (*showCFB)();
void (*updateScreen)();
void (*viStatusChanged)();
void (*viWidthChanged)();
void (*moveScreen)(int xpos, int ypos);

void (*closeDLL_input)();
void (*controllerCommand)(int Control, BYTE * Command);
void (*getKeys)(int Control, BUTTONS *Keys);
void (*initiateControllers)(CONTROL_INFO ControlInfo);
void (*old_initiateControllers)(HWND hMainWindow, CONTROL Controls[4]);
void (*readController)(int Control, BYTE *Command);
void (*romClosed_input)();
void (*romOpen_input)();
void (*keyDown)(WPARAM wParam, LPARAM lParam);
void (*keyUp)(WPARAM wParam, LPARAM lParam);

void (*aiDacrateChanged)(int SystemType);
void (*aiLenChanged)();
DWORD (*aiReadLength)();
void (*aiUpdate)(BOOL Wait);
void (*closeDLL_audio)();
BOOL (*initiateAudio)(AUDIO_INFO Audio_Info);
void (*processAList)();
void (*romClosed_audio)();
void (*romOpen_audio)();


static DWORD WINAPI ThreadFunc(LPVOID lpParam);

const char g_szClassName[] = "myWindowClass";
static int app_nCmdShow;

void display_loading_progress(int p)
{
   TranslateDefault("Loading Rom","Loading Rom",TempMessage);
   sprintf(TempMessage,"%s: %d%%",TempMessage,p);
   SendMessage( hStatus, SB_SETTEXT, 1, (LPARAM)TempMessage );  
}

void warn_savestate_not_exist()
{
   TranslateDefault("Savestates Wrong Slot","You have selected wrong save slot or save doesn't exist",TempMessage);
   sprintf(TempMessage,"%s",TempMessage);
   ShowMessage( TempMessage ); 
}
void warn_savestate_from_another_rom()
{
   TranslateDefault("Savestates Wrong Region","This savestate from another rom or version",TempMessage);
   sprintf(TempMessage,"%s",TempMessage);
   ShowMessage( TempMessage );
}


static char currentpath[_MAX_DIR];
char *get_currentpath()
{
    char drive[_MAX_DRIVE], dirn[_MAX_DIR];
	char fname[_MAX_FNAME], ext[_MAX_EXT];
    char path_buffer[_MAX_PATH];
    
    GetModuleFileName(NULL, path_buffer, sizeof(path_buffer));
    _splitpath(path_buffer, drive, dirn, fname, ext);
    strcpy(currentpath, drive);
    strcat(currentpath, dirn);
    return currentpath;
}

BOOL PluginsChanged ( HWND hwnd ) {

    char tmp[_MAX_PATH];
    int index;
    //Checking GFX plugin
    index = SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETCURSEL, 0, 0);
    SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETLBTEXT, index, (LPARAM)tmp);
    if(_stricmp(gfx_name,tmp) != 0) { return TRUE; }
    
    //Checking control plugin 	
    index = SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETCURSEL, 0, 0);
	SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETLBTEXT, index, (LPARAM)tmp);
    if(_stricmp(input_name,tmp) != 0) { return TRUE; }
   	return FALSE;
   	
   	//Checking sound plugin
   	index = SendDlgItemMessage(hwnd, IDC_COMBO_SOUND, CB_GETCURSEL, 0, 0);
	SendDlgItemMessage(hwnd, IDC_COMBO_SOUND, CB_GETLBTEXT, index, (LPARAM)tmp);
    if(_stricmp(sound_name,tmp) != 0) { return TRUE; }
   	return FALSE;
}  

void SelectState(HWND hWnd, int StateID) {
	char String[800];
	static int LastState = ID_CURRENTSAVE_DEFAULT ;
    HMENU hMenu = GetMenu(hWnd);
	MENUITEMINFO menuinfo;
	CheckMenuItem( hMenu, LastState, MF_BYCOMMAND | MFS_UNCHECKED );
	CheckMenuItem( hMenu, StateID, MF_BYCOMMAND | MFS_CHECKED );
	currentSaveState = StateID - ID_CURRENTSAVE_DEFAULT ;
	LastState = StateID ;
	savestates_select_slot(currentSaveState) ;
}

static void sucre()
{
   //printf("sucre\n");
}

//--------------------- plugin storage type ----------------
typedef struct _plugins plugins;
struct _plugins
{
    char *file_name;
    char *plugin_name;
    HMODULE handle;
    int type;
    plugins *next;
};
static plugins *liste_plugins = NULL, *current;

void insert_plugin(plugins *p, char *file_name,
		   char *plugin_name, void *handle, int type,int num)
{
    if (p->next)
        insert_plugin(p->next, file_name, plugin_name, handle, type, 
                               (p->type == type) ? num+1 : num);
    else
    {
        p->next = malloc(sizeof(plugins));
        p->next->type = type;
        p->next->handle = handle;
        p->next->file_name = malloc(strlen(file_name)+1);
        strcpy(p->next->file_name, file_name);
        p->next->plugin_name = malloc(strlen(plugin_name)+7);
        sprintf(p->next->plugin_name, "%d - %s", 
                                      num+((p->type == type) ? 2 : 1), plugin_name);
        p->next->next=NULL;
    }
}

void rewind_plugin()
{
   current = liste_plugins;
}

char *next_plugin()
{
   if (!current->next) return NULL;
   current = current->next;
   return current->plugin_name;
}

int get_plugin_type()
{
   if (!current->next) return -1;
   return current->next->type;
}

void *get_handle(plugins *p, char *name)
{
   if (!p->next) return NULL;
   if (!strcmp(p->next->plugin_name, name))
         return p->next->handle;
   else  
         return get_handle(p->next, name);
}
char* getExtension(char *str)
{
    if (strlen(str) > 3) return str + strlen(str) - 3;
    else return NULL;
}

void search_plugins(char *cmd)
{
    
    char drive[_MAX_DRIVE], dirn[_MAX_DIR];
	char fname[_MAX_FNAME], ext[_MAX_EXT];
    DIR *dir;
    char cwd[_MAX_DIR];
    char name[_MAX_DIR];
    struct dirent *entry;
   
    liste_plugins = malloc(sizeof(plugins));
    liste_plugins->type = -1;
    liste_plugins->next = NULL;
    
    _splitpath(cmd, drive, dirn, fname, ext);
    strcpy(cwd, drive);
    strcat(cwd, dirn);
    strcat(cwd, "plugin");

    dir = opendir(cwd);
    while((entry = readdir(dir)) != NULL)
    {
        HMODULE handle;
       
        strcpy(name, cwd);
        strcat(name, "\\");
        strcat(name, entry->d_name);
       
        if (getExtension(entry->d_name) != NULL && strcmp(getExtension(entry->d_name),"dll")==0) {
        handle = LoadLibrary(name);
        if (handle)
        {
            PLUGIN_INFO PluginInfo;
            getDllInfo = (void(__cdecl*)(PLUGIN_INFO *PluginInfo))GetProcAddress(handle, "GetDllInfo");
            if (getDllInfo)
            {
                getDllInfo(&PluginInfo);
                insert_plugin(liste_plugins, name, PluginInfo.Name, 
                                             handle, PluginInfo.Type, 0);
                                       
            }
        }
      }
    }
    current = liste_plugins;
}

void exec_config(char *name)
{
   HMODULE handle;
   handle = get_handle(liste_plugins, name);
   if (handle) {
      dllConfig = (void(__cdecl*)(HWND hParent))GetProcAddress(handle, "DllConfig");
      if (dllConfig) dllConfig(hwnd_plug);
   }
}

void exec_test(char *name)
{
   HMODULE handle;
   
   handle = get_handle(liste_plugins, name);
   if (handle)
      {
         dllTest = (void(__cdecl*)(HWND hParent))GetProcAddress(handle, "DllTest");
         if (dllTest) dllTest(hwnd_plug);
      }   
}

void exec_about(char *name)
{
   HMODULE handle;
   
   handle = get_handle(liste_plugins, name);
   if (handle) 
      {
         dllAbout = (void(__cdecl*)(HWND hParent))GetProcAddress(handle, "DllAbout");
         if (dllAbout) dllAbout(hwnd_plug);
      }
}
int check_plugins()
{
   void *handle_gfx, *handle_input, *handle_sound ;
   PLUGIN_INFO PluginInfo;
   char s[1000];
  
   handle_gfx = get_handle(liste_plugins, gfx_name);
   if (!handle_gfx) {
         ShowMessage("Choose graphics plugin in Configuration Dialog.");
		 return (0);
   }
   
   handle_input = get_handle(liste_plugins, input_name);
   if (!handle_input) {
         ShowMessage("Choose input plugin in Configuration Dialog.");
		 return (0);
   }
   
   handle_sound = get_handle(liste_plugins, sound_name);
   if (!handle_sound) {
         ShowMessage("Choose audio plugin in Configuration Dialog.");
		 return (0);
   }
   return 1;
}

int load_gfx(void *handle_gfx)
{
   changeWindow = (void(__cdecl*)())GetProcAddress(handle_gfx, "ChangeWindow");
   closeDLL_gfx = (void(__cdecl*)())GetProcAddress(handle_gfx, "CloseDLL");
   dllAbout = (void(__cdecl*)(HWND hParent))GetProcAddress(handle_gfx, "DllAbout");
   dllConfig = (void(__cdecl*)(HWND hParent))GetProcAddress(handle_gfx, "DllConfig");
   dllTest = (void(__cdecl*)(HWND hParent))GetProcAddress(handle_gfx, "DllTest");
   initiateGFX = (BOOL(__cdecl*)(GFX_INFO Gfx_Info))GetProcAddress(handle_gfx, "InitiateGFX");
   processDList = (void(__cdecl*)())GetProcAddress(handle_gfx, "ProcessDList");
   processRDPList = (void(__cdecl*)())GetProcAddress(handle_gfx, "ProcessRDPList");
   romClosed_gfx = (void(__cdecl*)())GetProcAddress(handle_gfx, "RomClosed");
   romOpen_gfx = (void(__cdecl*)())GetProcAddress(handle_gfx, "RomOpen");
   showCFB = (void(__cdecl*)())GetProcAddress(handle_gfx, "ShowCFB");
   updateScreen = (void(__cdecl*)())GetProcAddress(handle_gfx, "UpdateScreen");
   viStatusChanged = (void(__cdecl*)())GetProcAddress(handle_gfx, "ViStatusChanged");
   viWidthChanged = (void(__cdecl*)())GetProcAddress(handle_gfx, "ViWidthChanged");
   moveScreen = (void(__cdecl*)())GetProcAddress(handle_gfx, "MoveScreen");
   gfx_info.hWnd = hwnd_thread;
   gfx_info.hStatusBar = hStatus ;
   gfx_info.MemoryBswaped = TRUE;
   gfx_info.HEADER = rom;
   gfx_info.RDRAM = (BYTE*)rdram;
   gfx_info.DMEM = (BYTE*)SP_DMEM;
   gfx_info.IMEM = (BYTE*)SP_IMEM;
   gfx_info.MI_INTR_REG = &(MI_register.mi_intr_reg);
   gfx_info.DPC_START_REG = &(dpc_register.dpc_start);
   gfx_info.DPC_END_REG = &(dpc_register.dpc_end);
   gfx_info.DPC_CURRENT_REG = &(dpc_register.dpc_current);
   gfx_info.DPC_STATUS_REG = &(dpc_register.dpc_status);
   gfx_info.DPC_CLOCK_REG = &(dpc_register.dpc_clock);
   gfx_info.DPC_BUFBUSY_REG = &(dpc_register.dpc_bufbusy);
   gfx_info.DPC_PIPEBUSY_REG = &(dpc_register.dpc_pipebusy);
   gfx_info.DPC_TMEM_REG = &(dpc_register.dpc_tmem);
   gfx_info.VI_STATUS_REG = &(vi_register.vi_status);
   gfx_info.VI_ORIGIN_REG = &(vi_register.vi_origin);
   gfx_info.VI_WIDTH_REG = &(vi_register.vi_width);
   gfx_info.VI_INTR_REG = &(vi_register.vi_v_intr);
   gfx_info.VI_V_CURRENT_LINE_REG = &(vi_register.vi_current);
   gfx_info.VI_TIMING_REG = &(vi_register.vi_burst);
   gfx_info.VI_V_SYNC_REG = &(vi_register.vi_v_sync);
   gfx_info.VI_H_SYNC_REG = &(vi_register.vi_h_sync);
   gfx_info.VI_LEAP_REG = &(vi_register.vi_leap);
   gfx_info.VI_H_START_REG = &(vi_register.vi_h_start);
   gfx_info.VI_V_START_REG = &(vi_register.vi_v_start);
   gfx_info.VI_V_BURST_REG = &(vi_register.vi_v_burst);
   gfx_info.VI_X_SCALE_REG = &(vi_register.vi_x_scale);
   gfx_info.VI_Y_SCALE_REG = &(vi_register.vi_y_scale);
   gfx_info.CheckInterrupts = sucre;
   initiateGFX(gfx_info);

}
int load_input(void *handle_input)
{
   int i ;
   PLUGIN_INFO PluginInfo;
   getDllInfo = (void(__cdecl*)(PLUGIN_INFO *PluginInfo))GetProcAddress(handle_input, "GetDllInfo");
   getDllInfo(&PluginInfo);
   
   closeDLL_input = (void(__cdecl*)())GetProcAddress(handle_input, "CloseDLL");
   controllerCommand = (void(__cdecl*)(int Control, BYTE * Command))GetProcAddress(handle_input, "ControllerCommand");
   getKeys = (void(__cdecl*)(int Control, BUTTONS *Keys))GetProcAddress(handle_input, "GetKeys");
   if (PluginInfo.Version == 0x0101)
       initiateControllers = (void(__cdecl*)(CONTROL_INFO ControlInfo))GetProcAddress(handle_input, "InitiateControllers");
   else
       old_initiateControllers = (void(__cdecl*)(HWND hMainWindow, CONTROL Controls[4]))GetProcAddress(handle_input, "InitiateControllers");
   readController = (void(__cdecl*)(int Control, BYTE *Command))GetProcAddress(handle_input, "ReadController");
   romClosed_input = (void(__cdecl*)())GetProcAddress(handle_input, "RomClosed");
   romOpen_input = (void(__cdecl*)())GetProcAddress(handle_input, "RomOpen");
   keyDown = (void(__cdecl*)(WPARAM wParam, LPARAM lParam))GetProcAddress(handle_input, "WM_KeyDown");
   keyUp = (void(__cdecl*)(WPARAM wParam, LPARAM lParam))GetProcAddress(handle_input, "WM_KeyUp");
   
   control_info.hMainWindow = hwnd_thread;
   control_info.hinst = app_hInstance;
   control_info.MemoryBswaped = TRUE;
   control_info.HEADER = rom;
   control_info.Controls = Controls;
   for (i=0; i<4; i++)
     {
	Controls[i].Present = FALSE;
	Controls[i].RawData = FALSE;
	Controls[i].Plugin = PLUGIN_NONE;
     }
   if (PluginInfo.Version == 0x0101)
      {
        initiateControllers(control_info);
      } 
   else
      {
        old_initiateControllers(mainHWND, Controls);
      } 
}

int load_sound(void *handle_sound )
{
    closeDLL_audio = (void (__cdecl *)(void))GetProcAddress( handle_sound, "CloseDLL" );
	aiDacrateChanged = (void (__cdecl *)(int))GetProcAddress( handle_sound, "AiDacrateChanged" );
	aiLenChanged = (void (__cdecl *)(void))GetProcAddress( handle_sound, "AiLenChanged" );
	aiReadLength = (DWORD (__cdecl *)(void))GetProcAddress( handle_sound, "AiReadLength" );
	initiateAudio = (BOOL (__cdecl *)(AUDIO_INFO))GetProcAddress( handle_sound, "InitiateAudio" );
	romClosed_audio = (void (__cdecl *)(void))GetProcAddress( handle_sound, "RomClosed" );
	processAList = (void (__cdecl *)(void))GetProcAddress( handle_sound, "ProcessAList" );	
	aiUpdate = (void (__cdecl *)(BOOL))GetProcAddress( handle_sound, "AiUpdate" );
	
    audio_info.hwnd = hwnd_thread;
    audio_info.hinst = app_hInstance;
    audio_info.MemoryBswaped = TRUE;
    audio_info.HEADER = rom;
    
    audio_info.RDRAM = (BYTE*)rdram;
    audio_info.DMEM = (BYTE*)SP_DMEM;
    audio_info.IMEM = (BYTE*)SP_IMEM;
    
    audio_info.MI_INTR_REG = &(MI_register.mi_intr_reg);
    
    audio_info.AI_DRAM_ADDR_REG = &(ai_register.ai_dram_addr);
    audio_info.AI_LEN_REG = &(ai_register.ai_len); 
    audio_info.AI_CONTROL_REG = &(ai_register.ai_control);
    audio_info.AI_STATUS_REG = &(ai_register.ai_status);
    audio_info.AI_DACRATE_REG = &(ai_register.ai_dacrate);
    audio_info.AI_BITRATE_REG = &(ai_register.ai_bitrate);
    
    audio_info.CheckInterrupts = sucre;
    initiateAudio(audio_info);
}

int load_plugins()
{
   int i, version;
   void *handle_gfx, *handle_input, *handle_sound ;
   
   char s[1000];
  
   handle_gfx = get_handle(liste_plugins, gfx_name);
   handle_input = get_handle(liste_plugins, input_name);
   handle_sound = get_handle(liste_plugins, sound_name);
   
   load_gfx(handle_gfx);
   load_input(handle_input);
   load_sound(handle_sound );    
   return (1);
}


void closeRom()
{
      ResumeThread(EmuThreadHandle);
      stop_it();
      CloseHandle(EmuThreadHandle);
      SetWindowText(mainHWND,MUPEN_VERSION);
      SetStatusTranslatedString(hStatus,0,"Rom Closed");
}

void setDefaultPlugins() 
{
      GetPrivateProfileString("Plugins","Graphics","",gfx_name,sizeof(gfx_name),CfgFile);
      GetPrivateProfileString("Plugins","Sound","",sound_name,sizeof(sound_name),CfgFile);
      GetPrivateProfileString("Plugins","Input","",input_name,sizeof(input_name),CfgFile);
      rewind_plugin();
}           

void ShowMessage(LPSTR lpszMessage) 
{ 
   MessageBox(NULL, lpszMessage, "Error", MB_OK); 
} 

void drawStatusAndToolbars(HWND hwnd)
{
   	    
			TBBUTTON tbb[9];
			TBADDBITMAP tbab;
            TBBUTTONINFO tbi;
            LPTBBUTTONINFO lptbbi;
            int statwidths[] = {200, 400,-1};
            
			// Create Toolbar

			hTool = CreateWindowEx(
                                0,
                                TOOLBARCLASSNAME,
                                NULL,
                                WS_CHILD | WS_VISIBLE | TBSTYLE_FLAT | TBSTYLE_TRANSPARENT | TBSTYLE_TOOLTIPS
			                    | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | CCS_NODIVIDER,
                                0, 0,
                                0, 0,
                                hwnd, (HMENU)IDC_TOOLBAR,
                                app_hInstance,NULL);
			if(hTool == NULL)
				MessageBox(hwnd, "Could not create tool bar.", "Error", MB_OK | MB_ICONERROR);

			// Send the TB_BUTTONSTRUCTSIZE message, which is required for
			// backward compatibility.
			
            SendMessage(hTool, TB_BUTTONSTRUCTSIZE, (WPARAM)sizeof(TBBUTTON), 0);
			
			tbab.hInst = app_hInstance;
			tbab.nID = IDB_TOOLBAR;
			SendMessage(hTool, TB_ADDBITMAP, (WPARAM)sizeof(TBBUTTON), (LPARAM)&tbab);

			ZeroMemory(tbb, sizeof(tbb));
			tbb[0].iBitmap = 0;
			tbb[0].fsState = TBSTATE_ENABLED;
			tbb[0].fsStyle = TBSTYLE_BUTTON;
			tbb[0].idCommand = IDLOAD;
                       
			tbb[1].fsStyle = TBSTYLE_SEP;
						
            tbb[2].iBitmap = 1;
			tbb[2].fsState = TBSTATE_ENABLED;
			tbb[2].fsStyle = TBSTYLE_CHECKGROUP;
			tbb[2].idCommand = EMU_RESUME; 

			tbb[3].iBitmap = 2;
			tbb[3].fsState = TBSTATE_ENABLED;
			tbb[3].fsStyle = TBSTYLE_CHECKGROUP;
			tbb[3].idCommand = EMU_STOP;
           
            tbb[4].iBitmap = 3;
			tbb[4].fsState = TBSTATE_ENABLED;
			tbb[4].fsStyle = TBSTYLE_BUTTON;
			tbb[4].idCommand = CLOSE_ROM;
            
            tbb[5].fsStyle = TBSTYLE_SEP; 
            
			tbb[6].iBitmap = 4;
			tbb[6].fsState = TBSTATE_ENABLED;
			tbb[6].fsStyle = TBSTYLE_BUTTON;
			tbb[6].idCommand = FULL_SCREEN;
			
			tbb[7].fsStyle = TBSTYLE_SEP; 
            
			tbb[8].iBitmap = 5;
			tbb[8].fsState = TBSTATE_ENABLED;
			tbb[8].fsStyle = TBSTYLE_BUTTON;
			tbb[8].idCommand = ID_LOAD_CONFIG;
			
		   	SendMessage(hTool, TB_ADDBUTTONS, sizeof(tbb)/sizeof(TBBUTTON), (LPARAM)&tbb);
		   			   	
	   		// Create Status bar

			hStatus = CreateWindowEx(0, STATUSCLASSNAME, NULL,
				WS_CHILD | WS_VISIBLE | SBARS_SIZEGRIP, 0, 0, 0, 0,
				hwnd, (HMENU)IDC_MAIN_STATUS, GetModuleHandle(NULL), NULL);

			SendMessage(hStatus, SB_SETPARTS, sizeof(statwidths)/sizeof(int), (LPARAM)statwidths);
}

void EnableEmulationMenuItems(BOOL flag)
{
   HMENU hMenu;
   hMenu = GetMenu(mainHWND);
   if (flag) {
      EnableMenuItem(hMenu,CLOSE_ROM,MF_ENABLED);
      EnableMenuItem(hMenu,IDLOAD,MF_GRAYED);
      EnableMenuItem(hMenu,EMU_STOP,MF_ENABLED);
      EnableMenuItem(hMenu,EMU_RESUME,MF_ENABLED);
      EnableMenuItem(hMenu,FULL_SCREEN,MF_ENABLED);
      EnableMenuItem(hMenu,STATE_SAVE,MF_ENABLED);
      EnableMenuItem(hMenu,STATE_SAVEAS,MF_ENABLED);
      EnableMenuItem(hMenu,STATE_RESTORE,MF_ENABLED);
      EnableMenuItem(hMenu,STATE_LOAD,MF_ENABLED);
   }
   else {
      EnableMenuItem(hMenu,CLOSE_ROM,MF_GRAYED);
      EnableMenuItem(hMenu,IDLOAD,MF_ENABLED);
      EnableMenuItem(hMenu,EMU_STOP,MF_GRAYED);
      EnableMenuItem(hMenu,EMU_RESUME,MF_GRAYED);
      EnableMenuItem(hMenu,FULL_SCREEN,MF_GRAYED);
      EnableMenuItem(hMenu,STATE_SAVE,MF_GRAYED);
      EnableMenuItem(hMenu,STATE_SAVEAS,MF_GRAYED);
      EnableMenuItem(hMenu,STATE_RESTORE,MF_GRAYED);
      EnableMenuItem(hMenu,STATE_LOAD,MF_GRAYED); 
   }
}

static DWORD WINAPI SoundThread(LPVOID lpParam)
{
    while (emu_launched) aiUpdate(1);
    ExitThread(dwExitCode);
}

static DWORD WINAPI ThreadFunc(LPVOID lpParam)
{
    dynacore = guiDynacore;
    init_memory() ;
    EnableEmulationMenuItems(TRUE);
    ShowRomBrowser(FALSE);
    load_plugins() ;
    romOpen_gfx();
    romOpen_input();
    emu_paused = 0 ;
    emu_launched = 1;
    CreateThread(NULL, 0, SoundThread, NULL, 0, &SOUNDTHREADID);
    go();
    emu_launched = 0;
    emu_paused = 1;
    EnableEmulationMenuItems(FALSE);
    romClosed_input();
    romClosed_gfx();
    romClosed_audio();
    closeDLL_input();
    closeDLL_gfx();
    closeDLL_audio();
    free(rom);
    rom = NULL;
    free(ROM_HEADER);
    ROM_HEADER = NULL;
    free_memory();
    ShowRomBrowser(TRUE);
    ExitThread(dwExitCode);
    //SendMessage(hwnd_thread, WM_CLOSE, 0x8080, 0);
}

BOOL StartRom(char fullRomPath[_MAX_PATH])
{
     if (!emu_launched) {
                         if (!check_plugins()) 
                         {
                             return TRUE;                  
                         }
                         if (rom_read(fullRomPath))
                         {
                             emu_launched = 0;
                             saveMD5toCache(ROM_SETTINGS.MD5);
                             return TRUE;
                         }
                         saveMD5toCache(ROM_SETTINGS.MD5);
                         hwnd_thread = mainHWND;
                         EmuThreadHandle = CreateThread(NULL, 0, ThreadFunc, NULL, 0, &Id);
                         //SetThreadPriority(EmuThreadHandle, THREAD_PRIORITY_HIGHEST);
                         sprintf(TempMessage, "%s - %s",MUPEN_VERSION, ROM_HEADER->nom);
                         SendMessage(hTool, TB_CHECKBUTTON, EMU_RESUME, 1);
                         SetWindowText(mainHWND,TempMessage);
                         SetStatusTranslatedString(hStatus,0,"Emulation started");
                         SendMessage( hStatus, SB_SETTEXT, 1, (LPARAM)"" ); 
                     }
}

void SaveSettings()
{
    int Width,Height,X,Y,Column,ColWidth;
    char FieldName[30];
    RECT rcMain;
	GetWindowRect(mainHWND, &rcMain);
	X=rcMain.left;
	Y=rcMain.top;
	Width = rcMain.right - rcMain.left;
	Height = rcMain.bottom - rcMain.top;
    sprintf(TempMessage,"%d",X);
    WritePrivateProfileString("Window","X",TempMessage,CfgFile);
    sprintf(TempMessage,"%d",Y);
    WritePrivateProfileString("Window","Y",TempMessage,CfgFile);
    sprintf(TempMessage,"%d",Width);
    WritePrivateProfileString("Window","Width",TempMessage,CfgFile);
    sprintf(TempMessage,"%d",Height);
    WritePrivateProfileString("Window","Height",TempMessage,CfgFile);

    for (Column = 0; Column < 4; Column ++) {
        ColWidth = ListView_GetColumnWidth(hRomList,Column);
        getFieldName(Column,FieldName);
        sprintf(TempMessage,"%d",ColWidth);
        WritePrivateProfileString("Rom Browser",FieldName,TempMessage,CfgFile);
    }
}

void exit_emu()
{
   if (emu_launched) {
         ResumeThread(EmuThreadHandle);
         stop_it();
   }
   SaveRomBrowserCache();
   freeRomDirList();
   freeRomList();
   ini_updateFile(1);
   ini_closeFile();
   SaveSettings();
   Sleep(500);
   PostQuitMessage (0);
}

void ProcessToolTips(LPARAM lParam)
{
    LPTOOLTIPTEXT lpttt; 

    lpttt = (LPTOOLTIPTEXT) lParam; 
    lpttt->hinst = app_hInstance; 

    // Specify the resource identifier of the descriptive 
    // text for the given button. 
    switch (lpttt->hdr.idFrom) 
	{ 
		case IDLOAD:
			 TranslateDefault("Load Rom","Load Rom",TempMessage) ;
             lpttt->lpszText = TempMessage; 
			break;
		case EMU_RESUME:
		     TranslateDefault("Run/Resume Rom","Run/Resume Rom",TempMessage) ;
             lpttt->lpszText = TempMessage; 
			break; 
  		case EMU_STOP:
             TranslateDefault("Stop Emulation","Stop Emulation",TempMessage) ;
             lpttt->lpszText = TempMessage; 
			break; 	
		case CLOSE_ROM:
  	         TranslateDefault("Close Rom","Close Rom",TempMessage) ;
             lpttt->lpszText = TempMessage; 
			break; 
		case ID_LOAD_CONFIG:
              TranslateDefault("Configure","Configure",TempMessage) ;
             lpttt->lpszText = TempMessage; 
			break;
        case FULL_SCREEN:
              TranslateDefault("Full Screen","Full Screen",TempMessage) ;
             lpttt->lpszText = TempMessage; 
			break;   	
   }
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
     char path_buffer[_MAX_PATH], s[1000];
     int index;
     HWND hwndCombo;
     OPENFILENAME oifn;
     int ret;
     ROM_INFO * pRomInfo;
     switch(Message)
     {
       case WM_KEYDOWN:
                   if (emu_launched) keyDown(wParam, lParam);
               break;
        case WM_KEYUP:
                if (emu_launched) keyUp(wParam, lParam);
                break;   
        case WM_NOTIFY:
            if (wParam == IDC_ROMLIST) { 
             RomListNotify((LPNMHDR)lParam); 
            }
            switch (((LPNMHDR) lParam)->code) 
            	{ 
		            case TTN_NEEDTEXT : 
                          ProcessToolTips(lParam);
				    break;
		        }
		    return 0;
		case WM_MOVE:
            if (emu_launched&&!FullScreenMode) {
                     moveScreen(wParam, lParam);
                    }
            break;
        case WM_SIZE:
             if (!FullScreenMode) {
              SendMessage(hTool, TB_AUTOSIZE, 0, 0);
              SendMessage(hStatus, WM_SIZE, 0, 0);  
              ResizeRomListControl();      
             } 
            break;  
        case WM_USER + 17:  SetFocus(mainHWND); break;      
        case WM_CREATE:
            // searching the plugins...........
            GetModuleFileName(NULL, path_buffer, sizeof(path_buffer));
            search_plugins(path_buffer);
            setDefaultPlugins(); 
            drawStatusAndToolbars(hwnd) ;
           
            SetupLanguages(hwnd);
            TranslateMenu(GetMenu(hwnd),hwnd);
            CreateRomListControl(hwnd);
            ////////////////////////////
            return TRUE;
        case WM_CLOSE:
             exit_emu();
             break;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDGFXCONFIG:
                     hwnd_plug = hwnd;
                     exec_config(gfx_name);
                     break;
                case IDINPUTCONFIG:
                     hwnd_plug = hwnd;
                     exec_config(input_name);
                     break;
                case IDSOUNDCONFIG:
                     hwnd_plug = hwnd;
                     exec_config(sound_name);
                     break;     
                case CLOSE_ROM:
                 if (emu_launched) {
                       closeRom();
                       SendMessage(hTool, TB_CHECKBUTTON, EMU_STOP, 0);
                       SendMessage(hTool, TB_CHECKBUTTON, EMU_RESUME, 0);
                     }
                 break;
                
                case EMU_STOP:
                 if (emu_launched) {
                       SuspendThread(EmuThreadHandle);
                       SetStatusTranslatedString(hStatus,0,"Emulation paused");
                       }
                  else
                     {
                       SendMessage(hTool, TB_CHECKBUTTON, EMU_STOP, 0);
                     }     
                break;
                
                case EMU_RESUME:
                 if (emu_launched) {
                       ResumeThread(EmuThreadHandle);
                       SetStatusTranslatedString(hStatus,0,"Emulation started");
                       }
                    else
                    {
                        if (!RomList_OpenRom()) SendMessage(hTool, TB_CHECKBUTTON, EMU_RESUME, 0);;
                    }
                 break;
                
                case ID_LOAD_CONFIG:
                 if (emu_launched) {
                  SuspendThread(EmuThreadHandle);
                 };
                 ChangeSettings(hwnd);
                 if (emu_launched) {
                  ResumeThread(EmuThreadHandle);
                 }
                 break;
                case ID_AUDIT_ROMS:
                     ret = DialogBox(GetModuleHandle(NULL), 
                     MAKEINTRESOURCE(IDD_AUDIT_ROMS_DIALOG), hwnd, AuditDlgProc);
                     break;
                case ID_HELP_ABOUT:
                     ret = DialogBox(GetModuleHandle(NULL), 
                     MAKEINTRESOURCE(IDD_ABOUT), hwnd, AboutDlgProc);
                     break;
                case ID_HELP_CONTENS:
                     TranslateDefault("Index","index.html",TempMessage);
                     ShellExecute(hwnd, "open", TempMessage, NULL, NULL, SW_SHOWNORMAL);           
                     break;
                case ID_HELP_WHATSNEW:
                     TranslateDefault("WhatsNew","whatsnew.txt",TempMessage);
                     ShellExecute(hwnd, "open", TempMessage, NULL, NULL, SW_SHOWNORMAL);           
                     break;
                case IDLOAD:   
                     if (!emu_launched) {
                     ZeroMemory(&oifn, sizeof(OPENFILENAME));
                     oifn.lStructSize = sizeof(OPENFILENAME);
                     oifn.hwndOwner = NULL;
                     strcpy(path_buffer,"");
                     oifn.lpstrFile = path_buffer,
                     oifn.nMaxFile = sizeof(path_buffer);
                     oifn.lpstrFilter = ".n64 Files\0*.n64\0.rom Files\0*.rom\0.v64 Files\0*.v64\0.z64 Files\0*.z64\0Nintendo 64 Rom Files\0*.v64;*.rom;*.bin;*.z64;*n64;*.zip;*.usa;*.jap;*.eur\0";
                     oifn.nFilterIndex = 5;
                     oifn.lpstrFileTitle = "";
                     oifn.nMaxFileTitle = 0;
                     oifn.lpstrInitialDir = "";
                     oifn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
                     GetOpenFileName(&oifn);
                     StartRom(path_buffer);
                     }
                     break;
                case ID_EMULATOR_EXIT:
                     exit_emu();
                     break; 
                case FULL_SCREEN:
                     if (emu_launched)
                     {  
                       FullScreenMode=1-FullScreenMode;
                       changeWindow();
                     } 
                     break;
                case REFRESH_ROM_BROWSER:
                     if (!emu_launched)
                     {  
                       RefreshRomBrowser();
                     } 
                    break;
                case ID_POPUP_ROM_SETTING:
                      OpenRomProperties();      
                    break;
                case ID_START_ROM:
                      RomList_OpenRom();       
                    break;
                case STATE_SAVE:
                    if(!emu_paused) {
                     savestates_job = SAVESTATE;       
                    }
                    break;                 
                case STATE_SAVEAS:
                    if(!emu_paused)  
                    {
                     ZeroMemory(&oifn, sizeof(OPENFILENAME));
                     oifn.lStructSize = sizeof(OPENFILENAME);
                     oifn.hwndOwner = NULL;
                     strcpy(path_buffer,"");
                     oifn.lpstrFile = path_buffer,
                     oifn.nMaxFile = sizeof(path_buffer);
                     oifn.lpstrFilter = "Mupen 64 Saves(*.st)\0*.st;*.st?\0All Files\0*.*\0";
                     oifn.lpstrFileTitle = "";
                     oifn.nMaxFileTitle = 0;
                     oifn.lpstrInitialDir = "";
                    if (GetSaveFileName (&oifn)) {
                     savestates_select_filename(path_buffer);
                     savestates_job = SAVESTATE;
                    }                       
                    }
                    break;
                case STATE_RESTORE:
                    if(!emu_paused)  {
                      savestates_job = LOADSTATE;
                    }
                    break;
                case STATE_LOAD:
                    if(!emu_paused) {
                     ZeroMemory(&oifn, sizeof(OPENFILENAME));
                     oifn.lStructSize = sizeof(OPENFILENAME);
                     oifn.hwndOwner = NULL;
                     strcpy(path_buffer,"");
                     oifn.lpstrFile = path_buffer,
                     oifn.nMaxFile = sizeof(path_buffer);
                     oifn.lpstrFilter = "Mupen 64 Saves(*.st)\0*.st;*.st?\0All Files\0*.*\0";
                     oifn.lpstrFileTitle = "";
                     oifn.nMaxFileTitle = 0;
                     oifn.lpstrInitialDir = "";
                     oifn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
                     if (GetOpenFileName(&oifn)) {
                          savestates_select_filename(path_buffer);
                          savestates_job = LOADSTATE;                
                        }
                     }
                    break;                       
                default :
                     //Language Support  from ID_LANG_ENGLISH to ID_LANG_ENGLISH+100
                     if (LOWORD(wParam) >= ID_LANG_ENGLISH && LOWORD(wParam) <= (ID_LANG_ENGLISH + 100)) {
		                SelectLang(hwnd,LOWORD(wParam));		     
                        TranslateMenu(GetMenu(hwnd),hwnd);
                        TranslateBrowserHeader(hRomList);
                        ShowTotalRoms();
                     }
                     if (LOWORD(wParam) >= ID_CURRENTSAVE_DEFAULT && LOWORD(wParam) <= ID_CURRENTSAVE_9) {
		                SelectState(hwnd,LOWORD(wParam));		     
                     }
			         break;    
            }
            break;
       default:
            return DefWindowProc(hwnd, Message, wParam, lParam);
    }
    return TRUE;	
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                             LPSTR lpCmdLine, int nCmdShow)
{
    int WindowWidth=640,WindowHeight=480,X,Y;
    WNDCLASSEX wc;
	HWND hwnd;
	MSG Msg;
	HACCEL Accel;
    /*FILE *newfp;
    newfp = freopen("stdout.txt", "w", stdout);
     if ( newfp == NULL ) {
        	newfp = fopen("stdout.txt", "w");
    		if ( newfp ) {
 			*stdout = *newfp;
 		}
    }*/
    app_hInstance = hInstance;
    InitCommonControls(); 
    
    LangFile = GetLangFileName();
    CfgFile = GetCfgFileName();
    IniFile = GetIniFileName();

    ini_openFile();
                                                                                                                     
	wc.cbSize		 = sizeof(WNDCLASSEX);
	wc.style		 = 0;
	wc.lpfnWndProc	 = WndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;
	wc.hIcon		 = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_MYICON));
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW-5);
	wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MYMENU);
	wc.lpszClassName = g_szClassName;
	wc.hIconSm		 = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_MYICON));

    if(!RegisterClassEx(&wc))
	{
		MessageBox(NULL, "Window Registration Failed!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return 0;
	}
    WindowWidth = GetPrivateProfileInt("Window","Width",WindowWidth,CfgFile); 
    WindowHeight = GetPrivateProfileInt("Window","Height",WindowHeight,CfgFile); 
    X = GetPrivateProfileInt("Window","X",(GetSystemMetrics( SM_CXSCREEN ) - WindowWidth) / 2,CfgFile);
    Y = GetPrivateProfileInt("Window","Y",(GetSystemMetrics( SM_CYSCREEN ) - WindowHeight) / 2,CfgFile);
    RomBrowserRecursion = GetPrivateProfileInt("Rom Browser","Recursion",0,CfgFile); 
            
    emu_launched = 0;
    emu_paused = 1;
    
    Accel = LoadAccelerators(hInstance,MAKEINTRESOURCE(IDR_ACCEL));

    hwnd = CreateWindowEx(
		0 ,
		g_szClassName,
		MUPEN_VERSION,
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
		X, Y, WindowWidth, WindowHeight,
		NULL, NULL, hInstance, NULL);
     
    if(hwnd == NULL)
	{
		MessageBox(NULL, "Window Creation Failed!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return 0;
	}

    mainHWND = hwnd ;
	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	while(GetMessage(&Msg, NULL, 0, 0) > 0)
	{
	   	if (!TranslateAccelerator(mainHWND,Accel,&Msg)) {
             TranslateMessage(&Msg);
		     DispatchMessage(&Msg);
		}
	}
	//fclose(newfp);
	return Msg.wParam;

}

