#include "inifunctions.h"
#include "main_win.h"
#include "translation.h"
#include "../mupenIniApi.h"

void intCrcCode(unsigned long CRC1,unsigned long CRC2,BYTE Country_code,char* result)
{
    sprintf(result,"%08X-%08X-C%02X",(int)sl(CRC1),(int)sl(CRC2),Country_code);
} 
void getIniGoodNameByMD5(char *md5str,char *result)
{
      mupenEntry *entry;
      entry = ini_search_by_md5(md5str);
      if (entry) {
          strcpy(result,entry->goodname);
      }
      else {   //unknown dump
          strcpy(result,"Unknown Dump");  
      }
}

void getIniGoodName(rom_header *HEADER,char *result)
{
      char tmp[MAX_PATH];
      char crccode[200];
      char mes[200];
      mupenEntry *entry;
      strcpy(result,""); 
      intCrcCode(HEADER->CRC1,HEADER->CRC2,HEADER->Country_code,crccode);
      entry = ini_search_by_CRC(crccode);
      if (entry) {
         strcpy(result,entry->goodname);                
      }
}

void getIniComments(ROM_INFO *pRomInfo,char *result)
{
    char tmp[300];
    mupenEntry *entry;
    sprintf(result,"");
    sprintf(tmp,pRomInfo->MD5);
    if (strcmp(tmp,"")==0) {
       sprintf(tmp,"%08X-%08X-C%02X",pRomInfo->CRC1,pRomInfo->CRC2,pRomInfo->Country);
       entry = ini_search_by_CRC(tmp); 
    }
    else {
       entry = ini_search_by_md5(tmp);  
    }
    if (entry) {
       strcpy(result, entry->comments);
    }   
}

void setIniComments(ROM_INFO *pRomInfo,char *result)
{
    
    char tmp[300];
    mupenEntry *entry;
    if (strcmp(result,"")==0) { 
          return; 
    }
    sprintf(tmp,pRomInfo->MD5);
    if (strcmp(tmp,"")==0) {
       sprintf(tmp,"%08X-%08X-C%02X",pRomInfo->CRC1,pRomInfo->CRC2,pRomInfo->Country);
       entry = ini_search_by_CRC(tmp); 
    }
    else {
       entry = ini_search_by_md5(tmp);  
    }
    if (entry) {
       strcpy( entry->comments,result );
    }  
}
