/**
 * Mupen64 - rjump.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "../recomp.h"
#include "../r4300.h"
#include "../macros.h"
#include "../ops.h"
#include "../recomph.h"
#include <stdlib.h>

//unsigned char jump_code[] = { 0xB8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xE0 };
unsigned char jump_code[10];

//unsigned char exception_code[] = { 0xB8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xD0,
// 0xB8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xE0 }
unsigned char exception_code[20];
unsigned char exception_vector[20], exception_vector_secours[20];
unsigned char *addresse_vecteur, *addresse_vecteur_secours;
unsigned long take_branch = 0;
int i;

void dyna_jump(unsigned long addr)
{
   unsigned long laddr;
   jump_code[0] = 0xB8;
   jump_code[5] = 0xFF;
   jump_code[6] = 0xE0;
   if ((addr >= int_handler.start) && (addr < int_handler.end))
     {
	laddr = int_handler.block[(addr - int_handler.start)/4].local_addr;
	*((unsigned long *)(&jump_code[1])) = (unsigned long)(&int_handler.code[laddr]);
	return;
     }
   for (i=0; i<NBR_BLOCKS; i++)
     {
	if ((addr >= aux[i].start) && (addr < aux[i].end))
	  {
	     laddr = aux[i].block[(addr - aux[i].start)/4].local_addr;
	     *((unsigned long *)(&jump_code[1])) = (unsigned long)(&aux[i].code[laddr]);
	     return;
	  }
     }
   printf ("saut bizarre\n");
   stop=1;
}

void dyna_exception_remove()
{
   memcpy(addresse_vecteur, exception_vector, 20);
}

void dyna_exception_remove2()
{
   memcpy(addresse_vecteur, exception_vector, 20);
   memcpy(addresse_vecteur_secours, exception_vector_secours, 20);
   if (take_branch) EPC=take_branch;
}

void dyna_exception()
{
   unsigned long laddr;
   precomp_instr *PC_EXCEP;
   precomp_block *PC_BLOCK;
   if (pending)
     {
	PC_EXCEP = PC-1;
	pending = 0;
     }
   else PC_EXCEP = PC;
   PC_BLOCK = actual;
   
   jump_to(0x80000180);
   
   exception_code[0] = 0xB8;
   exception_code[5] = 0xFF;
   exception_code[6] = 0xD0;
   exception_code[7] = 0xB8;
   exception_code[12] = 0xFF;
   exception_code[13] = 0xE0;
   *((unsigned long *)(&exception_code[1])) = (unsigned long)(dyna_exception_remove);
   laddr = int_handler.block[0x180/4].local_addr;
   *((unsigned long *)(&exception_code[8])) = (unsigned long)(&int_handler.code[laddr]);
   
   if (delay_slot)
     {
	if (delay_slot == 1)
	  {
	     addresse_vecteur = (unsigned char *)&(PC_BLOCK->code[PC_EXCEP->f.i.delay]);
	     memcpy(exception_vector, addresse_vecteur, 20);
	     addresse_vecteur[0] = 0xB8;
	     addresse_vecteur[5] = 0xFF;
	     addresse_vecteur[6] = 0xE0;
	     *((unsigned long *)(&addresse_vecteur[1])) =
	       (unsigned long)(exception_code);
	     return;
	  }
	if (delay_slot == 3)
	  {
	     addresse_vecteur = (unsigned char *)&(PC_BLOCK->code[PC_EXCEP->f.j.delay]);
	     memcpy(exception_vector, addresse_vecteur, 20);
	     addresse_vecteur[0] = 0xB8;
	     addresse_vecteur[5] = 0xFF;
	     addresse_vecteur[6] = 0xE0;
	     *((unsigned long *)(&addresse_vecteur[1])) =
	       (unsigned long)(exception_code);
	     return;
	  }
	if (delay_slot == 2)
	  printf("exception dans un delay_slot non implemente  PC=%x\n",
		 (unsigned int)PC_EXCEP->addr);
	if (delay_slot == (PC_EXCEP+1)->addr)
	  {
	     addresse_vecteur =
	       (unsigned char *)&(PC_BLOCK->code[PC_BLOCK->block[(delay_slot - PC_BLOCK->start)/4].local_addr]);
	     memcpy(exception_vector, addresse_vecteur, 20);
	     addresse_vecteur[0] = 0xB8;
	     addresse_vecteur[5] = 0xFF;
	     addresse_vecteur[6] = 0xE0;
	     *((unsigned long *)(&addresse_vecteur[1])) =
	       (unsigned long)(exception_code);
	     return;
	  }
	else
	  {
	     addresse_vecteur =
	       (unsigned char *)&(PC_BLOCK->code[PC_BLOCK->block[(delay_slot - PC_BLOCK->start)/4].local_addr]);
	     addresse_vecteur_secours = 
	       (unsigned char *)&(PC_BLOCK->code[(PC_EXCEP+1)->local_addr]);
	     
	     memcpy(exception_vector, addresse_vecteur, 20);
	     addresse_vecteur[0] = 0xC7;
	     addresse_vecteur[1] = 0x05;
	     *((unsigned long *)(&addresse_vecteur[2])) =
	       (unsigned long)(&take_branch);
	     *((unsigned long *)(&addresse_vecteur[6])) = delay_slot;
	     addresse_vecteur[10] = 0xB8;
	     *((unsigned long *)(&addresse_vecteur[11])) =
	       (unsigned long)(exception_code);
	     addresse_vecteur[15] = 0xFF;
	     addresse_vecteur[16] = 0xE0;
	     *((unsigned long *)(&exception_code[1])) = (unsigned long)(dyna_exception_remove2);
	     
	     memcpy(exception_vector_secours, addresse_vecteur_secours, 20);
	     addresse_vecteur_secours[0] = 0xC7;
	     addresse_vecteur_secours[1] = 0x05;
	     *((unsigned long *)(&addresse_vecteur_secours[2])) =
	       (unsigned long)(&take_branch);
	     *((unsigned long *)(&addresse_vecteur_secours[6])) = 0;
	     addresse_vecteur_secours[10] = 0xB8;
	     *((unsigned long *)(&addresse_vecteur_secours[11])) =
	       (unsigned long)(exception_code);
	     addresse_vecteur_secours[15] = 0xFF;
	     addresse_vecteur_secours[16] = 0xE0;
	  }
     }
   else 
     {
	addresse_vecteur = (unsigned char *)&(PC_BLOCK->code[(PC_EXCEP+1)->local_addr]);
	memcpy(exception_vector, addresse_vecteur, 20);
	addresse_vecteur[0] = 0xB8;
	addresse_vecteur[5] = 0xFF;
	addresse_vecteur[6] = 0xE0;
	*((unsigned long *)(&addresse_vecteur[1])) =
	  (unsigned long)(exception_code);
     }
}
#include "../../memory/memory.h"
extern unsigned long interp_addr;
void prefetch();
void check_eret()
{
   if (!dynacore && !interpcore) PC--;
   else if (interpcore) 
     {
	interp_addr-=4;
	prefetch();
	if(PC->ops == BEQL)
	  {
	     if (irs != irt) jump_marker=1;
	     return;
	  }
	if(PC->ops == BNEL)
	  {
	     if (irs == irt) jump_marker=1;
	     return;
	  }
	if(PC->ops == BLEZL)
	  {
	     if (irs > 0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BNE)
	  {
	     if (irs == irt) jump_marker=1;
	     return;
	  }
	if(PC->ops == BLEZ)
	  {
	     if (irs > 0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BEQ)
	  {
	     if (irs != irt) jump_marker=1;
	     return;
	  }
	if(PC->ops == BGEZL)
	  {
	     if (irs < 0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BGEZAL)
	  {
	     if (irs < 0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BGEZ)
	  {
	     if (irs < 0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BLTZ)
	  {
	     if (irs >= 0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BLTZL)
	  {
	     if (irs >= 0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BGTZ)
	  {
	     if (irs <= 0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BC1T)
	  {
	     if ((FCR31 & 0x800000)==0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BC1F)
	  {
	     if ((FCR31 & 0x800000)!=0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BC1TL)
	  {
	     if ((FCR31 & 0x800000)==0) jump_marker=1;
	     return;
	  }
	if(PC->ops == BC1FL)
	  {
	     if ((FCR31 & 0x800000)!=0) jump_marker=1;
	     return;
	  }
	return;
     }
   for (i=0; i<NBR_BLOCKS; i++)
     {
	if (((unsigned long)(EPC) >= aux[i].start) && 
	    ((unsigned long)(EPC) < aux[i].end))
	  {
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BEQL)
	       {
		  if (irs != irt) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BNEL)
	       {
		  if (irs == irt) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BLEZL)
	       {
		  if (irs > 0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BNE)
	       {
		  if (irs == irt) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BLEZ)
	       {
		  if (irs > 0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BEQ)
	       {
		  if (irs != irt) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BGEZL)
	       {
		  if (irs < 0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BGEZAL)
	       {
		  if (irs < 0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BGEZ)
	       {
		  if (irs < 0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BLTZ)
	       {
		  if (irs >= 0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BLTZL)
	       {
		  if (irs >= 0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BGTZ)
	       {
		  if (irs <= 0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BC1T)
	       {
		  if ((FCR31 & 0x800000)==0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BC1F)
	       {
		  if ((FCR31 & 0x800000)!=0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BC1TL)
	       {
		  if ((FCR31 & 0x800000)==0) jump_marker=1;
		  return;
	       }
	     if(aux[i].block[(EPC - aux[i].start)/4].ops == BC1FL)
	       {
		  if ((FCR31 & 0x800000)!=0) jump_marker=1;
		  return;
	       }
	     return;
	  }
     }
   if (!dynacore) PC++;
}
