/**
 * Mupen64 - gbc.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../recomph.h"
#include "assemble.h"
#include "../r4300.h"
#include "../ops.h"

void genbc1t()
{
   dst->local_addr = code_length;
   recomp_jump = 0;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_eax_memoffs32((void *)(&FCR31));
   and_eax_imm32(0x800000);
   cmp_reg32_imm8(EAX, 0);
   jne_near(dst->addr + (dst-1)->f.i.immediate*4);
   jmp(dst->addr + 4);
}

void genbc1f()
{
   dst->local_addr = code_length;
   recomp_jump = 0;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_eax_memoffs32((void *)(&FCR31));
   and_eax_imm32(0x800000);
   cmp_reg32_imm8(EAX, 0);
   je_near(dst->addr + (dst-1)->f.i.immediate*4);
   jmp(dst->addr + 4);
}

void genbc1tl()
{
   unsigned long temp, temp2;
   dst->local_addr = code_length;
   recomp_jump = 0;
   
   mov_eax_memoffs32((void *)(&FCR31));
   and_eax_imm32(0x800000);
   cmp_reg32_imm8(EAX, 0);
   jne_rj(0x05);
   jmp_imm(0);
   temp=code_length;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   jmp(dst->addr + (dst-1)->f.i.immediate*4);
   temp2=code_length;
   code_length = temp-4;
   put32(temp2-temp);
   code_length = temp2;
   
   genupdate_system(0);
   jmp(dst->addr + 4);
}

void genbc1fl()
{
   unsigned long temp, temp2;
   dst->local_addr = code_length;
   recomp_jump = 0;
   
   mov_eax_memoffs32((void *)(&FCR31));
   and_eax_imm32(0x800000);
   cmp_reg32_imm8(EAX, 0);
   je_rj(0x05);
   jmp_imm(0);
   temp=code_length;
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(1);
   mov_m32_imm32((void *)(&delay_slot), dst->addr + dst->f.i.immediate*4 + 4);
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   jmp(dst->addr + (dst-1)->f.i.immediate*4);
   temp2=code_length;
   code_length = temp-4;
   put32(temp2-temp);
   code_length = temp2;
   
   genupdate_system(0);
   jmp(dst->addr + 4);
}
