/**
 * Mupen64 - r4300.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "r4300.h"
#include "ops.h"
#include "../memory/memory.h"
#include "exception.h"
#include "interupt.h"
#include "macros.h"
#include "recomp.h"
#include <malloc.h>

#ifdef DBG
extern int debugger_mode;
extern void update_debugger();
#endif

unsigned long i, dynacore = 0, interpcore = 0;
int stop, llbit;
long long int reg[32], reg_cop0[32], hi, lo;
long long int local_rs, local_rt;
float *reg_cop1_simple[32];
double *reg_cop1_double[32];
long reg_cop1_fgr_32[32];
long long int reg_cop1_fgr_64[32];
long FCR0, FCR31;
tlb tlb_e[32];
unsigned long delay_slot, skip_jump;
unsigned long long int debug_count = 0;
unsigned int next_interupt, CIC_Chip;
precomp_instr *PC;

precomp_instr boot_code[0x1000/4+1];
precomp_instr interrupt[0x300/4+1];
precomp_block sp, int_handler, aux[NBR_BLOCKS], *actual;
int rounding_mode = 0x33F, trunc_mode = 0xF3F, round_mode = 0x33F,
    ceil_mode = 0xB3F, floor_mode = 0x73F;
void (*code)();

void NI()
{
   printf("NI()\n");
   printf("opcode non implemente\n");
   printf("%x\n", *((unsigned int *)(rom) + (0x1000/4) 
		    + (PC->addr - actual->start)/4));
   stop=1;
}

void RESERVED()
{
   printf("opcode rserv\n");
   stop=1;
}

void FIN_BLOCK()
{
   printf("fin du block atteinte\n");
   getchar();
   jump_to((PC-1)->addr+4);
}

void ORI()
{
   irt = irs | (unsigned short)iimmediate;
   PC++;
}

void LUI()
{
   irt = iimmediate << 16;
   sign_extended(irt);
   PC++;
}

void LW()
{
   PC++;
   address = lsaddr;
   rdword = &lsrt;
   read_word_in_memory();
   sign_extended(lsrt);
}

void LD()
{
   PC++;
   address = lsaddr;
   rdword = &lsrt;
   read_dword_in_memory();
}

void LBU()
{
   PC++;
   address = lsaddr;
   rdword = &lsrt;
   read_byte_in_memory();
}

void LB()
{
   PC++;
   address = lsaddr;
   rdword = &lsrt;
   read_byte_in_memory();
   sign_extendedb(lsrt);
}

void LH()
{
   PC++;
   address = lsaddr;
   rdword = &lsrt;
   read_hword_in_memory();
   sign_extendedh(lsrt);
}

void LHU()
{
   PC++;
   address = lsaddr;
   rdword = &lsrt;
   read_hword_in_memory();
}

void SW()
{
   PC++;
   address = lsaddr;
   word = (unsigned long)(lsrt & 0xFFFFFFFF);
   write_word_in_memory();
}

void SC()
{
   PC++;
   if (llbit) {
      address = lsaddr;
      word = (unsigned long)(lsrt & 0xFFFFFFFF);
      write_word_in_memory();
   }
   lsrt = llbit;
}

void SWL()
{
   unsigned long long int old_word;
   PC++;
   switch ((lsaddr) & 3)
     {
      case 0:
	address = (lsaddr) & 0xFFFFFFFC;
	word = (unsigned long)lsrt;
	write_word_in_memory();
	break;
      case 1:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = (unsigned long long int *)&old_word;
	read_word_in_memory();
	word = ((unsigned long)lsrt >> 8) | (old_word & 0xFF000000);
	write_word_in_memory();
	break;
      case 2:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = (unsigned long long int *)&old_word;
	read_word_in_memory();
	word = ((unsigned long)lsrt >> 16) | (old_word & 0xFFFF0000);
	write_word_in_memory();
	break;
      case 3:
	address = lsaddr;
	byte = (unsigned char)(lsrt >> 24);
	write_byte_in_memory();
	break;
     }
}

void LWL()
{
   unsigned long long int word;
   PC++;
   switch ((lsaddr) & 3)
     {
      case 0:
	address = lsaddr;
	rdword = &lsrt;
	read_word_in_memory();
	break;
      case 1:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = &word;
	read_word_in_memory();
	lsrt = (lsrt & 0xFF) | (word << 8);
	break;
      case 2:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = &word;
	read_word_in_memory();
	lsrt = (lsrt & 0xFFFF) | (word << 16);
	break;
      case 3:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = &word;
	read_word_in_memory();
	lsrt = (lsrt & 0xFFFFFF) | (word << 24);
	break;
     }
   sign_extended(lsrt);
}

void LWR()
{
   unsigned long long int word;
   PC++;
   switch ((lsaddr) & 3)
     {
      case 0:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = &word;
	read_word_in_memory();
	lsrt = (lsrt & 0xFFFFFF00) | (word >> 24);
	break;
      case 1:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = &word;
	read_word_in_memory();
	lsrt = (lsrt & 0xFFFF0000) | (word >> 16);
	break;
      case 2:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = &word;
	read_word_in_memory();
	lsrt = (lsrt & 0xFF000000) | (word >> 8);
	break;
      case 3:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = &lsrt;
	read_word_in_memory();
	sign_extended(lsrt);
     }
}

void SWR()
{
   unsigned long long int old_word;
   PC++;
   switch ((lsaddr) & 3)
     {
      case 0:
	address = lsaddr;
	byte = (unsigned char)(lsrt << 24);
	write_byte_in_memory();
	break;
      case 1:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = (unsigned long long int *)&old_word;
	read_word_in_memory();
	word = ((unsigned long)lsrt << 16) | (old_word & 0x0000FFFF);
	write_word_in_memory();
	break;
      case 2:
	address = (lsaddr) & 0xFFFFFFFC;
	rdword = (unsigned long long int *)&old_word;
	read_word_in_memory();
	word = ((unsigned long)lsrt << 8) | (old_word & 0x000000FF);
	write_word_in_memory();
	break;
      case 3:
	address = (lsaddr) & 0xFFFFFFFC;
	word = (unsigned long)lsrt;
	write_word_in_memory();
	break;
     }
}

void SD()
{
   PC++;
   address = lsaddr;
   dword = lsrt;
   write_dword_in_memory();
}

void SB()
{
   PC++;
   address = lsaddr;
   byte = (unsigned char)(lsrt & 0xFF);
   write_byte_in_memory();
}

void SH()
{
   PC++;
   address = lsaddr;
   hword = (unsigned short)(lsrt & 0xFFFF);
   write_hword_in_memory();
}

void ADDIU()
{
   irt = irs + iimmediate;
   sign_extended(irt);
   PC++;
}

void DADDIU()
{
   irt = irs + iimmediate;
   PC++;
}

void ADDI()
{
   if ( (((long)(irs)>>31) == ((long)(iimmediate)>>15)) &&
       (((long)(irs)>>31)!=((long)(irs + iimmediate)>>31)))
     integer_overflow_exception();
   else irt = irs + iimmediate;
   sign_extended(irt);
   PC++;
}

void SLTI()
{
   if (irs < iimmediate) irt = 1;
   else irt = 0;
   PC++;
}

void SLTIU()
{
   if ((irs & 0x7FFFFFFFFFFFFFFFLL) < iimmediate) irt = 1;
   else irt = 0;
   PC++;
}

void ANDI()
{
   irt = irs & (iimmediate & 0xFFFF);
   PC++;
}

void XORI()
{
   irt = irs ^ (iimmediate & 0xFFFF);
   PC++;
}

void BNE()
{
   local_rs = irs;
   local_rt = irt;
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if (local_rs != local_rt)
     if (!skip_jump)
       PC += (PC-2)->f.i.immediate-1;
   if (skip_jump) skip_jump=0;
}

void BEQ()
{
   local_rs = irs;
   local_rt = irt;
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if (local_rs == local_rt)
     {
	if (!skip_jump)
	  PC += (PC-2)->f.i.immediate-1;
     }
   if (skip_jump) skip_jump = 0;
}

void BEQ_IDLE()
{
   long skip;
   if (sp_register.halt)
     {
	if (irs == irt)
	  {
	     skip = next_interupt - Count;
	     if (skip >= 3) Count += (skip & 0xFFFFFFFC);
	     else BEQ();
	  }
	else BEQ();
     }
   else BEQ();
}

void BNEL()
{
   if (irs != irt)
     {
	PC++;
	delay_slot=1;
	update_system();
	PC->ops();
	delay_slot=0;
	if(!skip_jump)
	  PC += (PC-2)->f.i.immediate-1;
	else skip_jump=0;
     }
   else
     PC+=2;
}

void BEQL()
{
   if (irs == irt)
     {
	PC++;
	delay_slot=1;
	update_system();
	PC->ops();
	delay_slot=0;
	if (!skip_jump)
	     PC += (PC-2)->f.i.immediate-1;
	else skip_jump = 0;
     }
   else PC+=2;
}

void BLEZL()
{
   if (irs <= 0)
     {
	PC++;
	delay_slot=1;
	update_system();
	PC->ops();
	delay_slot=0;
	if (!skip_jump)
	  PC += (PC-2)->f.i.immediate-1;
	else skip_jump = 0;
     }
   else
     PC+=2;
}

void BGTZL()
{
   if (irs > 0)
     {
	PC++;
	delay_slot=1;
	update_system();
	PC->ops();
	delay_slot=0;
	if (!skip_jump)
	  PC += (PC-2)->f.i.immediate-1;
	else skip_jump = 0;
     }
   else
     PC+=2;
}

void BLEZ()
{
   local_rs = irs;
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if (local_rs <= 0)
     if (!skip_jump)
       PC += (PC-2)->f.i.immediate-1;
   if (skip_jump) skip_jump = 0;
}

void BLEZ_IDLE()
{
   printf("BLEZ_IDLE effectif\n");
}

void BGTZ()
{
   local_rs = irs;
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if (local_rs > 0)
     if (!skip_jump)
       PC += (PC-2)->f.i.immediate-1;
   if (skip_jump) skip_jump = 0;
}

void JAL()
{
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if (!skip_jump)
     {
	reg[31]=PC->addr;
	sign_extended(reg[31]);
	
	jump_to(((PC-2)->f.j.inst_index<<2) | ((PC-1)->addr & 0xF0000000));
     }
   else skip_jump = 0;
}

void J()
{
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if (!skip_jump)
     jump_to(((PC-2)->f.j.inst_index<<2) | ((PC-1)->addr & 0xF0000000));
   else skip_jump = 0;
}

void J_IDLE()
{
   long skip;
   if (sp_register.halt)
     {
	skip = next_interupt - Count;
	if (skip >= 3) Count += (skip & 0xFFFFFFFC);
	else J();
     }
   else J();
}

inline void jump_to(unsigned long addr)
{
   int blk, new_blk=0;
   unsigned long max = 0;
   if ((addr < actual->start) || (addr >= actual->end))
     {
	/*for (i=((actual->debut & 0x1FFFFFFF)>>16); 
	     i<((actual->fin & 0x1FFFFFFF)>>16); i++)
	  {
	     writemem[0x8000 + i] = write_rdram;
	     writemem[0xa000 + i] = write_rdram;
	     writememb[0x8000 + i] = write_rdramb;
	     writememb[0xa000 + i] = write_rdramb;
	     writememd[0x8000 + i] = write_rdramd;
	     writememd[0xa000 + i] = write_rdramd;
	     writememh[0x8000 + i] = write_rdramh;
	     writememh[0xa000 + i] = write_rdramh;
	  }*/
	if ((addr >= int_handler.start) && (addr < int_handler.end))
	  {
	     actual = &int_handler;
	     if (!int_handler.valid)
	       recompile_block(rdram, interrupt, 0x300/4, 0x80000000,
			       &int_handler);
	     PC=actual->block+((addr - int_handler.start)>>2);
	     /*for (i=((actual->debut & 0x1FFFFFFF)>>16); 
		  i<((actual->fin & 0x1FFFFFFF)>>16); i++)
	       {
		  writemem[0x8000 + i] = write_actual_block;
		  writemem[0xa000 + i] = write_actual_block;
		  writememb[0x8000 + i] = write_actual_blockb;
		  writememb[0xa000 + i] = write_actual_blockb;
		  writememd[0x8000 + i] = write_actual_blockd;
		  writememd[0xa000 + i] = write_actual_blockd;
		  writememh[0x8000 + i] = write_actual_blockh;
		  writememh[0xa000 + i] = write_actual_blockh;
	       }*/
	     if (dynacore) dyna_jump(addr);
	     return;
	  }
	for (blk=0; blk<NBR_BLOCKS; blk++)
	  {
	     if (aux[blk].start && 
		 (addr >= aux[blk].start) && (addr < aux[blk].end))
	       {
		  actual = &aux[blk];
		  if (!aux[blk].valid)
		    {
		       if (aux[blk].block) free (aux[blk].block);
		       aux[blk].block = malloc((aux[blk].length/4+1) * 
					       sizeof(precomp_instr));
		       recompile_block(rdram + ((aux[blk].start & 0x1FFFFFFF)>>2),
				       aux[blk].block, aux[blk].length/4,
				       aux[blk].start,
				       &aux[blk]);
		    }
		  PC=actual->block+((addr - aux[blk].start)>>2);
		  /*for (i=((actual->debut & 0x1FFFFFFF)>>16); 
		       i<((actual->fin & 0x1FFFFFFF)>>16); i++)
		    {
		       if (!(actual->vide[(i & 0xFF)]))
			 {
			    writemem[0x8000 + i] = write_actual_block;
			    writemem[0xa000 + i] = write_actual_block;
			    writememb[0x8000 + i] = write_actual_blockb;
			    writememb[0xa000 + i] = write_actual_blockb;
			    writememd[0x8000 + i] = write_actual_blockd;
			    writememd[0xa000 + i] = write_actual_blockd;
			    writememh[0x8000 + i] = write_actual_blockh;
			    writememh[0xa000 + i] = write_actual_blockh;
			 }
		    }*/
		  if (dynacore) dyna_jump(addr);
		  return;
	       }
	  }
	for (blk=0; blk<NBR_BLOCKS; blk++)
	  if (aux[blk].end > max) max = aux[blk].end;
	if (max < addr)
	  {
	     for (i=0; i<NBR_BLOCKS; i++) {
		if (!aux[i].valid && !aux[i].start) {
		   new_blk = i;
		   break;
		}
		if (i==(NBR_BLOCKS-1) && new_blk == 0)
		  printf("erreur d'allocation d'un nouveau block\n");
	     }
	     aux[new_blk].valid = 0;
	     aux[new_blk].start = max + 4;
	     aux[new_blk].end = 0x80400000-4;
	     aux[new_blk].length = aux[new_blk].end - aux[new_blk].start;
	     aux[new_blk].block = malloc((aux[new_blk].length/4+1) * 
				     sizeof(precomp_instr));
	     actual = &aux[new_blk];
	     recompile_block(rdram + ((aux[new_blk].start & 0x1FFFFFFF)>>2),
			     aux[new_blk].block, aux[new_blk].length/4,
			     aux[new_blk].start,
			     &aux[new_blk]);
	     PC=actual->block+((addr - aux[new_blk].start)>>2);
	     if (dynacore) dyna_jump(addr);
	     return;
	  }
	printf("changement de block dans un saut  l'addresse %x de %x\n",
	       (unsigned int)addr, (unsigned int)PC->addr);
	stop=1;
     }
   else
     {
	PC=actual->block+((addr-actual->start)>>2);
	if (dynacore) dyna_jump(addr);
     }
}

inline void update_system()
{  
   if (next_interupt <= Count) gen_vi();
   Count = (++Count) & 0xFFFFFFFF;
#ifdef COMPARE_CORE
   compare_core();
#endif
   
#ifdef DBG
   if (debugger_mode)
     update_debugger();
#endif
   
}

void init_blocks()
{
   sp.start = 0xa4000000;
   sp.end = sp.start + 0x1000;
   sp.length = 0x1000;
   actual=&sp;
   recompile_block(SP_DMEM, boot_code, 0x1000/4, 0xa4000000, &sp);
   int_handler.start = 0x80000000;
   int_handler.end = int_handler.start + 0x300;
   int_handler.length = 0x300;
   actual=&int_handler;
   recompile_block(rdram, interrupt, 0x300/4, 0x80000000, &int_handler);
   for (i=0; i<NBR_BLOCKS; i++) {
      aux[i].start = 0;
      aux[i].valid = 0;
      aux[i].code = NULL;
      aux[i].block = NULL;
   }
   actual=&sp;
   PC=actual->block+(0x40/4);
   
#ifdef DBG
   if (debugger_mode) // debugger shows initial state (before 1st instruction).
     update_debugger();
#endif
}


void go()
{
   long long CRC = 0;
   unsigned int j;
   j=0;
   debug_count = 0;
   printf("demarrage r4300\n");
   memcpy((char *)SP_DMEM+0x40, rom+0x40, 0xFBC);
   delay_slot=0;
   stop = 0;
   for (i=0;i<32;i++)
     {
	reg[i]=0;
	reg_cop0[i]=0;
	reg_cop1_fgr_32[i]=0;
	reg_cop1_fgr_64[i]=0;
	if (dynacore != 2)
	  {
	     if (i<16) reg_cop1_double[i*2]=(double*)&reg_cop1_fgr_32[i*2];
	     reg_cop1_simple[i]=(float *)&reg_cop1_fgr_32[i];
	  }
	else
	  {
	     reg_cop1_double[i]=(double *)&reg_cop1_fgr_64[i];
	     reg_cop1_simple[i]=(float *)&reg_cop1_fgr_64[i];
	  }
	
	// --------------tlb------------------------
	tlb_e[i].mask=0;
	tlb_e[i].vpn2=0;
	tlb_e[i].g=0;
	tlb_e[i].asid=0;
	tlb_e[i].pfn_even=0;
	tlb_e[i].c_even=0;
	tlb_e[i].d_even=0;
	tlb_e[i].v_even=0;
	tlb_e[i].pfn_odd=0;
	tlb_e[i].c_odd=0;
	tlb_e[i].d_odd=0;
	tlb_e[i].v_odd=0;
	tlb_e[i].r=0;
	//tlb_e[i].check_parity_mask=0x1000;
	
	tlb_e[i].start_even=0;
	tlb_e[i].end_even=0;
	tlb_e[i].phys_even=0;
	tlb_e[i].start_odd=0;
	tlb_e[i].end_odd=0;
	tlb_e[i].phys_odd=0;
     }
   for (i=0; i<0x100000; i++)
     {
	tlb_LUT_r[i] = 0;
	tlb_LUT_w[i] = 0;
     }
   llbit=0;
   hi=0;
   lo=0;
   FCR0=0x511;
   FCR31=0;
   
   //--------
   /*reg[20]=1;
   reg[22]=0x3F;
   reg[29]=0xFFFFFFFFA0400000LL;
   Random=31;
   Status=0x70400004;
   Config=0x66463;
   PRevID=0xb00;*/
   //--------
   
   // the following values are extracted from the pj64 source code
   // thanks to Zilmar and Jabo
   
   reg[6] = 0xFFFFFFFFA4001F0C;
   reg[7] = 0xFFFFFFFFA4001F08;
   reg[8] = 0x00000000000000C0;
   reg[10]= 0x0000000000000040;
   reg[11]= 0xFFFFFFFFA4000040;
   reg[29]= 0xFFFFFFFFA4001FF0;
   
   Random = 31;
   Status= 0x34000000;
   Config= 0x6e463;
   PRevID = 0xb00;
   Count = 0x5000;
   Cause = 0x5C;
   Context = 0x7FFFF0;
   EPC = 0xFFFFFFFF;
   BadVAddr = 0xFFFFFFFF;
   ErrorEPC = 0xFFFFFFFF;
   
   for (i = 0x40/4; i < (0x1000/4); i++)
     CRC += SP_DMEM[i];
   switch(CRC) {
    case 0x000000D0027FDF31:
    case 0x000000CFFB631223:
      CIC_Chip = 1;
      break;
    case 0x000000D057C85244:
      CIC_Chip = 2;
      break;
    case 0x000000D6497E414B:
      CIC_Chip = 3;
      break;
    case 0x0000011A49F60E96:
      CIC_Chip = 5;
      break;
    case 0x000000D6D5BE5580:
      CIC_Chip = 6;
      break;
    default:
      CIC_Chip = 2;
   }
   
   switch(ROM_HEADER->Country_code)
     {
      case 0x44:
      case 0x46:
      case 0x49:
      case 0x50:
      case 0x53:
      case 0x55:
      case 0x58:
      case 0x59:
	switch (CIC_Chip) {
	 case 2:
	   reg[5] = 0xFFFFFFFFC0F1D859;
	   reg[14]= 0x000000002DE108EA;
	   break;
	 case 3:
	   reg[5] = 0xFFFFFFFFD4646273;
	   reg[14]= 0x000000001AF99984;
	   break;
	 case 5:
	   SP_IMEM[1] = 0xBDA807FC;
	   reg[5] = 0xFFFFFFFFDECAAAD1;
	   reg[14]= 0x000000000CF85C13;
	   reg[24]= 0x0000000000000002;
	   break;
	 case 6:
	   reg[5] = 0xFFFFFFFFB04DC903;
	   reg[14]= 0x000000001AF99984;
	   reg[24]= 0x0000000000000002;
	   break;
	}
	reg[23]= 0x0000000000000006;
	reg[31]= 0xFFFFFFFFA4001554;
	break;
      case 0x37:
      case 0x41:
      case 0x45:
      case 0x4A:
      default:
	switch (CIC_Chip) {
	 case 2:
	   reg[5] = 0xFFFFFFFFC95973D5;
	   reg[14]= 0x000000002449A366;
	   break;
	 case 3:
	   reg[5] = 0xFFFFFFFF95315A28;
	   reg[14]= 0x000000005BACA1DF;
	   break;
	 case 5:
	   SP_IMEM[1] = 0x8DA807FC;
	   reg[5] = 0x000000005493FB9A;
	   reg[14]= 0xFFFFFFFFC2C20384;
	   break;
	 case 6:
	   reg[5] = 0xFFFFFFFFE067221F;
	   reg[14]= 0x000000005CD2B70F;
	   break;
	}
	reg[20]= 0x0000000000000001;
	reg[24]= 0x0000000000000003;
	reg[31]= 0xFFFFFFFFA4001550;
     }
   switch (CIC_Chip) {
    case 1:
      reg[22]= 0x000000000000003F;
      break;
    case 2:
      reg[1] = 0x0000000000000001;
      reg[2] = 0x000000000EBDA536;
      reg[3] = 0x000000000EBDA536;
      reg[4] = 0x000000000000A536;
      reg[12]= 0xFFFFFFFFED10D0B3;
      reg[13]= 0x000000001402A4CC;
      reg[15]= 0x000000003103E121;
      reg[22]= 0x000000000000003F;
      reg[25]= 0xFFFFFFFF9DEBB54F;
      break;
    case 3:
      reg[1] = 0x0000000000000001;
      reg[2] = 0x0000000049A5EE96;
      reg[3] = 0x0000000049A5EE96;
      reg[4] = 0x000000000000EE96;
      reg[12]= 0xFFFFFFFFCE9DFBF7;
      reg[13]= 0xFFFFFFFFCE9DFBF7;
      reg[15]= 0x0000000018B63D28;
      reg[22]= 0x0000000000000078;
      reg[25]= 0xFFFFFFFF825B21C9;
      break;
    case 5:
      SP_IMEM[0] = 0x3C0DBFC0;
      SP_IMEM[2] = 0x25AD07C0;
      SP_IMEM[3] = 0x31080080;
      SP_IMEM[4] = 0x5500FFFC;
      SP_IMEM[5] = 0x3C0DBFC0;
      SP_IMEM[6] = 0x8DA80024;
      SP_IMEM[7] = 0x3C0BB000;
      reg[2] = 0xFFFFFFFFF58B0FBF;
      reg[3] = 0xFFFFFFFFF58B0FBF;
      reg[4] = 0x0000000000000FBF;
      reg[12]= 0xFFFFFFFF9651F81E;
      reg[13]= 0x000000002D42AAC5;
      reg[15]= 0x0000000056584D60;
      reg[22]= 0x0000000000000091;
      reg[25]= 0xFFFFFFFFCDCE565F;
      break;
    case 6:
      reg[2] = 0xFFFFFFFFA95930A4;
      reg[3] = 0xFFFFFFFFA95930A4;
      reg[4] = 0x00000000000030A4;
      reg[12]= 0xFFFFFFFFBCB59510;
      reg[13]= 0xFFFFFFFFBCB59510;
      reg[15]= 0x000000007A3C07F4;
      reg[22]= 0x0000000000000085;
      reg[25]= 0x00000000465E3F72;
      break;
   }

   next_interupt = 624999;
   init_interupt();

   if (!dynacore)
     {
	printf ("interprtation\n");
	init_blocks();
	while (!stop)
	  {
	     //if ((debug_count+Count) >= 0x500000) break; // obj 0x16aeb8a
	     //if ((debug_count+Count) >= 0x16b1360)
	     /*if ((debug_count+Count) >= 0xf203ae0)
	       {
		  printf ("PC=%x:%x\n", (unsigned int)(PC->addr), 
			  (unsigned int)(rdram[(PC->addr&0xFFFFFF)/4]));
		  for (j=0; j<16; j++)
		    printf ("reg[%2d]:%8x%8x        reg[%d]:%8x%8x\n",   
			    j,
			    (unsigned int)(reg[j] >> 32),
			    (unsigned int)reg[j],
			    j+16,
			    (unsigned int)(reg[j+16] >> 32),
			    (unsigned int)reg[j+16]);
		  printf("hi:%8x%8x        lo:%8x%8x\n",
			 (unsigned int)(hi >> 32),
			 (unsigned int)hi,
			 (unsigned int)(lo >> 32),
			 (unsigned int)lo);
		  printf("aprs %d instructions soit %x\n",(unsigned int)(debug_count+Count)
			 ,(unsigned int)(debug_count+Count));
		  getchar();
	       }*/
	     /*if ((debug_count+Count) >= 0x80000000) 
	       printf("%x:%x, %x\n", (int)PC->addr, 
		      (int)rdram[(PC->addr & 0xFFFFFF)/4],
		      (int)(debug_count+Count));*/
	     PC->ops();
	     update_system();
	     /*if (j!= (Count & 0xFFF00000))
	       {
		  j = (Count & 0xFFF00000);
		  printf("%x\n", j);
	       }*/
	     //check_PC;
	  }
     }
   else if (dynacore == 2)
     {
	dynacore = 0;
	interpcore = 1;
	pure_interpreter();
     }
   else
     {
	dynacore = 1;
	printf("recompilation dynamique\n");
	init_blocks();
	code = (void *)(actual->code+(actual->block[0x40/4].local_addr));
	code();
	PC++;
     }
   debug_count+= Count;
   printf ("PC=%x:%x\n", (unsigned int)(PC->addr), 
	   (unsigned int)(rdram[(PC->addr&0xFFFFFF)/4]));
   for (j=0; j<16; j++)
     printf ("reg[%2d]:%8x%8x        reg[%d]:%8x%8x\n",   
	     j,
	     (unsigned int)(reg[j] >> 32),
	     (unsigned int)reg[j],
	     j+16,
	     (unsigned int)(reg[j+16] >> 32),
	     (unsigned int)reg[j+16]);
   printf("hi:%8x%8x        lo:%8x%8x\n",
	  (unsigned int)(hi >> 32),
	  (unsigned int)hi,
	  (unsigned int)(lo >> 32),
	  (unsigned int)lo);
   printf("aprs %d instructions soit %x\n",(unsigned int)debug_count
	  ,(unsigned int)debug_count);
   for (i=0; i<NBR_BLOCKS; i++)
     {
	if (aux[i].block) {
	   free(aux[i].block);
	   aux[i].block = NULL;
	}
	if (aux[i].code) {
	   free(aux[i].code);
	   aux[i].code = NULL;
	}
     }
   if (sp.code) {
      free(sp.code);
      sp.code = NULL;
   }
   if (int_handler.code) {
      free(int_handler.code);
      int_handler.code = NULL;
   }
}
