#include <windows.h>
#include <stdlib.h>
#define _WIN32_IE 0x0500
#include <commctrl.h>
#include "translation.h"
#include "../../winproject/resource.h"

#define LangFileName "Mupen64.lng"
#define CfgFileName "Mupen64.cfg"
#define IniMupen "mupen64.ini"
static int LastLang = -1;

char * GetLangFileName(void) {
	char path_buffer[_MAX_PATH], drive[_MAX_DRIVE] ,dir[_MAX_DIR];
	char fname[_MAX_FNAME],ext[_MAX_EXT];
	static char IniFileName[_MAX_PATH];

	GetModuleFileName(NULL,path_buffer,sizeof(path_buffer));
	_splitpath( path_buffer, drive, dir, fname, ext );
	sprintf(IniFileName,"%s%s%s",drive,dir,LangFileName);
	return IniFileName;
}

void GetMyPath(char* IniFileName)
{
    char path_buffer[_MAX_PATH], drive[_MAX_DRIVE] ,dir[_MAX_DIR];
	char fname[_MAX_FNAME],ext[_MAX_EXT];
	
	GetModuleFileName(NULL,path_buffer,sizeof(path_buffer));
	_splitpath( path_buffer, drive, dir, fname, ext );
	sprintf(IniFileName,"%s%s",drive,dir);
}

char * GetCfgFileName(void) {
	char path_buffer[_MAX_PATH], drive[_MAX_DRIVE] ,dir[_MAX_DIR];
	char fname[_MAX_FNAME],ext[_MAX_EXT];
	static char CfgFile[_MAX_PATH];

	GetModuleFileName(NULL,path_buffer,sizeof(path_buffer));
	_splitpath( path_buffer, drive, dir, fname, ext );
	sprintf(CfgFile,"%s%s%s",drive,dir,CfgFileName);
	return CfgFile;
}

char * GetIniFileName(void) {
	char path_buffer[_MAX_PATH], drive[_MAX_DRIVE] ,dir[_MAX_DIR];
	char fname[_MAX_FNAME],ext[_MAX_EXT];
	static char IniFile[_MAX_PATH];

	GetModuleFileName(NULL,path_buffer,sizeof(path_buffer));
	_splitpath( path_buffer, drive, dir, fname, ext );
	sprintf(IniFile,"%s%s%s",drive,dir,IniMupen);
	return IniFile;
}

void SelectLang(HWND hWnd, int LangMenuID) {
	char String[800];
	HMENU hMenu = GetMenu(hWnd);
	MENUITEMINFO menuinfo;

	menuinfo.cbSize = sizeof(MENUITEMINFO);
	menuinfo.fMask = MIIM_TYPE;
	menuinfo.fType = MFT_STRING;
	menuinfo.dwTypeData = String;
	menuinfo.cch = sizeof(String);
	GetMenuItemInfo(hMenu,LangMenuID,FALSE,&menuinfo);

	WritePrivateProfileString("Default","Language",String,LangFile);
	if (LastLang != -1) {
		CheckMenuItem( hMenu, LastLang, MF_BYCOMMAND | MFS_UNCHECKED );
	}
	LastLang = LangMenuID;
	CheckMenuItem( hMenu, LastLang, MF_BYCOMMAND | MFS_CHECKED );
}

void SetupIni()
{
    char GoodCode[200], *RP ;
    char *Str;
    char Mypath[MAX_PATH];
    char myIniFile[MAX_PATH];
    char NewIniFIle[MAX_PATH];
    int count;
    Str = (char *)malloc(100000);
    GetMyPath(Mypath);
    sprintf(myIniFile,"%s%s",Mypath,"mupen64.ini");
    sprintf(NewIniFIle,"%s%s",Mypath,"mupen64new2.ini");
    memset(Str,0,40000);
    GetPrivateProfileSectionNames(Str,20000,myIniFile);
        for (count = 1,RP = Str; *RP != 0; RP += strlen(RP) + 1,count++) {
    	    GetPrivateProfileString(RP,"Header Code","",GoodCode,sizeof(GoodCode),myIniFile);
	        WritePrivateProfileString(GoodCode,"Good Code",RP,NewIniFIle);
        }
        sprintf(GoodCode,"%d",count);
        WritePrivateProfileString("pashik","count",GoodCode,NewIniFIle);
     free(Str);  	
}

void SetupLanguages ( HWND hWnd ) {
    char String[800], Language[100], *RP;
	HMENU hMenu = GetMenu(hWnd), hSubMenu,LanguagesPopup;
	MENUITEMINFO menuinfo;
	int count,i;
    //SetupIni();
    GetPrivateProfileString("Default","Language","English",Language,sizeof(Language),LangFile);
	hSubMenu = GetSubMenu(hMenu,0);
	hSubMenu = GetSubMenu(hSubMenu,4);
	menuinfo.cbSize = sizeof(MENUITEMINFO);
	menuinfo.fMask = MIIM_TYPE|MIIM_ID;
	menuinfo.fType = MFT_STRING;
	menuinfo.fState = MFS_ENABLED;
	menuinfo.dwTypeData = String;
	menuinfo.cch = sizeof(hSubMenu);

  	memset(String,0,sizeof(String));
	GetPrivateProfileSectionNames(String,sizeof(String),LangFile);
    for (count = 1,RP = String; *RP != 0; RP += strlen(RP) + 1) {
		if (strcmp(RP,"Default") == 0) { continue; }
		if (strcmp(RP,"English") == 0) { 
		    if (strcmp(Language, "English") == 0) {
		  		    CheckMenuItem(hSubMenu, ID_LANG_ENGLISH, MF_BYCOMMAND | MFS_CHECKED );
		            LastLang = ID_LANG_ENGLISH;
        		}
            continue; 
        }
		menuinfo.dwTypeData = RP;
		menuinfo.cch = strlen(RP) + 1;
		menuinfo.wID = ID_LANG_ENGLISH + count;
		InsertMenuItem(hSubMenu, count++, TRUE, &menuinfo);
		if (strcmp(Language, RP) == 0) {
		  CheckMenuItem(hSubMenu, menuinfo.wID, MF_BYCOMMAND | MFS_CHECKED );
		  LastLang = menuinfo.wID;
        }
	}
}	

void Translate(char* GuiWord,char* Ret)
{
   char Language[100];
   char Path[200];
   GetPrivateProfileString("Default","Language","English",Language,sizeof(Language),LangFile);
   GetPrivateProfileString(Language,"Path","/Lang/english.lng",Path,sizeof(Path),LangFile);
   GetPrivateProfileString(Language,GuiWord,"Not Found",Ret,100,Path);
}

void TranslateDefault(char* GuiWord,char *Default,char* Ret)
{
   char Language[100];
   char Path[200];
   GetPrivateProfileString("Default","Language","English",Language,sizeof(Language),LangFile);
   GetPrivateProfileString(Language,"Path","/Lang/english.lng",Path,sizeof(Path),LangFile);
   GetPrivateProfileString(Language,GuiWord,Default,Ret,100,Path); 
}

void SetItemTranslatedString(HWND hwnd,int ElementID,char* Str)
{
    char String[800];
    Translate(Str,String);  
    if (strcmp(String,"Not Found")!=0) {
     SetDlgItemText( hwnd, ElementID, String );
    } 
    else {
     SetDlgItemText( hwnd, ElementID, Str ); 
    } 
}
void SetItemTranslatedStringDefault(HWND hwnd,int ElementID,char* Str,char*Def)
{
    char String[800];
    TranslateDefault(Str,Def,String);
    SetDlgItemText( hwnd, ElementID, String );
}


void SetStatusTranslatedString(HWND hStatus,int section,char* Str)
{
    char String[800];
    Translate(Str,String);  
    if (strcmp(String,"Not Found")!=0) {
     SendMessage( hStatus, SB_SETTEXT, section, (LPARAM)String );
    } 
    else {
     SendMessage( hStatus, SB_SETTEXT, section, (LPARAM)Str ); 
    }
}

void SetMenuTranslatedString(HMENU hMenu,int elementID,char* Str)
{
    char Language[100], String[800];
    MENUITEMINFO menuinfo;
    Translate(Str,String);
      if (strcmp(String,"Not Found")!=0) {
            memset(&menuinfo, 0, sizeof(MENUITEMINFO));
            menuinfo.cbSize = sizeof(MENUITEMINFO);
            menuinfo.fMask = MIIM_TYPE;
	        menuinfo.fType = MFT_STRING;
	        menuinfo.dwTypeData = String;
	        menuinfo.cch = sizeof(String);
            SetMenuItemInfo(hMenu,elementID,TRUE,&menuinfo);
            }
}

void TranslateMenu(HMENU hMenu,HWND mainHWND)
{
    char Language[100], String[800];
	MENUITEMINFO menuinfo;
    int	menuCount,i;
    HMENU submenu;
    //Main menu
    SetMenuTranslatedString(hMenu,0,"File");
    SetMenuTranslatedString(hMenu,1,"Run");
    SetMenuTranslatedString(hMenu,2,"Options");
    SetMenuTranslatedString(hMenu,3,"Utility");
    SetMenuTranslatedString(hMenu,4,"Help");
    
    //File menu
    submenu = GetSubMenu(hMenu,0) ;
    SetMenuTranslatedString(submenu,0,"Load Rom");
    SetMenuTranslatedString(submenu,1,"Close Rom");
    SetMenuTranslatedString(submenu,2,"Refresh Rom List");
    SetMenuTranslatedString(submenu,4,"Language");
    SetMenuTranslatedString(submenu,6,"Exit");
    
    //Run menu
    submenu = GetSubMenu(hMenu,1);
    SetMenuTranslatedString(submenu,0,"Stop");
    SetMenuTranslatedString(submenu,1,"Continue");
    SetMenuTranslatedString(submenu,3,"Save State");
    SetMenuTranslatedString(submenu,4,"Save as");
    SetMenuTranslatedString(submenu,5,"Restore State");
    SetMenuTranslatedString(submenu,6,"Load");
    SetMenuTranslatedString(submenu,8,"Current Save S&tate");
    
    //Options menu
    submenu = GetSubMenu(hMenu,2);
    SetMenuTranslatedString(submenu,0,"Configure");
    SetMenuTranslatedString(submenu,2,"Video Settings");
    SetMenuTranslatedString(submenu,3,"Input Settings");
    SetMenuTranslatedString(submenu,4,"Audio Settings");
    SetMenuTranslatedString(submenu,6,"Full Screen");

    //Help menu
    submenu = GetSubMenu(hMenu,3);
    SetMenuTranslatedString(submenu,0,"Rom Properties");
    SetMenuTranslatedString(submenu,2,"Audit Roms");
        
    //Help menu
    submenu = GetSubMenu(hMenu,4);
    SetMenuTranslatedString(submenu,0,"Contents");
    SetMenuTranslatedString(submenu,1,"Whats new");
    SetMenuTranslatedString(submenu,3,"About");
    DrawMenuBar(mainHWND);
}

void TranslateConfigDialog(HWND hwnd)
{
    char String[800];
    Translate("Emulation Options",String);
    SetWindowText(hwnd,String);
    
    SetItemTranslatedString(hwnd,IDC_INTERP,"Interpreter");
    SetItemTranslatedString(hwnd,IDC_RECOMP,"Dynamic Recompiler");
    SetItemTranslatedString(hwnd,IDC_PURE_INTERP,"Pure Interpreter");
    SetItemTranslatedString(hwnd,IDC_CPUCORE,"CPU Core");
    
    SetItemTranslatedString(hwnd,IDC_GFXPLUGIN,"GFX Plugin");
    SetItemTranslatedString(hwnd,IDGFXCONFIG,"Config");
    SetItemTranslatedString(hwnd,IDGFXTEST,"Test");
    SetItemTranslatedString(hwnd,IDGFXABOUT,"CONFIG_About");
    
    SetItemTranslatedString(hwnd,IDC_INPUTPLUGIN,"Input Plugin");
    SetItemTranslatedString(hwnd,IDINPUTCONFIG,"Config");
    SetItemTranslatedString(hwnd,IDINPUTTEST,"Test");
    SetItemTranslatedString(hwnd,IDINPUTABOUT,"CONFIG_About");
    
    SetItemTranslatedString(hwnd,IDC_SOUNDPLUGIN,"Sound Plugin");
    SetItemTranslatedString(hwnd,IDSOUNDCONFIG,"Config");
    SetItemTranslatedString(hwnd,IDSOUNDTEST,"Test");
    SetItemTranslatedString(hwnd,IDSOUNDABOUT,"CONFIG_About");
}

void TranslateRomBrowserConfig(HWND hwnd)
{
    SetItemTranslatedString(hwnd,IDC_ROMS_DIRECTORIES,"Roms Directories");
    SetItemTranslatedString(hwnd,IDC_ADD_BROWSER_DIR,"Add");
    SetItemTranslatedString(hwnd,IDC_REMOVE_BROWSER_DIR,"Remove");
    SetItemTranslatedString(hwnd,IDC_REMOVE_BROWSER_ALL,"Remove All");
    SetItemTranslatedString(hwnd,IDC_RECURSION,"Use Directory recursion");
}

void TranslateRomInfoDialog(HWND hwnd)
{
    char tmp[200];
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_HEADER_INFO_TEXT,"Rom Information","Rom Information");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_FULLPATH_TEXT,"File Location","File Location");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_GOODNAME_TEXT,"Good Name","Good Name");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_INTERNAL_NAME_TEXT,"Internal Name","Internal Name");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_SIZE_TEXT,"Size","Size");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_COUNTRY_TEXT,"Country","Country");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_INICODE_TEXT,"Ini Code","Ini Code");
    SetItemTranslatedStringDefault(hwnd,IDC_ROM_MD5_TEXT,"MD5 Checksum","MD5 Checksum");
    SetItemTranslatedStringDefault(hwnd,IDC_MD5_CALCULATE,"Calculate","Calculate");
    SetItemTranslatedStringDefault(hwnd,IDC_INI_COMMENTS_TEXT,"Comments","Comments");
    SetItemTranslatedString(hwnd,IDC_OK,"Ok");
    SetItemTranslatedString(hwnd,IDC_CANCEL,"Cancel");
    TranslateDefault("ROM Properties","ROM Properties",tmp);
    SetWindowText(hwnd,tmp);
}

void TranslateRomBrowserMenu(HMENU hMenu)
{
    SetMenuTranslatedString(hMenu,0,"Play Game");
    SetMenuTranslatedString(hMenu,1,"Rom Properties");
    SetMenuTranslatedString(hMenu,3,"Refresh");
}

void TranslateAuditDialog(HWND hwnd)
{
    char tmp[200];
    SetItemTranslatedString(hwnd,IDC_TOTAL_ROMS_TEXT,"Total Roms");
    SetItemTranslatedString(hwnd,IDC_CURRENT_ROM_TEXT,"Current rom");
    SetItemTranslatedString(hwnd,IDC_ROM_FULLPATH_TEXT,"File Location");
    SetItemTranslatedString(hwnd,IDC_START,"Start");
    SetItemTranslatedString(hwnd,IDC_STOP,"Stop");
    SetItemTranslatedString(hwnd,IDC_CLOSE,"Close");
    TranslateDefault("Audit Roms","Audit Roms",tmp);
    SetWindowText(hwnd,tmp);
}
