/**
 * Mupen64 - special.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "r4300.h"
#include "interupt.h"
#include "../memory/memory.h"
#include "ops.h"
#include "exception.h"
#include "macros.h"

void NOP()
{
   PC++;
}

void SLL()
{
   rrd = (unsigned long)(rrt) << rsa;
   sign_extended(rrd);
   PC++;
}

void DSLL32()
{
   rrd = rrt << (32+rsa);
   PC++;
}

void SLLV()
{
   rrd = (unsigned long)(rrt) << (rrs&0x1F);
   sign_extended(rrd);
   PC++;
}

void SRL()
{
   rrd = (unsigned long)rrt >> rsa;
   sign_extended(rrd);
   PC++;
}

void SRA()
{
   rrd = (signed long)rrt >> rsa;
   sign_extended(rrd);
   PC++;
}

void DSRA()
{
   rrd = rrt >> rsa;
   PC++;
}

void DSLL()
{
   rrd = rrt << rsa;
   PC++;
}

void DSRA32()
{
   rrd = (signed long long int)rrt >> (32+rsa);
   PC++;
}

void SRLV()
{
   rrd = (unsigned long)rrt >> (rrs & 0x1F);
   sign_extended(rrd);
   PC++;
}

void SRAV()
{
   rrd = (signed long)rrt >> (rrs & 0x1F);
   sign_extended(rrd);
   PC++;
}

void DSRAV()
{
   rrd = rrt >> (rrs & 0x3F);
   PC++;
}

void DSRLV()
{
   rrd = rrt >> (rrs & 0x3F);
   PC++;
}

void DSLLV()
{
   rrd = rrt << (rrs&0x3F);
   PC++;
}

void OR()
{
   rrd = rrs | rrt;
   PC++;
}

void NOR()
{
   rrd = ~(rrs | rrt);
   PC++;
}

void XOR()
{
   rrd = rrs ^ rrt;
   PC++;
}

void AND()
{
   rrd = rrs & rrt;
   PC++;
}

void ADD()
{
   if(((long)(rrs)>>31)==((long)(rrt)>>31)
      && (((long)(rrs)>>31)!=((long)(rrs+rrt)>>31)))
     integer_overflow_exception();
   else rrd = rrs + rrt;
   sign_extended(rrd);
   PC++;
}

void ADDU()
{
   rrd = rrs + rrt;
   sign_extended(rrd);
   PC++;
}

void MFLO()
{
   rrd = lo;
   PC++;
}

void MFHI()
{
   rrd = hi;
   PC++;
}

void MTLO()
{
   lo = rrs;
   PC++;
}

void MTHI()
{
   hi = rrs;
   PC++;
}

void MULTU()
{
   unsigned long long int temp;
   temp = (rrs & 0xFFFFFFFF) * (rrt & 0xFFFFFFFF);
   hi = temp >> 32;
   sign_extended(hi);
   lo = temp & 0xFFFFFFFF;
   sign_extended(lo);
   PC++;
}

void MULT()
{
   unsigned long long int temp;
   temp = rrs * rrt;
   hi = temp >> 32;
   sign_extended(hi);
   lo = temp & 0xFFFFFFFF;
   sign_extended(lo);
   PC++;
}

void DMULTU()
{
   unsigned long long int op1, op2, op3, op4;
   unsigned long long int result1, result2, result3, result4;
   unsigned long long int temp1, temp2, temp3, temp4;
   
   /*op1 = rrs & 0xFFFFFFFF;
   op2 = (rrs >> 32) & 0xFFFFFFFF;
   op3 = rrt & 0xFFFFFFFF;
   op4 = (rrt >> 32) & 0xFFFFFFFF;
   
   temp1 = op1 * op3;
   temp2 = (temp1 >> 32) + op1 * op4;
   temp3 = op2 * op3;
   temp4 = (temp1 >> 32) + op2 * op4;
   
   result1 = temp1 & 0xFFFFFFFF;
   result2 = (temp2 & 0xFFFFFFFF) + (temp3 & 0xFFFFFFFF);
   result3 = (result2 >> 32) + (temp2 >> 32) + (temp4 & 0xFFFFFFFF);
   result4 = (result3 >> 32) + (temp4 >> 32);
   result2 &= 0xFFFFFFFF;
   result3 &= 0xFFFFFFFF;
   
   lo = result1 | (result2 << 32);
   hi = result3 | (result4 << 32);*/
   op1 = rrs & 0xFFFFFFFF;
   op2 = (rrs >> 32) & 0xFFFFFFFF;
   op3 = rrt & 0xFFFFFFFF;
   op4 = (rrt >> 32) & 0xFFFFFFFF;
   
   temp1 = op1 * op3;
   temp2 = (temp1 >> 32) + op1 * op4;
   temp3 = op2 * op3;
   temp4 = (temp3 >> 32) + op2 * op4;
   
   result1 = temp1;
   result2 = (result1 >> 32) + temp2 + temp3;
   result3 = (result2 >> 32) + temp4;
   result4 = (result3 >> 32);
   
   lo = (result1 & 0xFFFFFFFF) | (result2 << 32);
   hi = (result3 & 0xFFFFFFFF) | (result4 << 32);
   PC++;
}

void DMULT()
{
   unsigned long long int op1, op2, op3, op4;
   unsigned long long int result1, result2, result3, result4;
   unsigned long long int temp1, temp2, temp3, temp4;
   
   op1 = rrs & 0xFFFFFFFF;
   op2 = (rrs >> 32) & 0xFFFFFFFF;
   op3 = rrt & 0xFFFFFFFF;
   op4 = (rrt >> 32) & 0xFFFFFFFF;
   
   temp1 = op1 * op3;
   temp2 = (temp1 >> 32) + op1 * op4;
   temp3 = op2 * op3;
   temp4 = (temp1 >> 32) + op2 * op4;
   
   result1 = temp1 & 0xFFFFFFFF;
   result2 = (temp2 & 0xFFFFFFFF) + (temp3 & 0xFFFFFFFF);
   result3 = (result2 >> 32) + (temp2 >> 32) + (temp4 & 0xFFFFFFFF);
   result4 = (result3 >> 32) + (temp4 >> 32);
   result2 &= 0xFFFFFFFF;
   result3 &= 0xFFFFFFFF;
   
   lo = result1 | (result2 << 32);
   hi = result3 | (result4 << 32);
   PC++;
}

void DDIVU()
{
   if (rrt)
     {
	lo = (unsigned long long int)rrs / (unsigned long long int)rrt;
	hi = (unsigned long long int)rrs % (unsigned long long int)rrt;
     }
   else printf("ddivu\n");
   PC++;
}

void DDIV()
{
   if (rrt)
     {
	lo = (long long int)rrs / (long long int)rrt;
	hi = (long long int)rrs % (long long int)rrt;
     }
   else printf("ddiv\n");
   PC++;
}

void DIV()
{
   if (rrt)
     {
	lo = rrs / rrt;
	hi = rrs % rrt;
     }
   else printf("div\n");
   PC++;
}

void DIVU()
{
   if (rrt)
     {
	lo = rrs / rrt;
	hi = rrs % rrt;
     }
   else printf("divu\n");
   PC++;
}

void SUBU()
{
   rrd = rrs - rrt;
   sign_extended(rrd);
   PC++;
}

void SUB()
{
   if(((long)(rrs)>>31)==((long)(~rrt)>>31)
      && (((long)(rrs)>>31)!=((long)(rrs-rrt)>>31)))
     integer_overflow_exception();
   else rrd = rrs - rrt;
   sign_extended(rrd);
   PC++;
}

void SLT()
{
   if (rrs < rrt) rrd = 1;
   else rrd = 0;
   PC++;
}

void SLTU()
{
   if ((rrs&0xFFFFFFFFFFFFFFFLL) < (rrt&0xFFFFFFFFFFFFFFFLL)) 
     rrd = 1;
   else rrd = 0;
   PC++;
}

void JR()
{
   local_rs = irs;
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if (!skip_jump)
     jump_to(local_rs);
   else skip_jump = 0;
}

void JALR()
{
   local_rs = rrs;
   PC++;
   delay_slot=1;
   update_system();
   PC->ops();
   delay_slot=0;
   if (!skip_jump)
     {
	*(PC-2)->f.r.rd = PC->addr;
	sign_extended(*(PC-2)->f.r.rd);
	
	jump_to(local_rs);
     }
   else skip_jump = 0;
}
