/**
 * Mupen64 - cop0.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "r4300.h"
#include "macros.h"
#include "ops.h"
#include "interupt.h"

void MTC0()
{
   switch(PC->f.r.nrd)
     {
      case 0:    // Index
	Index = rrt & 0x000000008000003F;
	if ((Index & 0x3F) > 31) 
	  {
	     printf ("il y a plus de 32 TLB\n");
	     stop=1;
	  }
	break;
      case 1:    // Random
	break;
      case 2:    // EntryLo0
	EntryLo0 = rrt & 0x3FFFFFFF;
	break;
      case 3:    // EntryLo1
 	EntryLo1 = rrt & 0x3FFFFFFF;
	break;
      case 4:    // Context
	Context = rrt & 0xFFFFFFFFFF800000LL;
	break;
      case 5:    // PageMask
	PageMask = rrt & 0x01FFE000;
	break;
      case 6:    // Wired
	printf("criture dans Wired\n");
	stop=1;
	Wired = rrt;
	Random = 31;
	break;
      case 8:    // BadVAddr
	break;
      case 9:    // Count
	if (Compare > Count) printf("criture dans Count non vrifie\n");
	debug_count += Count;
	Count = rrt & 0xFFFFFFFF;
	debug_count -= Count;
	break;
      case 10:   // EntryHi
	EntryHi = rrt & 0xC00000FFFFFFE0FFLL;
	break;
      case 11:   // Compare
	if (rrt > Count)
	  {
	     if (rrt < next_interupt)
	       {
		  interupt_type=1;
		  save_next_interupt = next_interupt;
		  next_interupt = (unsigned long)Compare-1;
	       }
	  }
	Compare = rrt;
	Cause = Cause & 0xFFFFFFFFFFFF7FFFLL; //Timer interupt is clear
	break;
      case 12:   // Status
	if((rrt & 0x04000000) != (Status & 0x04000000))
	  {
	     if (rrt & 0x04000000)
	       {
		  int i;
		  for (i=0; i<32; i++)
		    {
		       if (reg_cop1_fgr_32[i])
			 {
			    printf("erreur de conversion 32 vers 64 bits\n");
			    stop=1;
			 }
		    }
	       }
	     else
	       {
		  int i;
		  for (i=0; i<32; i++)
		    {
		       if (reg_cop1_fgr_64[i])
			 {
			    printf("erreur de conversion 64 vers 32 bits\n");
			    stop=1;
			 }
		    }
	       }
	  }
	Status = rrt;
	if (rrt & 0xFF01)
	  {
	     PC++;
	     interupt();
	     PC--;
	  }
	break;
      case 13:   // Cause
	if (rrt!=0)
	  {
	     printf("criture dans Cause\n");
	     stop = 1;
	  }
	else Cause = rrt;
	break;
      case 14:   // EPC
	EPC = rrt;
	break;
      case 15:  // PRevID
	break;
      case 0x1B: // CacheErr
	break;
      case 0x1C: // TagLo
	TagLo = rrt & 0x0FFFFFC0;
	break;
      case 0x1D: // TagHi
	TagHi =0;
	break;
      default:
	printf("ecriture dans cop0 inconnue  PC=%x !!!\n", (unsigned int)(PC->addr));
	stop=1;
     }
   PC++;
}

void MFC0()
{
   switch(PC->f.r.nrd)
     {
      case 1:
	printf("lecture de Random\n");
	stop=1;
      default:
	rrt = rrd & 0xFFFFFFFF;
	sign_extended(rrt);
     }
   PC++;
}

void CACHE()
{
   PC++;
}
