#include <windows.h>
#include <stdlib.h>
#define _WIN32_IE 0x0500
#include <commctrl.h>
#include "translation.h"
#include "../../winproject/resource.h"

#define LangFileName "Mupen64.lng"


char * GetLangFileName(void) {
	char path_buffer[_MAX_PATH], drive[_MAX_DRIVE] ,dir[_MAX_DIR];
	char fname[_MAX_FNAME],ext[_MAX_EXT];
	static char IniFileName[_MAX_PATH];

	GetModuleFileName(NULL,path_buffer,sizeof(path_buffer));
	_splitpath( path_buffer, drive, dir, fname, ext );
	sprintf(IniFileName,"%s%s%s",drive,dir,LangFileName);
	return IniFileName;
}

void SelectLang(HWND hWnd, int LangMenuID) {
	char String[800];
	HMENU hMenu = GetMenu(hWnd);
	MENUITEMINFO menuinfo;

	menuinfo.cbSize = sizeof(MENUITEMINFO);
	menuinfo.fMask = MIIM_TYPE;
	menuinfo.fType = MFT_STRING;
	menuinfo.dwTypeData = String;
	menuinfo.cch = sizeof(String);
	GetMenuItemInfo(hMenu,LangMenuID,FALSE,&menuinfo);

	WritePrivateProfileString("Default","Language",String,LangFile);
	if (LastLang != -1) {
		CheckMenuItem( hMenu, LastLang, MF_BYCOMMAND | MFS_UNCHECKED );
	}
	LastLang = LangMenuID;
	CheckMenuItem( hMenu, LastLang, MF_BYCOMMAND | MFS_CHECKED );
}

void SetupLanguages ( HWND hWnd ) {
	char String[800], Language[100], *RP;
	HMENU hMenu = GetMenu(hWnd), hSubMenu,LanguagesPopup;
	MENUITEMINFO menuinfo;
	int count,i;
    GetPrivateProfileString("Default","Language","English",Language,sizeof(Language),LangFile);
	hSubMenu = GetSubMenu(hMenu,0);
	hSubMenu = GetSubMenu(hSubMenu,3);
	menuinfo.cbSize = sizeof(MENUITEMINFO);
	menuinfo.fMask = MIIM_TYPE|MIIM_ID;
	menuinfo.fType = MFT_STRING;
	menuinfo.fState = MFS_ENABLED;
	menuinfo.dwTypeData = String;
	menuinfo.cch = sizeof(hSubMenu);

  	memset(String,0,sizeof(String));
	GetPrivateProfileSectionNames(String,sizeof(String),LangFile);	
	for (count = 1,RP = String; *RP != 0; RP += strlen(RP) + 1) {
		if (strcmp(RP,"Default") == 0) { continue; }
		if (strcmp(RP,"English") == 0) { 
		    if (strcmp(Language, "English") == 0) {
		  		    CheckMenuItem(hSubMenu, ID_LANG_ENGLISH, MF_BYCOMMAND | MFS_CHECKED );
		            LastLang = ID_LANG_ENGLISH;
        		}
            continue; 
        }
		menuinfo.dwTypeData = RP;
		menuinfo.cch = strlen(RP) + 1;
		menuinfo.wID = ID_LANG_ENGLISH + count;
		InsertMenuItem(hSubMenu, count++, TRUE, &menuinfo);
		if (strcmp(Language, RP) == 0) {
		  CheckMenuItem(hSubMenu, menuinfo.wID, MF_BYCOMMAND | MFS_CHECKED );
		  LastLang = menuinfo.wID;
        }
	}
}	

void Translate(char* GuiWord,char* Ret)
{
   char Language[100];
   GetPrivateProfileString("Default","Language","English",Language,sizeof(Language),LangFile);
   GetPrivateProfileString(Language,GuiWord,"Not Found",Ret,100,LangFile);
}

void TranslateDefault(char* GuiWord,char *Default,char* Ret)
{
   char Language[100];
   GetPrivateProfileString("Default","Language","English",Language,sizeof(Language),LangFile);
   GetPrivateProfileString(Language,GuiWord,Default,Ret,100,LangFile); 
}

void SetItemTranslatedString(HWND hwnd,int ElementID,char* Str)
{
    char String[800];
    Translate(Str,String);  
    if (strcmp(String,"Not Found")!=0) {
     SetDlgItemText( hwnd, ElementID, String );
    } 
    else {
     SetDlgItemText( hwnd, ElementID, Str ); 
    } 
}

void SetStatusTranslatedString(HWND hStatus,int section,char* Str)
{
    char String[800];
    Translate(Str,String);  
    if (strcmp(String,"Not Found")!=0) {
     SendMessage( hStatus, SB_SETTEXT, section, (LPARAM)String );
    } 
    else {
     SendMessage( hStatus, SB_SETTEXT, section, (LPARAM)Str ); 
    }
}

void SetMenuTranslatedString(HMENU hMenu,int elementID,char* Str)
{
    char Language[100], String[800];
    MENUITEMINFO menuinfo;
    Translate(Str,String);
      if (strcmp(String,"Not Found")!=0) {
            memset(&menuinfo, 0, sizeof(MENUITEMINFO));
            menuinfo.cbSize = sizeof(MENUITEMINFO);
            menuinfo.fMask = MIIM_TYPE;
	        menuinfo.fType = MFT_STRING;
	        menuinfo.dwTypeData = String;
	        menuinfo.cch = sizeof(String);
            SetMenuItemInfo(hMenu,elementID,TRUE,&menuinfo);
            }
}

void TranslateMenu(HMENU hMenu,HWND mainHWND)
{
    char Language[100], String[800];
	MENUITEMINFO menuinfo;
    int	menuCount,i;
    HMENU submenu;
    //Main menu
    SetMenuTranslatedString(hMenu,0,"File");
    SetMenuTranslatedString(hMenu,1,"Run");
    SetMenuTranslatedString(hMenu,2,"Options");
    SetMenuTranslatedString(hMenu,3,"Help");
    
    //File menu
    submenu = GetSubMenu(hMenu,0) ;
    SetMenuTranslatedString(submenu,0,"Load Rom");
    SetMenuTranslatedString(submenu,1,"Close Rom");
    SetMenuTranslatedString(submenu,3,"Language");
    SetMenuTranslatedString(submenu,5,"Exit");
    
    //Run menu
    submenu = GetSubMenu(hMenu,1);
    SetMenuTranslatedString(submenu,0,"Stop");
    SetMenuTranslatedString(submenu,1,"Continue");
    
    //Options menu
    submenu = GetSubMenu(hMenu,2);
    SetMenuTranslatedString(submenu,0,"Configure");
    SetMenuTranslatedString(submenu,2,"Video Settings");
    SetMenuTranslatedString(submenu,3,"Input Settings");
    SetMenuTranslatedString(submenu,5,"Full Screen");
    
    //Help menu
    submenu = GetSubMenu(hMenu,3);
    SetMenuTranslatedString(submenu,0,"Contents");
    SetMenuTranslatedString(submenu,1,"Whats new");
    SetMenuTranslatedString(submenu,3,"About");
    DrawMenuBar(mainHWND);
}

void TranslateConfigDialog(HWND hwnd)
{
    char String[800];
    Translate("Emulation Options",String);
    SetWindowText(hwnd,String);
    SetItemTranslatedString(hwnd,IDC_INTERP,"Interpreter");
    SetItemTranslatedString(hwnd,IDC_RECOMP,"Dynamic Recompiler");
    SetItemTranslatedString(hwnd,IDC_PURE_INTERP,"Pure Interpreter");
    SetItemTranslatedString(hwnd,IDC_CPUCORE,"CPU Core");
    SetItemTranslatedString(hwnd,IDC_GFXPLUGIN,"GFX Plugin");
    SetItemTranslatedString(hwnd,IDGFXCONFIG,"Config");
    SetItemTranslatedString(hwnd,IDGFXTEST,"Test");
    SetItemTranslatedString(hwnd,IDGFXABOUT,"CONFIG_About");
    SetItemTranslatedString(hwnd,IDC_INPUTPLUGIN,"Input Plugin");
    SetItemTranslatedString(hwnd,IDINPUTCONFIG,"Config");
    SetItemTranslatedString(hwnd,IDINPUTTEST,"Test");
    SetItemTranslatedString(hwnd,IDINPUTABOUT,"CONFIG_About");
}

void TranslateRomBrowserConfig(HWND hwnd)
{
    SetItemTranslatedString(hwnd,IDC_ROMS_DIRECTORIES,"Roms Directories");
    SetItemTranslatedString(hwnd,IDC_ADD_BROWSER_DIR,"Add");
    SetItemTranslatedString(hwnd,IDC_REMOVE_BROWSER_DIR,"Remove");
    SetItemTranslatedString(hwnd,IDC_REMOVE_BROWSER_ALL,"Remove All");
}

