#include <windows.h>
#define _WIN32_IE 0x0500
#include <commctrl.h>
#include <stdlib.h>
#include <dirent.h>
#include "../../winproject/resource.h"
#include "../plugin.h"
#include "../rom.h"
#include "../../r4300/r4300.h"
#include "../../memory/memory.h"
#include "translation.h"
#include "rombrowser.h"
#include "main_win.h"
#include "configdialog.h"
#include "../guifuncs.h"

/*#ifdef __CYGWIN__
WinMainCRTStartup() { mainCRTStartup(); }
#endif*/

 

CONTROL Controls[4];

static GFX_INFO gfx_info;
static CONTROL_INFO control_info;

void (*getDllInfo)(PLUGIN_INFO *PluginInfo);
void (*dllConfig)(HWND hParent);
void (*dllTest)(HWND hParent);
void (*dllAbout)(HWND hParent);

void (*changeWindow)();
void (*closeDLL_gfx)();
void (*initiateGFX)(GFX_INFO Gfx_Info);
void (*processDList)();
void (*processRDPList)();
void (*romClosed_gfx)();
void (*romOpen_gfx)();
void (*showCFB)();
void (*updateScreen)();
void (*viStatusChanged)();
void (*viWidthChanged)();
void (*moveScreen)(int xpos, int ypos);

void (*closeDLL_input)();
void (*controllerCommand)(int Control, BYTE * Command);
void (*getKeys)(int Control, BUTTONS *Keys);
void (*initiateControllers)(CONTROL_INFO ControlInfo);
void (*old_initiateControllers)(HWND hMainWindow, CONTROL Controls[4]);
void (*readController)(int Control, BYTE *Command);
void (*romClosed_input)();
void (*romOpen_input)();
void (*keyDown)(WPARAM wParam, LPARAM lParam);
void (*keyUp)(WPARAM wParam, LPARAM lParam);

static DWORD WINAPI ThreadFunc(LPVOID lpParam);

const char g_szClassName[] = "myWindowClass";
static int app_nCmdShow;

void display_loading_progress(int p)
{
   Translate("Loading Rom",TempMessage);
   sprintf(TempMessage,"%s: %d%%",TempMessage,p);
   SendMessage( hStatus, SB_SETTEXT, 1, (LPARAM)TempMessage );  
}

static char currentpath[_MAX_DIR];
char *get_currentpath()
{
    char drive[_MAX_DRIVE], dirn[_MAX_DIR];
	char fname[_MAX_FNAME], ext[_MAX_EXT];
    char path_buffer[_MAX_PATH];
    
    GetModuleFileName(NULL, path_buffer, sizeof(path_buffer));
    _splitpath(path_buffer, drive, dirn, fname, ext);
    strcpy(currentpath, drive);
    strcat(currentpath, dirn);
    return currentpath;
}

BOOL PluginsChanged ( HWND hwnd ) {

    char tmp[_MAX_PATH];
    int index;
    //Checking GFX plugin
    index = SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETCURSEL, 0, 0);
    SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETLBTEXT, index, (LPARAM)tmp);
    if(_stricmp(gfx_name,tmp) != 0) { return TRUE; }
    
    //Checking control plugin 	
    index = SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETCURSEL, 0, 0);
	SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETLBTEXT, index, (LPARAM)tmp);
    if(_stricmp(input_name,tmp) != 0) { return TRUE; }
   	return FALSE;
}  

static void sucre()
{
   //printf("sucre\n");
}

//--------------------- plugin storage type ----------------
typedef struct _plugins plugins;
struct _plugins
{
    char *file_name;
    char *plugin_name;
    HMODULE handle;
    int type;
    plugins *next;
};
static plugins *liste_plugins = NULL, *current;

void insert_plugin(plugins *p, char *file_name,
		   char *plugin_name, void *handle, int type,int num)
{
    if (p->next)
        insert_plugin(p->next, file_name, plugin_name, handle, type, 
                               (p->type == type) ? num+1 : num);
    else
    {
        p->next = malloc(sizeof(plugins));
        p->next->type = type;
        p->next->handle = handle;
        p->next->file_name = malloc(strlen(file_name)+1);
        strcpy(p->next->file_name, file_name);
        p->next->plugin_name = malloc(strlen(plugin_name)+7);
        sprintf(p->next->plugin_name, "%d - %s", 
                                      num+((p->type == type) ? 2 : 1), plugin_name);
        p->next->next=NULL;
    }
}

void rewind_plugin()
{
   current = liste_plugins;
}

char *next_plugin()
{
   if (!current->next) return NULL;
   current = current->next;
   return current->plugin_name;
}

int get_plugin_type()
{
   if (!current->next) return -1;
   return current->next->type;
}

void *get_handle(plugins *p, char *name)
{
   if (!strcmp(p->next->plugin_name, name))
     return p->next->handle;
   return get_handle(p->next, name);
}
char* getExtension(char *str)
{
    if (strlen(str) > 3) return str + strlen(str) - 3;
    else return NULL;
}

void search_plugins(char *cmd)
{
    
    char drive[_MAX_DRIVE], dirn[_MAX_DIR];
	char fname[_MAX_FNAME], ext[_MAX_EXT];
    DIR *dir;
    char cwd[_MAX_DIR];
    char name[_MAX_DIR];
    struct dirent *entry;
   
    liste_plugins = malloc(sizeof(plugins));
    liste_plugins->type = -1;
    liste_plugins->next = NULL;
    
    _splitpath(cmd, drive, dirn, fname, ext);
    strcpy(cwd, drive);
    strcat(cwd, dirn);
    strcat(cwd, "plugin");

    dir = opendir(cwd);
    while((entry = readdir(dir)) != NULL)
    {
        HMODULE handle;
       
        strcpy(name, cwd);
        strcat(name, "\\");
        strcat(name, entry->d_name);
        
        if (getExtension(entry->d_name) != NULL && strcmp(getExtension(entry->d_name),"dll")==0) {
        handle = LoadLibrary(name);
        if (handle)
        {
            PLUGIN_INFO PluginInfo;
            getDllInfo = (void(__cdecl*)(PLUGIN_INFO *PluginInfo))GetProcAddress(handle, "GetDllInfo");
            if (getDllInfo)
            {
                getDllInfo(&PluginInfo);
                insert_plugin(liste_plugins, name, PluginInfo.Name, 
                                             handle, PluginInfo.Type, 0);
                                       
            }
        }
      }
    }
    current = liste_plugins;
}

void exec_config(char *name)
{
   HMODULE handle;
   
   handle = get_handle(liste_plugins, name);
   dllConfig = (void(__cdecl*)(HWND hParent))GetProcAddress(handle, "DllConfig");
   if (dllConfig) dllConfig(hwnd_plug);
}

void exec_test(char *name)
{
   HMODULE handle;
   
   handle = get_handle(liste_plugins, name);
   dllTest = (void(__cdecl*)(HWND hParent))GetProcAddress(handle, "DllTest");
   if (dllTest) dllTest(hwnd_plug);
}

void exec_about(char *name)
{
   HMODULE handle;
   
   handle = get_handle(liste_plugins, name);
   dllAbout = (void(__cdecl*)(HWND hParent))GetProcAddress(handle, "DllAbout");
   if (dllAbout) dllAbout(hwnd_plug);
}

void load_plugins(char *gfx_name, char *input_name)
{
   int i, version;
   void *handle_gfx, *handle_input;
   PLUGIN_INFO PluginInfo;
   char s[1000];
   handle_gfx = get_handle(liste_plugins, gfx_name);
   changeWindow = (void(__cdecl*)())GetProcAddress(handle_gfx, "ChangeWindow");
   closeDLL_gfx = (void(__cdecl*)())GetProcAddress(handle_gfx, "CloseDLL");
   dllAbout = (void(__cdecl*)(HWND hParent))GetProcAddress(handle_gfx, "DllAbout");
   dllConfig = (void(__cdecl*)(HWND hParent))GetProcAddress(handle_gfx, "DllConfig");
   dllTest = (void(__cdecl*)(HWND hParent))GetProcAddress(handle_gfx, "DllTest");
   initiateGFX = (void(__cdecl*)(GFX_INFO Gfx_Info))GetProcAddress(handle_gfx, "InitiateGFX");
   processDList = (void(__cdecl*)())GetProcAddress(handle_gfx, "ProcessDList");
   processRDPList = (void(__cdecl*)())GetProcAddress(handle_gfx, "ProcessRDPList");
   romClosed_gfx = (void(__cdecl*)())GetProcAddress(handle_gfx, "RomClosed");
   romOpen_gfx = (void(__cdecl*)())GetProcAddress(handle_gfx, "RomOpen");
   showCFB = (void(__cdecl*)())GetProcAddress(handle_gfx, "ShowCFB");
   updateScreen = (void(__cdecl*)())GetProcAddress(handle_gfx, "UpdateScreen");
   viStatusChanged = (void(__cdecl*)())GetProcAddress(handle_gfx, "ViStatusChanged");
   viWidthChanged = (void(__cdecl*)())GetProcAddress(handle_gfx, "ViWidthChanged");
   moveScreen = (void(__cdecl*)())GetProcAddress(handle_gfx, "MoveScreen");
   

   handle_input = get_handle(liste_plugins, input_name);
   getDllInfo = (void(__cdecl*)(PLUGIN_INFO *PluginInfo))GetProcAddress(handle_input, "GetDllInfo");
   getDllInfo(&PluginInfo);
   
   closeDLL_input = (void(__cdecl*)())GetProcAddress(handle_input, "CloseDLL");
   controllerCommand = (void(__cdecl*)(int Control, BYTE * Command))GetProcAddress(handle_input, "ControllerCommand");
   getKeys = (void(__cdecl*)(int Control, BUTTONS *Keys))GetProcAddress(handle_input, "GetKeys");
   if (PluginInfo.Version == 0x0101)
       initiateControllers = (void(__cdecl*)(CONTROL_INFO ControlInfo))GetProcAddress(handle_input, "InitiateControllers");
   else
       old_initiateControllers = (void(__cdecl*)(HWND hMainWindow, CONTROL Controls[4]))GetProcAddress(handle_input, "InitiateControllers");
   readController = (void(__cdecl*)(int Control, BYTE *Command))GetProcAddress(handle_input, "ReadController");
   romClosed_input = (void(__cdecl*)())GetProcAddress(handle_input, "RomClosed");
   romOpen_input = (void(__cdecl*)())GetProcAddress(handle_input, "RomOpen");
   keyDown = (void(__cdecl*)(WPARAM wParam, LPARAM lParam))GetProcAddress(handle_input, "WM_KeyDown");
   keyUp = (void(__cdecl*)(WPARAM wParam, LPARAM lParam))GetProcAddress(handle_input, "WM_KeyUp");
   
   control_info.hMainWindow = hwnd_thread;
   control_info.hinst = app_hInstance;
   control_info.MemoryBswaped = TRUE;
   control_info.HEADER = rom;
   control_info.Controls = Controls;
   for (i=0; i<4; i++)
     {
	Controls[i].Present = FALSE;
	Controls[i].RawData = FALSE;
	Controls[i].Plugin = PLUGIN_NONE;
     }
   if (PluginInfo.Version == 0x0101)
      {
        initiateControllers(control_info);
      } 
   else
      {
        old_initiateControllers(mainHWND, Controls);
      } 


   gfx_info.hWnd = hwnd_thread;
   gfx_info.hStatusBar = hStatus ;
   gfx_info.MemoryBswaped = TRUE;
   gfx_info.HEADER = rom;
   gfx_info.RDRAM = (BYTE*)rdram;
   gfx_info.DMEM = (BYTE*)SP_DMEM;
   gfx_info.IMEM = (BYTE*)SP_IMEM;
   gfx_info.MI_INTR_REG = &(MI_register.mi_intr_reg);
   gfx_info.DPC_START_REG = &(dpc_register.dpc_start);
   gfx_info.DPC_END_REG = &(dpc_register.dpc_end);
   gfx_info.DPC_CURRENT_REG = &(dpc_register.dpc_current);
   gfx_info.DPC_STATUS_REG = &(dpc_register.dpc_status);
   gfx_info.DPC_CLOCK_REG = &(dpc_register.dpc_clock);
   gfx_info.DPC_BUFBUSY_REG = &(dpc_register.dpc_bufbusy);
   gfx_info.DPC_PIPEBUSY_REG = &(dpc_register.dpc_pipebusy);
   gfx_info.DPC_TMEM_REG = &(dpc_register.dpc_tmem);
   gfx_info.VI_STATUS_REG = &(vi_register.vi_status);
   gfx_info.VI_ORIGIN_REG = &(vi_register.vi_origin);
   gfx_info.VI_WIDTH_REG = &(vi_register.vi_width);
   gfx_info.VI_INTR_REG = &(vi_register.vi_v_intr);
   gfx_info.VI_V_CURRENT_LINE_REG = &(vi_register.vi_current);
   gfx_info.VI_TIMING_REG = &(vi_register.vi_burst);
   gfx_info.VI_V_SYNC_REG = &(vi_register.vi_v_sync);
   gfx_info.VI_H_SYNC_REG = &(vi_register.vi_h_sync);
   gfx_info.VI_LEAP_REG = &(vi_register.vi_leap);
   gfx_info.VI_H_START_REG = &(vi_register.vi_h_start);
   gfx_info.VI_V_START_REG = &(vi_register.vi_v_start);
   gfx_info.VI_V_BURST_REG = &(vi_register.vi_v_burst);
   gfx_info.VI_X_SCALE_REG = &(vi_register.vi_x_scale);
   gfx_info.VI_Y_SCALE_REG = &(vi_register.vi_y_scale);
   gfx_info.CheckInterrupts = sucre;
   initiateGFX(gfx_info);
}


void closeRom()
{
      ResumeThread(EmuThreadHandle);
      stop_it();
      CloseHandle(EmuThreadHandle);
      SetWindowText(mainHWND,MUPEN_VERSION);
      SetStatusTranslatedString(hStatus,0,"Rom Closed");
}

void setDefaultPlugins() 
{
      DWORD  Type,Bytes = sizeof(TempMessage) ;
      sprintf(TempMessage,"Software\\N64 Emulation\\%s",AppName);
	  lResult = RegOpenKeyEx( HKEY_CURRENT_USER,TempMessage,0,KEY_ALL_ACCESS,
	                         	&hKeyResults);
     
	  if (lResult == ERROR_SUCCESS) {
		lResult = RegQueryValueEx(hKeyResults,"Gfx Plugin",0,&Type,gfx_name,&Bytes);
	  }
	  RegCloseKey(hKeyResults);	
      if ((lResult!=ERROR_SUCCESS)||(gfx_name==""))
      {
      rewind_plugin(); 
            while(current->next)
                 {
                         if (get_plugin_type()==PLUGIN_TYPE_GFX)  {
                         strcpy(gfx_name, current->next->plugin_name);
                         break;
                         }
                         else {
                         next_plugin();
                         }                 
                  }
       }
    
      Bytes = sizeof(TempMessage) ;
      lResult = RegOpenKeyEx( HKEY_CURRENT_USER,TempMessage,0,KEY_ALL_ACCESS,
	                         	&hKeyResults);
      if (lResult == ERROR_SUCCESS) {
		lResult = RegQueryValueEx(hKeyResults,"Input Plugin",0,&Type,input_name,&Bytes);
      }
 	  
       RegCloseKey(hKeyResults);	
       if ((lResult!=ERROR_SUCCESS)||(input_name==""))
       {
             rewind_plugin();  
             
             while(current->next)
                 {
                        if (get_plugin_type()==PLUGIN_TYPE_CONTROLLER)  {
                         strcpy(input_name, current->next->plugin_name);
                         break;
                         }
                         else {
                         next_plugin();
                         }                 
                  }
        }          
              rewind_plugin();
}           

void ShowMessage(LPSTR lpszMessage) 
{ 
   MessageBox(NULL, lpszMessage, "Error", MB_OK); 
} 

void drawStatusAndToolbars(HWND hwnd)
{
   	    
			TBBUTTON tbb[9];
			TBADDBITMAP tbab;
            TBBUTTONINFO tbi;
            LPTBBUTTONINFO lptbbi;
            int statwidths[] = {200, 400,-1};
            
			// Create Toolbar

			hTool = CreateWindowEx(
                                0,
                                TOOLBARCLASSNAME,
                                NULL,
                                WS_CHILD | WS_VISIBLE | TBSTYLE_FLAT | TBSTYLE_TRANSPARENT | TBSTYLE_TOOLTIPS
			                    | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | CCS_NODIVIDER,
                                0, 0,
                                0, 0,
                                hwnd, (HMENU)IDC_TOOLBAR,
                                app_hInstance,NULL);
			if(hTool == NULL)
				MessageBox(hwnd, "Could not create tool bar.", "Error", MB_OK | MB_ICONERROR);

			// Send the TB_BUTTONSTRUCTSIZE message, which is required for
			// backward compatibility.
			
            SendMessage(hTool, TB_BUTTONSTRUCTSIZE, (WPARAM)sizeof(TBBUTTON), 0);
			
			tbab.hInst = app_hInstance;
			tbab.nID = IDB_TOOLBAR;
			SendMessage(hTool, TB_ADDBITMAP, (WPARAM)sizeof(TBBUTTON), (LPARAM)&tbab);

			ZeroMemory(tbb, sizeof(tbb));
			tbb[0].iBitmap = 0;
			tbb[0].fsState = TBSTATE_ENABLED;
			tbb[0].fsStyle = TBSTYLE_BUTTON;
			tbb[0].idCommand = IDLOAD;
                       
			tbb[1].fsStyle = TBSTYLE_SEP;
						
            tbb[2].iBitmap = 1;
			tbb[2].fsState = TBSTATE_ENABLED;
			tbb[2].fsStyle = TBSTYLE_CHECKGROUP;
			tbb[2].idCommand = EMU_RESUME; 

			tbb[3].iBitmap = 2;
			tbb[3].fsState = TBSTATE_ENABLED;
			tbb[3].fsStyle = TBSTYLE_CHECKGROUP;
			tbb[3].idCommand = EMU_STOP;
           
            tbb[4].iBitmap = 3;
			tbb[4].fsState = TBSTATE_ENABLED;
			tbb[4].fsStyle = TBSTYLE_CHECKGROUP;
			tbb[4].idCommand = CLOSE_ROM;
            
            tbb[5].fsStyle = TBSTYLE_SEP; 
            
			tbb[6].iBitmap = 4;
			tbb[6].fsState = TBSTATE_ENABLED;
			tbb[6].fsStyle = TBSTYLE_BUTTON;
			tbb[6].idCommand = FULL_SCREEN;
			
			tbb[7].fsStyle = TBSTYLE_SEP; 
            
			tbb[8].iBitmap = 5;
			tbb[8].fsState = TBSTATE_ENABLED;
			tbb[8].fsStyle = TBSTYLE_BUTTON;
			tbb[8].idCommand = ID_LOAD_CONFIG;
			
		   	SendMessage(hTool, TB_ADDBUTTONS, sizeof(tbb)/sizeof(TBBUTTON), (LPARAM)&tbb);
		   	
	   		// Create Status bar

			hStatus = CreateWindowEx(0, STATUSCLASSNAME, NULL,
				WS_CHILD | WS_VISIBLE | SBARS_SIZEGRIP, 0, 0, 0, 0,
				hwnd, (HMENU)IDC_MAIN_STATUS, GetModuleHandle(NULL), NULL);

			SendMessage(hStatus, SB_SETPARTS, sizeof(statwidths)/sizeof(int), (LPARAM)statwidths);
}

static DWORD WINAPI ThreadFunc(LPVOID lpParam)
{
    ShowRomBrowser(FALSE);
    dynacore = guiDynacore;
    sound_init() ;
    init_memory() ;
    load_plugins(gfx_name, input_name);
    romOpen_gfx();
    plugins_loaded = 1;
    romOpen_input();
    go();
    romClosed_input();
    plugins_loaded = 0;
    romClosed_gfx();
    closeDLL_input();
    closeDLL_gfx();
    free_sound();
    free(rom);
    rom = NULL;
    free(ROM_HEADER);
    ROM_HEADER = NULL;
    free_memory();
    emu_launched = 0;
    ShowRomBrowser(TRUE);
    ExitThread(dwExitCode);
    //SendMessage(hwnd_thread, WM_CLOSE, 0x8080, 0);
}

BOOL StartRom(char fullRomPath[_MAX_PATH])
{
     if (!emu_launched) {
                         emu_launched = 1;
                         if (rom_read(fullRomPath))
                         {
                             emu_launched = 0;
                             return TRUE;
                         }
                         
                         hwnd_thread = mainHWND;
                         EmuThreadHandle = CreateThread(NULL, 0, ThreadFunc, NULL, 0, &Id);
                         sprintf(TempMessage, "%s - %s",MUPEN_VERSION, ROM_HEADER->nom);
                         SendMessage(hTool, TB_CHECKBUTTON, EMU_RESUME, 1);
                         SetWindowText(mainHWND,TempMessage);
                         SetStatusTranslatedString(hStatus,0,"Emulation started");
                         SendMessage( hStatus, SB_SETTEXT, 1, (LPARAM)"" ); 
                     }
}
void exit_emu()
{
   freeRomDirList();
   freeRomList();
   if (!emu_launched) 
         PostQuitMessage (0);
     else {
         ResumeThread(EmuThreadHandle);
         stop_it();
         Sleep(500);
         PostQuitMessage (0);
   }
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
     char path_buffer[_MAX_PATH], s[1000];
     int index;
     HWND hwndCombo;
     OPENFILENAME oifn;
     int ret;
     switch(Message)
     {
       case WM_KEYDOWN:
            switch (wParam)
            {
             case VK_F1:
               {
                
                if (emu_launched)
                {  
                    FullScreenMode=1-FullScreenMode;
                    changeWindow();
                }  
               }  
                break;
             default:
                if (emu_launched) keyDown(wParam, lParam);
             break;    
            }
            break;
        case WM_KEYUP:
                if (emu_launched) keyUp(wParam, lParam);
                break;   
        case WM_NOTIFY:
            if (wParam == IDC_ROMLIST) { 
             RomListNotify((LPNMHDR)lParam); 
            }
           return 0;
		case WM_MOVE:
            if (emu_launched&&!FullScreenMode) {
                     moveScreen(wParam, lParam);
                    }
            break;
        case WM_SIZE:
             if (!FullScreenMode) {
              SendMessage(hTool, TB_AUTOSIZE, 0, 0);
              SendMessage(hStatus, WM_SIZE, 0, 0);  
              ResizeRomListControl();      
             } 
            break;  
        case WM_USER + 17:  SetFocus(mainHWND); break;      
        case WM_CREATE:
            // searching the plugins...........
            GetModuleFileName(NULL, path_buffer, sizeof(path_buffer));
            search_plugins(path_buffer);
            setDefaultPlugins(); 
            drawStatusAndToolbars(hwnd) ;
           
            SetupLanguages(hwnd);
            TranslateMenu(GetMenu(hwnd),hwnd);
            CreateRomListControl(hwnd);
            ////////////////////////////
            return TRUE;
        case WM_CLOSE:
             exit_emu();
             break;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDGFXCONFIG:
                     hwnd_plug = hwnd;
                     exec_config(gfx_name);
                     break;
                case IDINPUTCONFIG:
                     hwnd_plug = hwnd;
                     exec_config(input_name);
                     break;
                case CLOSE_ROM:
                 if (emu_launched) {
                       closeRom();
                       }
                 else
                    {
                      SendMessage(hTool, TB_CHECKBUTTON, CLOSE_ROM, 0);                  
                    }      
                 break;
                
                case EMU_STOP:
                 if (emu_launched) {
                       SuspendThread(EmuThreadHandle);
                       SetStatusTranslatedString(hStatus,0,"Emulation paused");
                       }
                  else
                     {
                       SendMessage(hTool, TB_CHECKBUTTON, EMU_STOP, 0);
                     }     
                break;
                
                case EMU_RESUME:
                 if (emu_launched) {
                       ResumeThread(EmuThreadHandle);
                       SetStatusTranslatedString(hStatus,0,"Emulation started");
                       }
                    else
                    {
                        SendMessage(hTool, TB_CHECKBUTTON, EMU_RESUME, 0);                
                    }
                 break;
                
                case ID_LOAD_CONFIG:
                 if (emu_launched) {
                  SuspendThread(EmuThreadHandle);
                 };
                 ChangeSettings(hwnd);
                 if (emu_launched) {
                  ResumeThread(EmuThreadHandle);
                 }
                 break;
                case ID_HELP_ABOUT:
                     ret = DialogBox(GetModuleHandle(NULL), 
                     MAKEINTRESOURCE(IDD_ABOUT), hwnd, AboutDlgProc);
                     break;
                case ID_HELP_CONTENS:
                     TranslateDefault("Index","index.html",TempMessage);
                     ShellExecute(hwnd, "open", TempMessage, NULL, NULL, SW_SHOWNORMAL);           
                     break;
                case ID_HELP_WHATSNEW:
                     TranslateDefault("WhatsNew","whatsnew.txt",TempMessage);
                     ShellExecute(hwnd, "open", TempMessage, NULL, NULL, SW_SHOWNORMAL);           
                     break;
                case IDLOAD:   
                     ZeroMemory(&oifn, sizeof(OPENFILENAME));
                     oifn.lStructSize = sizeof(OPENFILENAME);
                     oifn.hwndOwner = NULL;
                     strcpy(path_buffer,"");
                     oifn.lpstrFile = path_buffer,
                     oifn.nMaxFile = sizeof(path_buffer);
                     oifn.lpstrFilter = ".n64 Files\0*.n64\0.rom Files\0*.rom\0.v64 Files\0*.v64\0.z64 Files\0*.z64\0Nintendo 64 Rom Files\0*.v64;*.rom;*.bin;*.z64;*n64;*.zip;*.usa;*.jap;*.eur\0";
                     oifn.nFilterIndex = 5;
                     oifn.lpstrFileTitle = "Mupen64: Author: Hacktarux - Co-Author: Pir4nhaX";
                     oifn.nMaxFileTitle = 0;
                     oifn.lpstrInitialDir = "";
                     oifn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
                     GetOpenFileName(&oifn);
                     StartRom(path_buffer);
                     break;
                case ID_EMULATOR_EXIT:
                     exit_emu();
                     break; 
                case FULL_SCREEN:
                     if (emu_launched)
                     {  
                       FullScreenMode=1-FullScreenMode;
                       changeWindow();
                     } 
                     break;
                default :
                     //Language Support  from ID_LANG_ENGLISH to ID_LANG_ENGLISH+100
                     if (LOWORD(wParam) >= ID_LANG_ENGLISH && LOWORD(wParam) <= (ID_LANG_ENGLISH + 100)) {
		                SelectLang(hwnd,LOWORD(wParam));		     
                        TranslateMenu(GetMenu(hwnd),hwnd);
                        TranslateBrowserHeader(hRomList);
                     }
			         break;    
            }
            break;
       default:
            return DefWindowProc(hwnd, Message, wParam, lParam);
    }
    return TRUE;	
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                             LPSTR lpCmdLine, int nCmdShow)
{
    int WindowWidth=640,WindowHeight=480,X,Y;
    WNDCLASSEX wc;
	HWND hwnd;
	MSG Msg;
    app_hInstance = hInstance;
    InitCommonControls(); 
                               
	wc.cbSize		 = sizeof(WNDCLASSEX);
	wc.style		 = 0;
	wc.lpfnWndProc	 = WndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;
	wc.hIcon		 = LoadIcon(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_MYICON));
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW-5);
	wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MYMENU);
	wc.lpszClassName = g_szClassName;
	wc.hIconSm		 = (HICON)LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_MYICON), IMAGE_ICON, 16, 16, 0);
    
    if(!RegisterClassEx(&wc))
	{
		MessageBox(NULL, "Window Registration Failed!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return 0;
	}
        
    X = (GetSystemMetrics( SM_CXSCREEN ) - WindowWidth) / 2;
	Y = (GetSystemMetrics( SM_CYSCREEN ) - 480) / 2;
    
    LangFile = GetLangFileName();
    emu_launched = 0;
    
	hwnd = CreateWindowEx(
		0 ,
		g_szClassName,
		MUPEN_VERSION,
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
		X, Y, WindowWidth, WindowHeight,
		NULL, NULL, hInstance, NULL);
    
     
    if(hwnd == NULL)
	{
		MessageBox(NULL, "Window Creation Failed!", "Error!",
			MB_ICONEXCLAMATION | MB_OK);
		return 0;
	}
    mainHWND = hwnd ;
	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	while(GetMessage(&Msg, NULL, 0, 0) > 0)
	{
	   	TranslateMessage(&Msg);
		DispatchMessage(&Msg);
	}
	return Msg.wParam;

}

