#include <windows.h>
#include <shlobj.h>
#include "main_win.h"
#include "../../winproject/resource.h"
#include "configdialog.h"
#include "../plugin.h"
#include "rombrowser.h"

void ChangeSettings(HWND hwndOwner) {
    PROPSHEETPAGE psp[2];
    PROPSHEETHEADER psh;
	char ConfigStr[200],RomBrowserStr[200],titleStr[200];
    psp[0].dwSize = sizeof(PROPSHEETPAGE);
    psp[0].dwFlags = PSP_USETITLE;
    psp[0].hInstance = app_hInstance;
    psp[0].pszTemplate = MAKEINTRESOURCE(IDD_MAIN);
    psp[0].pfnDlgProc = CfgDlgProc;
	Translate("Config Plugins",ConfigStr);
	psp[0].pszTitle = ConfigStr;
    psp[0].lParam = 0;
    psp[0].pfnCallback = NULL;

    psp[1].dwSize = sizeof(PROPSHEETPAGE);
    psp[1].dwFlags = PSP_USETITLE;
    psp[1].hInstance = app_hInstance;
    psp[1].pszTemplate = MAKEINTRESOURCE(IDD_ROMBROWSER);
    psp[1].pfnDlgProc = RomBrowserCfg;
	Translate("Rom Browser",RomBrowserStr);
    psp[1].pszTitle = RomBrowserStr;
    psp[1].lParam = 0;
    psp[1].pfnCallback = NULL;

    psh.dwSize = sizeof(PROPSHEETHEADER);
    psh.dwFlags = PSH_PROPSHEETPAGE | PSH_NOAPPLYNOW;
    psh.hwndParent = hwndOwner;
    psh.hInstance = app_hInstance;
    Translate("Settings",titleStr);
    psh.pszCaption = (LPSTR) titleStr;
    psh.nPages = sizeof(psp) / sizeof(PROPSHEETPAGE);
    psh.nStartPage = 0;
    psh.ppsp = (LPCPROPSHEETPAGE) &psp;
    psh.pfnCallback = NULL;

	PropertySheet(&psh);
	return;
}

BOOL CALLBACK AboutDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
             SendDlgItemMessage(hwnd, IDC_LOGO, STM_SETIMAGE, IMAGE_BITMAP, 
                (LPARAM)LoadImage (GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_LOGO), 
                            IMAGE_BITMAP, 0, 0, 0));
        return TRUE;
        
        case WM_CLOSE:
              EndDialog(hwnd, IDOK);  
        break;
        
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDOK:
                    EndDialog(hwnd, IDOK);
                break;
            }
        break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK RomBrowserCfg(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  char Buffer[MAX_PATH], Directory[255], Title[255];
    LPITEMIDLIST pidl;
	BROWSEINFO bi;
    char RomBrowserDir[_MAX_PATH]; 
    HWND RomBrowserDirListBox;
    int count;
    int selected;
    switch(Message)
    {
        case WM_INITDIALOG:
                FillRomBrowserDirBox(hwnd);
                TranslateRomBrowserConfig(hwnd);
                break;                 
        case WM_NOTIFY:
                if (((NMHDR FAR *) lParam)->code == PSN_APPLY) {
                    SaveRomBrowserDirs();            
                }
               break;
        case WM_COMMAND:
		        switch (LOWORD(wParam)) 
                { 
		          case IDC_ADD_BROWSER_DIR : 
		               bi.hwndOwner = hwnd;
					   bi.pidlRoot = NULL;
				       bi.pszDisplayName = Buffer;
				       Translate("Select Current Rom Browser Directory",TempMessage);
				       bi.lpszTitle = TempMessage;
				       bi.ulFlags = BIF_RETURNFSANCESTORS | BIF_RETURNONLYFSDIRS;
				       bi.lpfn = NULL;
				       bi.lParam = 0;
                       if ((pidl = SHBrowseForFolder(&bi)) != NULL) {
					     if (SHGetPathFromIDList(pidl, Directory)) {
						 int len = strlen(Directory);
                		if (Directory[len - 1] != '\\') 
                              { strcat(Directory,"\\"); 
                                SetRomDirectory(Directory, TRUE);
                                SendDlgItemMessage(hwnd, IDC_ROMBROWSER_DIR_LIST, LB_ADDSTRING, 0, (LPARAM)Directory);
			                    addDirectoryToLinkedList(Directory); 
                                AddDirToList(Directory,TRUE);
                                //RefreshRomBrowser();
                              }
                        }
                       }       
				  break; 
				  
				  case IDC_REMOVE_BROWSER_DIR :
                  	RomBrowserDirListBox = GetDlgItem(hwnd, IDC_ROMBROWSER_DIR_LIST);
					count = SendMessage(RomBrowserDirListBox, LB_GETSELCOUNT, 0, 0);
					if(count != 0)
						{
							selected = SendMessage(RomBrowserDirListBox, LB_GETCURSEL , 0, 0);
	        				SendMessage(RomBrowserDirListBox, LB_GETTEXT, selected, (LPARAM)RomBrowserDir);		
                            removeDirectoryFromLinkedList(RomBrowserDir);
                            SendMessage(RomBrowserDirListBox, LB_DELETESTRING, selected, 0);
							RefreshRomBrowser();
						}
						else 
						{
							MessageBox(hwnd, "No items selected.", "Warning", MB_OK);
						}
				  
 				  break;
				  
				  case IDC_REMOVE_BROWSER_ALL :
				        SendDlgItemMessage(hwnd, IDC_ROMBROWSER_DIR_LIST, LB_RESETCONTENT, 0, 0);
				        freeRomDirList();
				        RefreshRomBrowser();
				  break;
                }
	    break;
    
    }	        
    return FALSE;
}

BOOL CALLBACK CfgDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
    char path_buffer[_MAX_PATH], s[1000];
    int index,Response;
    char String[200]; 
                          
    switch(Message)
    {
        case WM_CLOSE:
              EndDialog(hwnd, IDOK);  
        break;
        case WM_INITDIALOG:
            CheckDlgButton(hwnd, IDC_PURE_INTERP, BST_CHECKED);
            rewind_plugin();           
            while(get_plugin_type() != -1)
                switch (get_plugin_type())
                {
                case PLUGIN_TYPE_GFX:
                    SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_ADDSTRING, 0, (LPARAM)next_plugin());
                    break;
                case PLUGIN_TYPE_CONTROLLER:
                    SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_ADDSTRING, 0, (LPARAM)next_plugin());
                    break;
                default:
                    next_plugin();
                }
            index = SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_FINDSTRINGEXACT, 0, (LPARAM)gfx_name);
            SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_SETCURSEL, index, 0);
            index = SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_FINDSTRINGEXACT, 0, (LPARAM)input_name);
            SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_SETCURSEL, index, 0);
            TranslateConfigDialog(hwnd);
            return TRUE;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {
                case IDGFXCONFIG:
                     hwnd_plug = hwnd;
                     index = SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETCURSEL, 0, 0);
                     SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETLBTEXT, index, (LPARAM)path_buffer);
                     exec_config(path_buffer);
                     break;
                case IDGFXTEST:
                     hwnd_plug = hwnd;
                     index = SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETCURSEL, 0, 0);
                     SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETLBTEXT, index, (LPARAM)path_buffer);
                     exec_test(path_buffer);
                     break;
                case IDGFXABOUT:
                     hwnd_plug = hwnd;
                     index = SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETCURSEL, 0, 0);
                     SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETLBTEXT, index, (LPARAM)path_buffer);
                     exec_about(path_buffer);
                     break;
                case IDINPUTCONFIG:
                     hwnd_plug = hwnd;
                     index = SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETCURSEL, 0, 0);
                     SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETLBTEXT, index, (LPARAM)path_buffer);
                     exec_config(path_buffer);
                     break;
                case IDINPUTTEST:
                     hwnd_plug = hwnd;
                     index = SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETCURSEL, 0, 0);
                     SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETLBTEXT, index, (LPARAM)path_buffer);
                     exec_test(path_buffer);
                     break;
                case IDINPUTABOUT:
                     hwnd_plug = hwnd;
                     index = SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETCURSEL, 0, 0);
                     SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETLBTEXT, index, (LPARAM)path_buffer);
                     exec_about(path_buffer);
                     break;
                
                case IDC_INTERP:
                     if (!emu_launched)
                         guiDynacore = 0;
                         coreChanged = TRUE;
                     break;
                case IDC_RECOMP:
                     if (!emu_launched)
                         guiDynacore = 1;
                         coreChanged = TRUE;
                     break;
                case IDC_PURE_INTERP:
                     if (!emu_launched)
                         guiDynacore = 2;
                         coreChanged = TRUE;
                     break;
            }
            break;
        case WM_NOTIFY:
		             if (((NMHDR FAR *) lParam)->code == PSN_APPLY) {
		                 if ((coreChanged||PluginsChanged(hwnd))&& (emu_launched)){
                              strcpy(String,"Changing the plugins or core will reset the current rom.\n\nDo you want to continue?");
                              Response = MessageBox(hwnd,String,"Change Plugins",MB_YESNO|MB_ICONQUESTION);
				              if (Response != IDYES) { break; }
				              coreChanged = FALSE;
                              ResumeThread(EmuThreadHandle);
                              closeRom();
				         }
                         index = SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETCURSEL, 0, 0);
                         SendDlgItemMessage(hwnd, IDC_COMBO_GFX, CB_GETLBTEXT, index, (LPARAM)gfx_name);
                         //************Saving to registry gfx plugin name
                         sprintf(String,"Software\\N64 Emulation\\%s",AppName);
                         lResult = RegCreateKeyEx( HKEY_CURRENT_USER,String,0,"",
				         REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hKeyResults,&Disposition);
                         if (lResult == ERROR_SUCCESS) { 
						 RegSetValueEx(hKeyResults,"Gfx Plugin",0,REG_SZ,(CONST BYTE *)gfx_name,strlen(gfx_name));
						 }
						 RegCloseKey(hKeyResults);
                         //************	
                         
                         index = SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETCURSEL, 0, 0);
                         SendDlgItemMessage(hwnd, IDC_COMBO_INPUT, CB_GETLBTEXT, index, (LPARAM)input_name);
                         
                         //************Saving to registry control plugin name
                         sprintf(String,"Software\\N64 Emulation\\%s",AppName);
                         lResult = RegCreateKeyEx( HKEY_CURRENT_USER,String,0,"",
				         REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hKeyResults,&Disposition);
                         if (lResult == ERROR_SUCCESS) { 
						 RegSetValueEx(hKeyResults,"Input Plugin",0,REG_SZ,(CONST BYTE *)input_name,strlen(input_name));
						 }
						 RegCloseKey(hKeyResults);
                         //************	           
                     }
                     break;
        default:
            return FALSE;
    }
    return TRUE;
}

