/**
 * Mupen64 - plugin.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <dlfcn.h>
#include <stdio.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "winlnxdefs.h"
#include "plugin.h"
#include "rom.h"
#include "../memory/memory.h"
#include "../r4300/interupt.h"

CONTROL Controls[4];

static GFX_INFO gfx_info;
static CONTROL_INFO control_info;

void (*getDllInfo)(PLUGIN_INFO *PluginInfo);
void (*dllConfig)(HWND hParent);
void (*dllTest)(HWND hParent);
void (*dllAbout)(HWND hParent);

void (*changeWindow)();
void (*closeDLL_gfx)();
void (*initiateGFX)(GFX_INFO Gfx_Info);
void (*processDList)();
void (*processRDPList)();
void (*romClosed_gfx)();
void (*romOpen_gfx)();
void (*showCFB)();
void (*updateScreen)();
void (*viStatusChanged)();
void (*viWidthChanged)();

void (*closeDLL_input)();
void (*controllerCommand)(int Control, BYTE * Command);
void (*getKeys)(int Control, BUTTONS *Keys);
void (*initiateControllers)(CONTROL_INFO ControlInfo);
void (*readController)(int Control, BYTE *Command);
void (*romClosed_input)();
void (*romOpen_input)();
void (*keyDown)(WPARAM wParam, LPARAM lParam);
void (*keyUp)(WPARAM wParam, LPARAM lParam);

//--------------------- plugin storage type ----------------
typedef struct _plugins plugins;
struct _plugins
{
   char *file_name;
   char *plugin_name;
   void *handle;
   int type;
   plugins *next;
};
static plugins *liste_plugins = NULL, *current;

void insert_plugin(plugins *p, char *file_name,
		   char *plugin_name, void *handle, int type,int num)
{
   if (p->next)
     insert_plugin(p->next, file_name, plugin_name, handle, type, 
		   (p->type == type) ? num+1 : num);
   else
     {
	p->next = malloc(sizeof(plugins));
	p->next->type = type;
	p->next->handle = handle;
	p->next->file_name = malloc(strlen(file_name)+1);
	strcpy(p->next->file_name, file_name);
	p->next->plugin_name = malloc(strlen(plugin_name)+7);
	sprintf(p->next->plugin_name, "%d - %s", 
		num+((p->type == type) ? 2 : 1), plugin_name);
	p->next->next=NULL;
     }
}

void rewind_plugin()
{
   current = liste_plugins;
}

char *next_plugin()
{
   if (!current->next) return NULL;
   current = current->next;
   return current->plugin_name;
}

int get_plugin_type()
{
   if (!current->next) return -1;
   return current->next->type;
}

void *get_handle(plugins *p, char *name)
{
   if (!strcmp(p->next->plugin_name, name))
     return p->next->handle;
   return get_handle(p->next, name);
}

static void sucre()
{
   //printf("sucre\n");
}

void search_plugins(char *cmd)
{
   DIR *dir;
   char cwd[1024];
   struct dirent *entry;
   
   liste_plugins = malloc(sizeof(plugins));
   liste_plugins->type = -1;
   liste_plugins->next = NULL;
   
   strcpy(cwd, cmd);
   strcat(cwd, "plugins");
   dir = opendir(cwd);
   while((entry = readdir(dir)) != NULL)
     {
	void *handle;
	char *name;
	
	name = malloc(strlen(cwd)+1+strlen(entry->d_name)+1);
	strcpy(name, cwd);
	strcat(name, "/");
	strcat(name, entry->d_name);
	handle = dlopen(name, RTLD_NOW);
	if (handle)
	  {
	     PLUGIN_INFO PluginInfo;
	     getDllInfo = dlsym(handle, "GetDllInfo");
	     if (getDllInfo)
	       {
		  getDllInfo(&PluginInfo);
		  insert_plugin(liste_plugins, name, PluginInfo.Name, 
				handle, PluginInfo.Type, 0);
	       }
	  }
     }
   current = liste_plugins;
}

void exec_config(char *name)
{
   void *handle;
   
   handle = get_handle(liste_plugins, name);
   dllConfig = dlsym(handle, "DllConfig");
   dllConfig(0);
}

void exec_test(char *name)
{
   void *handle;
   
   handle = get_handle(liste_plugins, name);
   dllTest = dlsym(handle, "DllTest");
   dllTest(0);
}

void exec_about(char *name)
{
   void *handle;
   
   handle = get_handle(liste_plugins, name);
   dllAbout = dlsym(handle, "DllAbout");
   dllAbout(0);
}

void load_plugins(char *gfx_name, char *input_name)
{
   int i;
   void *handle_gfx, *handle_input;
   
   handle_gfx = get_handle(liste_plugins, gfx_name);
   changeWindow = dlsym(handle_gfx, "ChangeWindow");
   closeDLL_gfx = dlsym(handle_gfx, "CloseDLL");
   dllAbout = dlsym(handle_gfx, "DllAbout");
   dllConfig = dlsym(handle_gfx, "DllConfig");
   dllTest = dlsym(handle_gfx, "DllTest");
   initiateGFX = dlsym(handle_gfx, "InitiateGFX");
   processDList = dlsym(handle_gfx, "ProcessDList");
   processRDPList = dlsym(handle_gfx, "ProcessRDPList");
   romClosed_gfx = dlsym(handle_gfx, "RomClosed");
   romOpen_gfx = dlsym(handle_gfx, "RomOpen");
   showCFB = dlsym(handle_gfx, "ShowCFB");
   updateScreen = dlsym(handle_gfx, "UpdateScreen");
   viStatusChanged = dlsym(handle_gfx, "ViStatusChanged");
   viWidthChanged = dlsym(handle_gfx, "ViWidthChanged");
   
   gfx_info.MemoryBswaped = TRUE;
   gfx_info.HEADER = rom;
   gfx_info.RDRAM = (BYTE*)rdram;
   gfx_info.DMEM = (BYTE*)SP_DMEM;
   gfx_info.IMEM = (BYTE*)SP_IMEM;
   gfx_info.MI_INTR_REG = &(MI_register.mi_intr_reg);
   gfx_info.DPC_START_REG = &(dpc_register.dpc_start);
   gfx_info.DPC_END_REG = &(dpc_register.dpc_end);
   gfx_info.DPC_CURRENT_REG = &(dpc_register.dpc_current);
   gfx_info.DPC_STATUS_REG = &(dpc_register.dpc_status);
   gfx_info.DPC_CLOCK_REG = &(dpc_register.dpc_clock);
   gfx_info.DPC_BUFBUSY_REG = &(dpc_register.dpc_bufbusy);
   gfx_info.DPC_PIPEBUSY_REG = &(dpc_register.dpc_pipebusy);
   gfx_info.DPC_TMEM_REG = &(dpc_register.dpc_tmem);
   gfx_info.VI_STATUS_REG = &(vi_register.vi_status);
   gfx_info.VI_ORIGIN_REG = &(vi_register.vi_origin);
   gfx_info.VI_WIDTH_REG = &(vi_register.vi_width);
   gfx_info.VI_INTR_REG = &(vi_register.vi_v_intr);
   gfx_info.VI_V_CURRENT_LINE_REG = &(vi_register.vi_current);
   gfx_info.VI_TIMING_REG = &(vi_register.vi_burst);
   gfx_info.VI_V_SYNC_REG = &(vi_register.vi_v_sync);
   gfx_info.VI_H_SYNC_REG = &(vi_register.vi_h_sync);
   gfx_info.VI_LEAP_REG = &(vi_register.vi_leap);
   gfx_info.VI_H_START_REG = &(vi_register.vi_h_start);
   gfx_info.VI_V_START_REG = &(vi_register.vi_v_start);
   gfx_info.VI_V_BURST_REG = &(vi_register.vi_v_burst);
   gfx_info.VI_X_SCALE_REG = &(vi_register.vi_x_scale);
   gfx_info.VI_Y_SCALE_REG = &(vi_register.vi_y_scale);
   gfx_info.CheckInterrupts = sucre;
   initiateGFX(gfx_info);
   
   handle_input = get_handle(liste_plugins, input_name);
   closeDLL_input = dlsym(handle_input, "CloseDLL");
   controllerCommand = dlsym(handle_input, "ControllerCommand");
   getKeys = dlsym(handle_input, "GetKeys");
   initiateControllers = dlsym(handle_input, "InitiateControllers");
   readController = dlsym(handle_input, "ReadController");
   romClosed_input = dlsym(handle_input, "RomClosed");
   romOpen_input = dlsym(handle_input, "RomOpen");
   keyDown = dlsym(handle_input, "WM_KeyDown");
   keyUp = dlsym(handle_input, "WM_KeyUp");
   
   control_info.MemoryBswaped = TRUE;
   control_info.HEADER = rom;
   control_info.Controls = Controls;
   for (i=0; i<4; i++)
     {
	Controls[i].Present = FALSE;
	Controls[i].RawData = FALSE;
	Controls[i].Plugin = PLUGIN_NONE;
     }
   initiateControllers(control_info);
}
