/**
 * Mupen64 - sound.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include <SDL/SDL.h>
#include "../../memory/memory.h"
#include "../../r4300/r4300.h"

static int longueur = 0;
static int old_depth = 0, old_rate = 0;
SDL_AudioSpec dsp;

void fill_audio(void *udata, Uint8 *stream, int len);
int sound_init()
{
   dsp.channels = 2;
   dsp.callback = fill_audio;
   dsp.samples = 1024;
   return 0;
}

void free_sound()
{
   SDL_CloseAudio();
}

#define VI_NTSC_CLOCK 48681812
#define VI_PAL_CLOCK 49656530

static int local_busy, local_len;
static char *local_buf;

void fill_audio(void *udata, Uint8 *stream, int len)
{
   if (local_busy)
     {
	memcpy(stream, local_buf + local_busy, len);
	local_busy += len;
	if ((local_busy + len) >= local_len) local_busy = 0;
	return;
     }
   if (ai_register.ai_status == 0)
     {
	longueur = ai_register.ai_len;
	ai_register.ai_len /=2;
	ai_register.ai_status |= 0x40000000;
	local_busy = len;
	local_len = longueur & 0x3FFF8;
	local_buf = (char *)(&rdram[(ai_register.ai_dram_addr & 0xFFFFF8)/4]);
	memcpy(stream, local_buf, len);
	return;
     }
   if ((ai_register.ai_status & 0x80000001)>0)
     {
	ai_register.ai_status &= ~0x80000001;
	/*MI_register.mi_intr_reg |= 0x04;
	gen_mi();*/
	
	longueur = ai_register.ai_len;
	ai_register.ai_len /=2;
	local_busy = len;
	local_len = longueur & 0x3FFF8;
	local_buf = (char *)(&rdram[(ai_register.ai_dram_addr & 0xFFFFF8)/4]);
	memcpy(stream, local_buf, len);
	return;
     }
   ai_register.ai_status &= ~0x40000000;
   ai_register.ai_len = 0;
   SDL_PauseAudio(1);
}

void send_sound()
{
   int rate, depth, change = 0;
   rate = VI_NTSC_CLOCK/(ai_register.ai_dacrate+1);
   depth = ai_register.ai_bitrate+1;
   
   if (rate != old_rate)
     {
	dsp.freq = rate;
	old_rate = rate;
	change = 1;
     }
   
   switch(depth)
     {
      case 16:
	if (depth != old_depth)
	  {
	     dsp.format = AUDIO_S16;
	     old_depth = depth;
	     change = 1;
	  }
	break;
      default:
	printf("son : %d bits\n", depth);
	stop=1;
     }
   
   /*if (change)
     {
	SDL_CloseAudio();
	SDL_OpenAudio(&dsp, NULL);
     }*/
   
   if (ai_register.ai_status == 0)
     {
	ai_register.ai_len /=2;
	ai_register.ai_status &= ~0x40000000;
	ai_register.ai_len = 0;
     }
     //SDL_PauseAudio(0);
   else
     ai_register.ai_status |= 0x80000001;
}
