/**
 * Mupen64 - gcop1_s.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../recomph.h"
#include "assemble.h"
#include "../r4300.h"
#include "../ops.h"
#include "../macros.h"


void gendiv_s()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fdiv_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);
}

void genmov_s()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   mov_reg32_preg32(EBX, EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   mov_preg32_reg32(EAX, EBX);
   genupdate_system(0);
}

void genneg_s()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   fchs();
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);
}

void genabs_s()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(ABS_S));
   call_reg32(EAX);
   genupdate_system(0);
}

void gencvt_d_s()
{
   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_double) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);*/
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(CVT_D_S));
   call_reg32(EAX);
   genupdate_system(0);
}

void genadd_s()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fadd_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);
}

void gensub_s()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fsub_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);
}

void gensqrt_s()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(SQRT_S));
   call_reg32(EAX);
   genupdate_system(0);
}

void genmul_s()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fmul_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_dword(EAX);
   genupdate_system(0);
}

void genc_le_s()
{
   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fcomp_preg32_dword(EAX);
   and_ax_imm16(5);
   jne_rj(12);
   and_m32_imm32((unsigned long *)(&FCR31), ~0x800000);
   jmp_imm_short(10);
   or_m32_imm32((unsigned long *)(&FCR31), 0x800000);*/
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_LE_S));
   call_reg32(EAX);
   genupdate_system(0);
}

void genc_lt_s()
{
   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fcomp_preg32_dword(EAX);
   and_ax_imm16(69);
   jne_rj(12);
   and_m32_imm32((unsigned long *)(&FCR31), ~0x800000);
   jmp_imm_short(10);
   or_m32_imm32((unsigned long *)(&FCR31), 0x800000);*/
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_LT_S));
   call_reg32(EAX);
   genupdate_system(0);
}

void genc_eq_s()
{
   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fcomp_preg32_dword(EAX);
   and_ax_imm16(68);
   jne_rj(12);
   and_m32_imm32((unsigned long *)(&FCR31), ~0x800000);
   jmp_imm_short(10);
   or_m32_imm32((unsigned long *)(&FCR31), 0x800000);*/
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_EQ_S));
   call_reg32(EAX);
   genupdate_system(0);
}

void gentrunc_w_s()
{
   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(&Status));
   and_eax_imm32(0x04000000);
   cmp_reg32_imm8(EAX, 0);
   je_rj(8);
   fistp_m64((unsigned long long int*)(&reg_cop1_fgr_64[dst->f.cf.fd]));
   jmp_imm_short(6);
   fistp_m32((unsigned long*)(&reg_cop1_fgr_32[dst->f.cf.fd]));*/
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(TRUNC_W_S));
   call_reg32(EAX);
   genupdate_system(0);
}

void gencvt_w_s()
{
   dst->local_addr = code_length;
   /*mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_dword(EAX);
   mov_eax_memoffs32((unsigned long *)(&Status));
   and_eax_imm32(0x04000000);
   cmp_reg32_imm8(EAX, 0);
   je_rj(8);
   fistp_m64((unsigned long long int*)(&reg_cop1_fgr_64[dst->f.cf.fd]));
   jmp_imm_short(6);
   fistp_m32((unsigned long*)(&reg_cop1_fgr_32[dst->f.cf.fd]));*/
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(TRUNC_W_S));
   call_reg32(EAX);
   genupdate_system(0);
}
