/*
  This file based on rombrowser.c from Project64 .
  Project 64 - A Nintendo 64 emulator.
 *
 * (c) Copyright 2001 zilmar (zilmar@emulation64.com) and 
 * Jabo (jabo@emulation64.com).
 *
 * pj64 homepage: www.pj64.net

*/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#define _WIN32_IE 0x0500
#include <commctrl.h>
#include "rombrowser.h"
#include "main_win.h"
#include "../../winproject/resource.h"
#include "../rom.h"
#include <zlib.h>

static BOOL SortAscending = TRUE;
static int ROM_SIZE = 0;

typedef struct {
	char     szFullFileName[MAX_PATH];
	char     Status[60];
	char     FileName[200];
	char     InternalName[22];
	char     GoodName[200];
	char     CartID[3];
	char     PluginNotes[250];
	char     CoreNotes[250];
	char     UserNotes[250];
	char     Developer[30];
	char     ReleaseDate[30];
	char     Genre[15];
	int      RomSize;
	BYTE     Manufacturer;
	BYTE     Country;
	DWORD    CRC1;
	DWORD    CRC2;
} ROM_INFO;

typedef struct {
	BYTE     Country;
	DWORD    CRC1;
	DWORD    CRC2;
	long     Fpos;
} ROM_LIST_INFO;

typedef struct {
	int    ListCount;
	int    ListAlloc;
	ROM_INFO * List;
} ITEM_LIST;

typedef struct {
	int    ListCount;
	int    ListAlloc;
	ROM_LIST_INFO * List;
} ROM_LIST;

TCHAR RomBrowserFields[4][30] = {TEXT("Header Name"), 
                                     TEXT("Country"),
                                     TEXT("Size"),
                                     TEXT("File Name") 
                                     };
int RomBrowserFiledsWidth[4] = {300,200,100,400};                                     
                                     
ITEM_LIST ItemList = {0,0,NULL};
ROM_LIST RDBList = {0,0,NULL}; 

typedef struct rom_directory_list{
    char RomDirectory[MAX_PATH];
    struct rom_directory_list *next;
} ROM_DIRECTORY_LIST, *ROM_DIRECTORY_PTR;

ROM_DIRECTORY_PTR ROM_DIRECTORY_HEADER;

void FillRomBrowserDirBox(HWND hwnd) {
    char RomDirectory[MAX_PATH];
    ROM_DIRECTORY_PTR tmp;
    tmp = ROM_DIRECTORY_HEADER ;
     while (tmp) {
       sprintf(RomDirectory,"%s",tmp->RomDirectory);
       SendDlgItemMessage(hwnd, IDC_ROMBROWSER_DIR_LIST, LB_ADDSTRING, 0, (LPARAM)RomDirectory);
       tmp=tmp->next ;    
     }
}

void freeRomDirList() {
    ROM_DIRECTORY_PTR temp ;
    while (ROM_DIRECTORY_HEADER!=NULL) {
        temp = ROM_DIRECTORY_HEADER->next;
        free(ROM_DIRECTORY_HEADER);
        ROM_DIRECTORY_HEADER = temp;
    }
}

void freeRomList() {
    if (ItemList.ListAlloc != 0) {
		free(ItemList.List);
		ItemList.ListAlloc = 0;
		ItemList.ListCount = 0;
		ItemList.List = NULL;		
	}
}

void addDirectoryToLinkedList(char Dir[MAX_PATH]) {
   ROM_DIRECTORY_PTR temp,newptr ;
   temp = ROM_DIRECTORY_HEADER ;
   if (temp) {
   while(temp->next) {
    temp = temp->next;
   }
   newptr = (ROM_DIRECTORY_LIST*)malloc(sizeof(ROM_DIRECTORY_LIST));
   temp->next = newptr;
   sprintf(newptr->RomDirectory,"%s",Dir);
   newptr->next=NULL;
   }
   else {
   ROM_DIRECTORY_HEADER = (ROM_DIRECTORY_LIST*)malloc(sizeof(ROM_DIRECTORY_LIST));
   sprintf(ROM_DIRECTORY_HEADER->RomDirectory,"%s",Dir);
   ROM_DIRECTORY_HEADER->next=NULL;
   }
}

void removeDirectoryFromLinkedList(char Dir[MAX_PATH]) {
    ROM_DIRECTORY_PTR temp,prev=NULL;
    temp = ROM_DIRECTORY_HEADER ;
    while (temp) {
         if(lstrcmpi(temp->RomDirectory,Dir)==0) {
              if (prev==NULL) {
                 temp = ROM_DIRECTORY_HEADER;
                 ROM_DIRECTORY_HEADER = temp->next;
                 free(ROM_DIRECTORY_HEADER);        
              }
              else {
                 prev->next=temp->next;
                 free(temp);
              }
              return;
         }
         else
         {
              prev=temp;
              temp=temp->next;  
         }
    }
 //   ShowMessage("Directory not in list!");
}

ROM_DIRECTORY_PTR LoadRomBrowserDirs() {
    char RomBrowserDir[MAX_PATH];
    ROM_DIRECTORY_PTR head,tmp,prev ;
    BOOL success ;
    gzFile *cacheFile;
    head=NULL;
    cacheFile = gzopen("mupen64.cch", "rb");
    if (cacheFile) {
    gzgets(cacheFile, RomBrowserDir, MAX_PATH);
    RomBrowserDir[strlen(RomBrowserDir)-1]='\0';
    if (strcmp(RomBrowserDir, "")) {
            head = (ROM_DIRECTORY_LIST*)malloc(sizeof(ROM_DIRECTORY_LIST));
            sprintf(head->RomDirectory,"%s",RomBrowserDir);
            head->next=NULL;
            }
    prev=head;
    gzgets(cacheFile, RomBrowserDir, MAX_PATH);
    while(strcmp(RomBrowserDir, "")) {
        RomBrowserDir[strlen(RomBrowserDir)-1]='\0';
        tmp = (ROM_DIRECTORY_LIST*)malloc(sizeof(ROM_DIRECTORY_LIST));
        if (tmp) {
                   sprintf(tmp->RomDirectory,"%s",RomBrowserDir);
                   tmp->next = NULL;
                   prev->next = tmp;
                   prev=tmp;
                   gzgets(cacheFile, RomBrowserDir, MAX_PATH);
         }
         else {
            ShowMessage("Not enough Memory");
         }     
     }
     gzclose(cacheFile);
    }
   return head;
}

void SaveRomBrowserDirs() {
   ROM_DIRECTORY_PTR RomDirsHeader;
   gzFile *cacheFile;
   RomDirsHeader = ROM_DIRECTORY_HEADER;
   cacheFile = gzopen ("mupen64.cch", "wb");
   if (cacheFile) {
   while (RomDirsHeader) {
     gzprintf(cacheFile, "%s\n",RomDirsHeader->RomDirectory);
     RomDirsHeader = RomDirsHeader->next ;
   }
   //gzprintf(cacheFile, "%sDIRS_END\n");
   gzclose(cacheFile);
   }
}

void CountryCodeToCountryName(int countrycode,char *countryname)
{  //Thuis function is from 1964 sources,Thanks to Schibo for allowing me to use it
   //SLightly changed for internal use
	switch(countrycode)
	{
	/* Demo */
	case 0:
		strcpy(countryname, "Demo");
		break;

	case '7':
		strcpy(countryname, "Beta");
		break;

	case 0x41:
		strcpy(countryname, "USA/Japan");
		break;

	/* Germany */
	case 0x44:
		strcpy(countryname, "German");
		break;

	/* USA */
	case 0x45:
		strcpy(countryname, "USA");
		break;

	/* France */
	case 0x46:
		strcpy(countryname, "France");
		break;

	/* Italy */
	case 'I':
		strcpy(countryname, "Italy");
		break;

	/* Japan */
	case 0x4A:
		strcpy(countryname, "Japan");
		break;

	case 'S':	/* Spain */
		strcpy(countryname, "Spain");
		break;

	/* Australia */
	case 0x55:
	case 0x59:
		strcpy(countryname, "Australia");
		break;

    case 0x50:
    case 0x58:
	case 0x20:
	case 0x21:
	case 0x38:
	case 0x70:
		sprintf(countryname, "Europe" , countrycode);
		break;

	default:
		sprintf(countryname, "Unknown", countrycode);
		break;
	}
	TranslateDefault(countryname,countryname,countryname);
//	sprintf(countryname,"%s (0x%X)",countryname,countrycode);
}


void AddRomToList (char * RomLocation) {
	LV_ITEM  lvItem;
	ROM_INFO * pRomInfo;
	int index;

	if (ItemList.ListAlloc == 0) {
		ItemList.List = (ROM_INFO *)malloc(100 * sizeof(ROM_INFO));
		ItemList.ListAlloc = 100;
	} else if (ItemList.ListAlloc == ItemList.ListCount) {
		ItemList.ListAlloc += 100;
		ItemList.List = (ROM_INFO *)realloc(ItemList.List, ItemList.ListAlloc * sizeof(ROM_INFO));
		if (ItemList.List == NULL) {
			ShowMessage("Failed");
			ExitThread(0);
		}
	}
	pRomInfo = &ItemList.List[ItemList.ListCount];
	if (pRomInfo == NULL) { return; }

	memset(pRomInfo, 0, sizeof(ROM_INFO));	
	memset(&lvItem, 0, sizeof(lvItem));
//Filling rombrowser info
	strncpy(pRomInfo->szFullFileName, RomLocation, MAX_PATH);
    strncpy(pRomInfo->InternalName, ROM_HEADER->nom, sizeof(ROM_HEADER->nom));
    pRomInfo->Country = ROM_HEADER->Country_code;
    pRomInfo->RomSize = ROM_SIZE;
   switch( pRomInfo->Country )
	{
	 case 0x44:
      lvItem.iImage = 0;              // IDI_GERMANY
      break;
     case 0x45:
      lvItem.iImage = 1;              // IDI_USA
      break;
     case 0x4A:
      lvItem.iImage = 2;              // IDI_JAPAN 
      break;
     case 0x20:
	 case 0x21:
	 case 0x38:
	 case 0x70:
     case 0x50:
     case 0x58:
       lvItem.iImage = 3;              // IDI_EUROPE
      break;
     case 0x55:
      lvItem.iImage = 4;              // IDI_AUSTRALIA
      break;
     case 'I':
	   lvItem.iImage = 5;             // Italy 
        break;
     case 0x46:                       // IDI_FRANCE
	   lvItem.iImage = 6; 
		break;
	 case 'S':                        //SPAIN
       lvItem.iImage = 7;
       break;   	
     default : 
      lvItem.iImage = 8;              // IDI_N64CART 
      break;
    }  
   
    lvItem.mask = LVIF_TEXT | LVIF_PARAM | LVIF_IMAGE;		
	lvItem.iItem = ListView_GetItemCount(hRomList);
	lvItem.lParam = (LPARAM)ItemList.ListCount;
	lvItem.pszText = LPSTR_TEXTCALLBACK;
	ItemList.ListCount += 1;
	
	index = ListView_InsertItem(hRomList, &lvItem);	
}

void RomList_GetDispInfo(LPNMHDR pnmh) {
    char country[50];
	LV_DISPINFO * lpdi = (LV_DISPINFO *)pnmh;
	ROM_INFO * pRomInfo = &ItemList.List[lpdi->item.lParam];
	switch(lpdi->item.iSubItem) {
	case 0:
      strncpy(lpdi->item.pszText, pRomInfo->InternalName, lpdi->item.cchTextMax); 
      break;
    case 1:
      CountryCodeToCountryName(pRomInfo->Country,country);
      strncpy(lpdi->item.pszText,country, lpdi->item.cchTextMax); 
      break;
    case 2:
      sprintf(lpdi->item.pszText,"%.1f MBit",(float)pRomInfo->RomSize/0x20000); 
      break; 
     case 3:
      strncpy(lpdi->item.pszText, pRomInfo->szFullFileName, lpdi->item.cchTextMax); 
      break;       
    }
}

void RomList_OpenRom(LPNMHDR pnmh)
{
    ROM_INFO * pRomInfo;
	LV_ITEM lvItem;
	DWORD ThreadID;
	LONG iItem;

	iItem = ListView_GetNextItem(hRomList, -1, LVNI_SELECTED);
	if (iItem == -1) { return; }

	memset(&lvItem, 0, sizeof(LV_ITEM));
	lvItem.mask = LVIF_PARAM;
	lvItem.iItem = iItem;
	if (!ListView_GetItem(hRomList, &lvItem)) { return; }
	pRomInfo = &ItemList.List[lvItem.lParam];
    if (!pRomInfo) { return; }
	StartRom(pRomInfo->szFullFileName);
}

void RomListNotify(LPNMHDR pnmh) {
	
    switch (pnmh->code) {
	case LVN_GETDISPINFO: RomList_GetDispInfo(pnmh); break;
	case NM_DBLCLK:       RomList_OpenRom(pnmh); break;
	case LVN_COLUMNCLICK: RomList_ColoumnSortList((LPNMLISTVIEW)pnmh); break;
	}
}

void ResetRomBrowserColomuns (void) {
	int Column, index;
	LV_COLUMN lvColumn;
	char szString[300];
        
    memset(&lvColumn,0,sizeof(lvColumn));
	
    ListView_DeleteAllItems (hRomList);
	//Add Colomuns
	lvColumn.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	lvColumn.fmt = LVCFMT_LEFT;
	lvColumn.pszText = szString;

	for (Column = 0; Column < 4; Column ++) {
		lvColumn.iSubItem = Column;
        lvColumn.cx = RomBrowserFiledsWidth[Column];
        Translate(RomBrowserFields[Column],TempMessage);
		strncpy(szString, TempMessage, sizeof(szString));
		ListView_InsertColumn(hRomList, Column, &lvColumn);
	}
}

void TranslateBrowserHeader(HWND hwnd)
{
    int Column, index;
	LV_COLUMN lvColumn;
	char szString[300];
       
    memset(&lvColumn,0,sizeof(lvColumn));
   
	//Add Colomuns
	lvColumn.mask = LVCF_TEXT ;
	lvColumn.fmt = LVCFMT_LEFT;
	lvColumn.pszText = szString;

	for (Column = 0; Column < 4; Column ++) {
		lvColumn.iSubItem = Column;
        Translate(RomBrowserFields[Column],TempMessage);
		strncpy(szString, TempMessage, sizeof(szString));
		ListView_SetColumn(hRomList, Column, &lvColumn);
	}
}

void LoadRomList()
{
    ROM_DIRECTORY_PTR RomDirsHeader;
    ROM_DIRECTORY_HEADER = LoadRomBrowserDirs();
  //  ROM_DIRECTORY_HEADER = NULL;
    RomDirsHeader = ROM_DIRECTORY_HEADER ; 
    while (RomDirsHeader) {
       AddDirToList(RomDirsHeader->RomDirectory,FALSE);
       RomDirsHeader = RomDirsHeader->next ;
      }
    ListView_SortItems(hRomList, RomList_CompareItems, 0);  
}

void ShowTotalRoms()
{
  Translate("Total Roms",TempMessage);
  sprintf(TempMessage,"%s : %d",TempMessage,TOTAL_ROMS_NUMBER);
  SendMessage( hStatus, SB_SETTEXT, 2, (LPARAM)TempMessage );  
}

void AddDirToList(char RomBrowserDir[MAX_PATH],BOOL sortflag)
{
    WIN32_FIND_DATA fd;
    HANDLE hFind;
    sprintf(TempMessage,"%s*.*",RomBrowserDir);
    hFind = FindFirstFile(TempMessage, &fd);
    
    do {
     if (strcmp(fd.cFileName, ".") == 0) { continue; }
     if (strcmp(fd.cFileName, "..") == 0) { continue; }
     sprintf(TempMessage,"%s%s",RomBrowserDir,fd.cFileName);
     ROM_SIZE = fill_header(TempMessage);
     if (ROM_SIZE>10) {
           AddRomToList(TempMessage);  
           sprintf(TempMessage,"Loading Rom: %s",fd.cFileName);
           SendMessage( hStatus, SB_SETTEXT, 1, (LPARAM)TempMessage );
           TOTAL_ROMS_NUMBER = TOTAL_ROMS_NUMBER + 1;
           ShowTotalRoms();
          }
    } while (FindNextFile(hFind, &fd));
    SendMessage( hStatus, SB_SETTEXT, 1, (LPARAM)"" ); 
    if (sortflag) ListView_SortItems(hRomList, RomList_CompareItems, 0);  
}

void CreateRomListControl (HWND hParent) {
   RECT rcl,rtool,rstatus; 
   INITCOMMONCONTROLSEX icex;
   HIMAGELIST hSmall;               // List View Images
   HICON hIcon;                     // Icon Handle
      
   icex.dwSize = sizeof(INITCOMMONCONTROLSEX);
   icex.dwICC  = ICC_LISTVIEW_CLASSES;
   InitCommonControlsEx(&icex); 

   GetClientRect (hParent, &rcl); 
   GetWindowRect (hTool, &rtool); 
   GetWindowRect (hStatus, &rstatus); 
   
   hRomList = CreateWindowEx( 0,WC_LISTVIEW,NULL,
					WS_TABSTOP | WS_VISIBLE | WS_CHILD | 
					LVS_SINGLESEL | LVS_REPORT | LVS_SHOWSELALWAYS ,
					0,rtool.bottom - rtool.top,rcl.right - rcl.left , rcl.bottom - rcl.top - rtool.bottom + rtool.top - rstatus.bottom + rstatus.top,hParent,(HMENU)IDC_ROMLIST,app_hInstance,NULL);
	ListView_SetExtendedListViewStyle(hRomList,LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT );
	
    // Create the Image List

    hSmall = ImageList_Create( 16, 16, TRUE, 6, 0 );

    // Load Image List Icons

    hIcon = LoadIcon( app_hInstance, MAKEINTRESOURCE( IDI_GERMANY ) );
    ImageList_AddIcon( hSmall, hIcon );
    hIcon = LoadIcon( app_hInstance, MAKEINTRESOURCE( IDI_USA ) );
    ImageList_AddIcon( hSmall, hIcon );
    hIcon = LoadIcon( app_hInstance, MAKEINTRESOURCE( IDI_JAPAN ) );
    ImageList_AddIcon( hSmall, hIcon );
    hIcon = LoadIcon( app_hInstance, MAKEINTRESOURCE( IDI_EUROPE ) );
    ImageList_AddIcon( hSmall, hIcon );
    hIcon = LoadIcon( app_hInstance, MAKEINTRESOURCE( IDI_AUSTRALIA ) );
    ImageList_AddIcon( hSmall, hIcon );
    hIcon = LoadIcon( app_hInstance, MAKEINTRESOURCE( IDI_ITALIA ) );
    ImageList_AddIcon( hSmall, hIcon );
    hIcon = LoadIcon( app_hInstance, MAKEINTRESOURCE( IDI_FRANCE ) );
    ImageList_AddIcon( hSmall, hIcon );
    hIcon = LoadIcon( app_hInstance, MAKEINTRESOURCE( IDI_SPAIN ) );
    ImageList_AddIcon( hSmall, hIcon );
    hIcon = LoadIcon( app_hInstance, MAKEINTRESOURCE( IDI_N64CART ) );
    ImageList_AddIcon( hSmall, hIcon );

    // Associate the Image List with the List View Control

    ListView_SetImageList( hRomList, hSmall, LVSIL_SMALL );
        
    ResetRomBrowserColomuns();
    LoadRomList();
}
void ShowRomBrowser(BOOL flag)
{
    if (!flag) 
       {
        GetWindowRect(mainHWND, &rcSaveMainWindow);
        ShowWindow(hRomList,SW_HIDE); 
        SendMessage(hTool, TB_AUTOSIZE, 0, 0);
        SendMessage(hStatus, WM_SIZE, 0, 0);
        SendMessage(mainHWND,WM_USER + 17,0,0);
       }
    else 
       { 
        MoveWindow(mainHWND, rcSaveMainWindow.top, rcSaveMainWindow.left, rcSaveMainWindow.right-rcSaveMainWindow.left, rcSaveMainWindow.bottom-rcSaveMainWindow.top, TRUE);
        ShowWindow(hRomList,SW_SHOW); 
        SendMessage(hTool, TB_AUTOSIZE, 0, 0);
	    SendMessage(hStatus, WM_SIZE, 0, 0);
	    ResizeRomListControl();
       } 
}

void SetRomDirectory ( char * Directory, BOOL IgnoreDefaultDir ) {
	long lResult;
	char Group[200];

	sprintf(Group,"Software\\N64 Emulation\\%s",AppName);
	lResult = RegCreateKeyEx( HKEY_CURRENT_USER, Group,0,"",REG_OPTION_NON_VOLATILE, 
		KEY_ALL_ACCESS,NULL,&hKeyResults,&Disposition);
	if (lResult == ERROR_SUCCESS) {
		DWORD Type, Value, Bytes;
		RegSetValueEx(hKeyResults,"Rom Directory",0,REG_SZ,(LPBYTE)Directory,strlen(Directory));
		RegCloseKey(hKeyResults);
	}
}

void RefreshRomBrowser ()
{
    SaveRomBrowserDirs();
    TOTAL_ROMS_NUMBER = 0 ;
    ShowTotalRoms();
    ListView_DeleteAllItems (hRomList);
    freeRomList();
	LoadRomList();
}

BOOL getRomBrowserDir(char ret[MAX_PATH])
{
      DWORD  Type,Bytes = sizeof(TempMessage) ;
      sprintf(TempMessage,"Software\\N64 Emulation\\%s",AppName);
	  lResult = RegOpenKeyEx( HKEY_CURRENT_USER,TempMessage,0,KEY_ALL_ACCESS,
	                         	&hKeyResults);
     
	  memset(ret, 0, sizeof(ret));
      if (lResult == ERROR_SUCCESS) {
		lResult = RegQueryValueEx(hKeyResults,"Rom Directory",0,&Type,ret,&Bytes);
	  }
	  RegCloseKey(hKeyResults);	
	  if (lResult == ERROR_SUCCESS) 
             return TRUE;
	  else 
             return FALSE;
}

void RomList_ColoumnSortList(LPNMLISTVIEW pnmv)
{
    SortAscending = SortAscending?FALSE:TRUE;
    sprintf(TempMessage,"%d",pnmv->iSubItem);
    ListView_SortItems(hRomList, RomList_CompareItems, pnmv->iSubItem);
}

int CALLBACK RomList_CompareItems(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
    char country1[50],country2[50];
    ROM_INFO * pRomInfo1 = &ItemList.List[SortAscending?lParam1:lParam2];
	ROM_INFO * pRomInfo2 = &ItemList.List[SortAscending?lParam2:lParam1];
   switch (lParamSort) {
	case 0 : return (int)lstrcmpi(pRomInfo1->InternalName, pRomInfo2->InternalName);
	break;
	case 1 : 
             CountryCodeToCountryName(pRomInfo1->Country,country1);
             CountryCodeToCountryName(pRomInfo2->Country,country2);  
             return (int)lstrcmpi(country1,country2); 
    break;
	case 2 : return (int)pRomInfo1->RomSize - (int)pRomInfo2->RomSize; 
	break;
	case 3 : return (int)lstrcmpi(pRomInfo1->szFullFileName, pRomInfo2->szFullFileName);
	break;
    default :
	         return 0; 
	 break;
  }
}

void ResizeRomListControl() {
	WORD y = 0;
	RECT rc,rcMain;
	WORD nWidth,nHeight;
     if (!emu_launched) {
     if (IsWindow(hRomList)) {
		GetClientRect(mainHWND, &rcMain);
		nWidth = rcMain.right - rcMain.left;
		nHeight = rcMain.bottom - rcMain.top;
        if (IsWindow(hStatus)) {
			
            GetWindowRect(hStatus, &rc);
			nHeight -= (WORD)(rc.bottom - rc.top);
		}
		if (IsWindow(hTool))   {
		    GetWindowRect(hTool, &rc);
			y += (WORD)(rc.bottom - rc.top);
        }
		MoveWindow(hRomList, 0, y, nWidth, nHeight-y, TRUE);
	}
	}
}
