/**
 * Mupen64 - main.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

/* This is the command line version of the MUPEN64's entry point,
 * if you want to implement an interface, you should look here
 */

// Emulateur Nintendo 64, MUPEN64, Fichier Principal 
// main.c
#define VERSION "0.0.4\0"

#include <stdlib.h>
#include <unistd.h>

#include "guifuncs.h"
#include "rom.h"
#include "../r4300/r4300.h"
#include "../r4300/recomph.h"
#include "../memory/memory.h"
#include "../sound/sound.h"
#include "winlnxdefs.h"
#include "plugin.h"

#include <SDL/SDL.h>

static char cwd[1024];

char *get_currentpath()
{
   return cwd;
}

void display_loading_progress(int p)
{
   printf("loading rom : %d%%\r", p);
   fflush(stdout);
   if (p==100) printf("\n");
}

static int filter(const SDL_Event *event)
{
   switch (event->type)
     {
      case SDL_KEYDOWN:
	switch (event->key.keysym.sym)
	  {
	   case SDLK_ESCAPE:
	     stop_it();
	     break;
	   case SDLK_F1:
	     changeWindow();
	     break;
	   default:
	     keyDown(0, event->key.keysym.sym);
	  }
	return 0;
	break;
      case SDL_KEYUP:
	switch (event->key.keysym.sym)
	  {
	   case SDLK_ESCAPE:
	     break;
	   case SDLK_F1:
	     break;
	   default:
	     keyUp(0, event->key.keysym.sym);
	  }
	return 0;
	break;
      default:
	return 1;
     }
}

int main (int argc, char *argv[])
{
   char c;
   char plugins[9][100], s[2];
   int old_i, i, i1, i2;
   
   if (argv[0][0] != '/')
     {
	getcwd(cwd, 1024);
	strcat(cwd, "/");
	strcat(cwd, argv[0]);
     }
   else
     strcpy(cwd, argv[0]);
   while(cwd[strlen(cwd)-1] != '/') cwd[strlen(cwd)-1] = '\0';
   
   printf("Mupen64 version : %s\n", VERSION);
   
   if (argc!=2)
     {
	printf("syntax: mupen64_RENDERER rom\n");
	return 0;
     }
   
   if (rom_read(argv[1]))
     {
	if(rom) free(rom);
	if(ROM_HEADER) free(ROM_HEADER);
	return 1;
     }
   printf ("emulation mode:\n"
	   "     1. interpreter\n"
	   "     2. dynamic recompiler (default)\n"
           "     3. pure interpreter\n");
   if ((c = getchar()) == '1') dynacore=0;
   else if (c == '3') dynacore=2;
   else dynacore=1;
   
   SDL_Init(SDL_INIT_VIDEO);
   SDL_SetVideoMode(10, 10, 16, 0);
   SDL_ShowCursor(0);
   SDL_EnableKeyRepeat(0, 0);
   
   if (sound_init())
     {
	if(rom) free(rom);
	if(ROM_HEADER) free(ROM_HEADER);
	return 1;
     }
   init_memory();
   // --------------------- loading plugins ----------------------
   search_plugins(cwd);
   i=1;
   i1=1;
   printf("  Choose your gfx plugin : \n");
   while(get_plugin_type() != -1)
     {
	if (get_plugin_type() == PLUGIN_TYPE_GFX)
	  {
	     strcpy(plugins[i], next_plugin());
	     printf("%s\n", plugins[i++]);
	  }
	else
	  next_plugin();
     }
   getchar();
   c = getchar();
   s[0] = c;
   s[1] = 0;
   i1 = atoi(s);
   
   rewind_plugin();
   old_i = i;
   printf("  Choose your input plugin : \n");
   while(get_plugin_type() != -1)
     {
	if (get_plugin_type() == PLUGIN_TYPE_CONTROLLER)
	  {
	     strcpy(plugins[i], next_plugin());
	     printf("%s\n", plugins[i++]);
	  }
	else
	  next_plugin();
     }
   getchar();
   c = getchar();
   getchar();
   s[0] = c;
   s[1] = 0;
   i2 = old_i + atoi(s) - 1;
   
   load_plugins(plugins[i1], plugins[i2]);
   romOpen_gfx();
   romOpen_input();
   // ------------------------------------------------------------
   SDL_SetEventFilter(filter);
   go();
   romClosed_input();
   romClosed_gfx();
   closeDLL_input();
   closeDLL_gfx();
   free_sound();
   free(rom);
   free(ROM_HEADER);
   free_memory();
   return 0;
}
