/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class Sunsoft03Mapper
extends Mapper {
    int[] chrbank = new int[]{0, 0, 0, 0};
    private int irqctr = 0;
    private boolean irqenable = false;
    private boolean interrupted = false;
    private boolean irqtoggle = false;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 16; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 1; i <= 16; ++i) {
            this.prg_map[32 - i] = this.prgsize - 1024 * i;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        if (addr >= 34816 && addr <= 36863) {
            this.chrbank[0] = data;
            this.setupchr();
        } else if (addr >= 38912 && addr <= 40959) {
            this.chrbank[1] = data;
            this.setupchr();
        } else if (addr >= 43008 && addr <= 45055) {
            this.chrbank[2] = data;
            this.setupchr();
        } else if (addr >= 47104 && addr <= 49151) {
            this.chrbank[3] = data;
            this.setupchr();
        } else if (addr >= 51200 && addr <= 53247) {
            if (!this.irqtoggle) {
                this.irqctr = this.irqctr & 0xFF | data << 8;
                this.irqtoggle = true;
            } else {
                this.irqctr = this.irqctr & 0xFF00 | data & 0xFF;
                this.irqtoggle = false;
            }
        } else if (addr >= 55296 && addr <= 57343) {
            if (this.interrupted) {
                --this.cpu.interrupt;
                this.interrupted = false;
            }
            this.irqenable = utils.getbit(data, 4);
            this.irqtoggle = false;
        } else if (addr >= 59392 && addr <= 61439) {
            switch (data & 3) {
                case 0: {
                    this.setmirroring(Mapper.MirrorType.V_MIRROR);
                    break;
                }
                case 1: {
                    this.setmirroring(Mapper.MirrorType.H_MIRROR);
                    break;
                }
                case 2: {
                    this.setmirroring(Mapper.MirrorType.SS_MIRROR0);
                    break;
                }
                case 3: {
                    this.setmirroring(Mapper.MirrorType.SS_MIRROR1);
                }
            }
        } else if (addr >= 63488 && addr <= 65535) {
            for (int i = 0; i < 16; ++i) {
                this.prg_map[i] = 1024 * (i + 16 * data) & this.prgsize - 1;
            }
        }
    }

    @Override
    public void cpucycle(int cycles) {
        if (this.irqenable) {
            if (this.irqctr <= 0) {
                this.irqctr = 65535;
                if (!this.interrupted) {
                    ++this.cpu.interrupt;
                    this.interrupted = true;
                }
                this.irqenable = false;
            } else {
                this.irqctr -= cycles;
            }
        }
    }

    private void setupchr() {
        this.setppubank(2, 0, this.chrbank[0]);
        this.setppubank(2, 2, this.chrbank[1]);
        this.setppubank(2, 4, this.chrbank[2]);
        this.setppubank(2, 6, this.chrbank[3]);
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (i + 2 * banknum) % this.chrsize;
        }
    }
}

