/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class Mapper62
extends Mapper {
    boolean prg_mode;
    int prgselect;
    int chrselect;

    @Override
    public void loadrom() throws BadMapperException {
        int i;
        super.loadrom();
        for (i = 0; i < 32; ++i) {
            this.prg_map[i] = 1024 * i & this.prgsize - 1;
        }
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i & this.chrsize - 1;
        }
    }

    @Override
    public final void cartWrite(int addr, int data) {
        int i;
        if (addr < 32768 || addr > 65535) {
            super.cartWrite(addr, data);
            return;
        }
        this.prg_mode = utils.getbit(addr, 5);
        this.prgselect = addr & 0x40 | addr >> 8 & 0x3F;
        this.chrselect = addr << 2 | data & 3;
        for (i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * (i + 8 * this.chrselect) & this.chrsize - 1;
        }
        if (this.prg_mode) {
            for (i = 0; i < 16; ++i) {
                this.prg_map[i] = 1024 * (i + 16 * this.prgselect) & this.prgsize - 1;
            }
            for (i = 0; i < 16; ++i) {
                this.prg_map[16 + i] = 1024 * (i + 16 * this.prgselect) & this.prgsize - 1;
            }
        } else {
            for (i = 0; i < 32; ++i) {
                this.prg_map[i] = 1024 * (i + 32 * (this.prgselect >> 1)) & this.prgsize - 1;
            }
        }
        this.setmirroring(utils.getbit(addr, 7) ? Mapper.MirrorType.H_MIRROR : Mapper.MirrorType.V_MIRROR);
    }
}

