/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.mappers;

import com.grapeshot.halfnes.audio.MMC5SoundChip;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;
import java.util.Arrays;

public class MMC5Mapper
extends Mapper {
    private int[] exram = new int[1024];
    private int exramMode;
    private int chrMode;
    private int prgMode;
    private int wramWrite1;
    private int wramWrite2;
    private int multiplier1;
    private int multiplier2;
    private int prgpage;
    private int chrOr;
    private int wrambank;
    boolean scanctrEnable;
    boolean irqPend;
    private int[] chrregsA = new int[8];
    private int[] chrregsB = new int[4];
    private int[] prgregs = new int[4];
    private int[] chrmapB = new int[4];
    private boolean[] romHere = new boolean[3];
    private int prevaddr;
    private int scanctrLine;
    private int scanline;
    private final int[] fillnt = new int[1024];
    private MMC5SoundChip soundchip;
    int fetchcount = 0;
    int exlatch = 0;
    boolean spritemode = false;
    int lastfetch = 0;

    @Override
    public void loadrom() throws BadMapperException {
        super.loadrom();
        this.prgregs[3] = this.prgsize / 8192 - 1;
        this.prgregs[2] = this.prgsize / 8192 - 1;
        this.prgregs[1] = this.prgsize / 8192 - 1;
        this.prgregs[0] = this.prgsize / 8192 - 1;
        this.prgMode = 3;
        this.setupPRG();
        for (int i = 0; i < 8; ++i) {
            this.chr_map[i] = 1024 * i;
        }
        this.prgram = new int[65536];
    }

    @Override
    public final void cartWrite(int addr, int data) {
        block42: {
            block41: {
                if (addr >= 23552) break block41;
                switch (addr) {
                    case 20480: 
                    case 20481: 
                    case 20482: 
                    case 20483: 
                    case 20484: 
                    case 20485: 
                    case 20486: 
                    case 20487: {
                        if (this.soundchip == null) {
                            this.soundchip = new MMC5SoundChip();
                            this.cpuram.apu.addExpnSound(this.soundchip);
                        }
                    }
                    case 20496: 
                    case 20497: 
                    case 20501: {
                        if (this.soundchip != null) {
                            this.soundchip.write(addr - 20480, data);
                            break;
                        }
                        break block42;
                    }
                    case 20736: {
                        this.prgMode = data & 3;
                        this.setupPRG();
                        break;
                    }
                    case 20737: {
                        this.chrMode = data & 3;
                        this.setupCHR();
                        break;
                    }
                    case 20738: {
                        this.wramWrite1 = data;
                        break;
                    }
                    case 20739: {
                        this.wramWrite2 = data;
                        break;
                    }
                    case 20740: {
                        this.exramMode = data & 3;
                        break;
                    }
                    case 20741: {
                        this.setMirroring(data, this.exram);
                        break;
                    }
                    case 20742: {
                        Arrays.fill(this.fillnt, 0, 960, data);
                        break;
                    }
                    case 20743: {
                        Arrays.fill(this.fillnt, 960, this.fillnt.length, data & 3 + (data & 3) << 2 + (data & 3) << 4 + (data & 3) << 6);
                        break;
                    }
                    case 20755: {
                        this.wrambank = data & 7;
                        break;
                    }
                    case 20756: {
                        this.prgregs[0] = data & 0x7F;
                        this.romHere[0] = utils.getbit(data, 7);
                        this.setupPRG();
                        break;
                    }
                    case 20757: {
                        this.prgregs[1] = data & 0x7F;
                        this.romHere[1] = utils.getbit(data, 7);
                        this.setupPRG();
                        break;
                    }
                    case 20758: {
                        this.prgregs[2] = data & 0x7F;
                        this.romHere[2] = utils.getbit(data, 7);
                        this.setupPRG();
                        break;
                    }
                    case 20759: {
                        this.prgregs[3] = data & 0x7F;
                        this.setupPRG();
                        break;
                    }
                    case 20768: {
                        this.chrregsA[0] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20769: {
                        this.chrregsA[1] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20770: {
                        this.chrregsA[2] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20771: {
                        this.chrregsA[3] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20772: {
                        this.chrregsA[4] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20773: {
                        this.chrregsA[5] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20774: {
                        this.chrregsA[6] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20775: {
                        this.chrregsA[7] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20776: {
                        this.chrregsB[0] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20777: {
                        this.chrregsB[1] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20778: {
                        this.chrregsB[2] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20779: {
                        this.chrregsB[3] = data;
                        this.setupCHR();
                        break;
                    }
                    case 20784: {
                        this.chrOr = data & 3;
                        break;
                    }
                    case 20992: {
                        if (utils.getbit(data, 7)) {
                            System.err.println("Split screen mode not supported yet");
                            break;
                        }
                        break block42;
                    }
                    case 20993: 
                    case 20994: 
                    case 20995: {
                        this.scanctrLine = data;
                        break;
                    }
                    case 20996: {
                        this.scanctrEnable = utils.getbit(data, 7);
                        break;
                    }
                    case 20997: {
                        this.multiplier1 = data;
                        break;
                    }
                    case 20998: {
                        this.multiplier2 = data;
                        break;
                    }
                }
                break block42;
            }
            if (addr < 24576) {
                this.exram[addr - 23552] = data;
            } else if (addr < 32768) {
                this.prgram[this.wrambank * 8192 + (addr - 24576)] = data;
            }
        }
    }

    @Override
    public final int cartRead(int addr) {
        if (addr >= 32768) {
            if (this.prgMode == 0 || this.prgMode == 1 && (addr >= 49152 || this.romHere[1]) || this.prgMode == 2 && (addr >= 57344 || addr >= 49152 && this.romHere[2] || this.romHere[1]) || this.prgMode == 3 && (addr >= 57344 || addr >= 49152 && this.romHere[2] || addr >= 40960 && this.romHere[1] || this.romHere[0])) {
                return this.prg[this.prg_map[(addr & Short.MAX_VALUE) >> 10] + (addr & 0x3FF)];
            }
            System.err.println("MMC5 wants RAM at " + utils.hex(addr));
            return 42;
        }
        if (addr >= 24576) {
            return this.prgram[this.wrambank * 8192 + (addr - 24576)];
        }
        if (addr >= 23552) {
            return this.exram[addr - 23552];
        }
        switch (addr) {
            case 20501: {
                return this.soundchip.status();
            }
            case 20996: {
                int stat = (this.irqPend ? 128 : 0) + (this.scanline < 240 ? 64 : 0);
                if (this.irqPend) {
                    this.irqPend = false;
                    --this.cpu.interrupt;
                }
                return stat;
            }
            case 20997: {
                return this.multiplier1 * this.multiplier2 & 0xFF;
            }
            case 20998: {
                return this.multiplier1 * this.multiplier2 >> 8 & 0xFF;
            }
        }
        return addr >> 8;
    }

    public void setupPRG() {
        switch (this.prgMode) {
            case 0: {
                this.setcpubank(32, 0, (this.prgregs[3] & 0x7F) >> 2);
                break;
            }
            case 1: {
                this.setcpubank(16, 16, (this.prgregs[3] & 0x7F) >> 1);
                this.setcpubank(16, 0, (this.prgregs[1] & 0x7F) >> 1);
                break;
            }
            case 2: {
                this.setcpubank(8, 24, this.prgregs[3] & 0x7F);
                this.setcpubank(8, 16, this.prgregs[2] & 0x7F);
                this.setcpubank(8, 8, this.prgregs[1] & 0x7F | 1);
                this.setcpubank(8, 0, this.prgregs[1] & 0x7E);
                break;
            }
            case 3: {
                this.setcpubank(8, 24, this.prgregs[3] & 0x7F);
                this.setcpubank(8, 16, this.prgregs[2] & 0x7F);
                this.setcpubank(8, 8, this.prgregs[1] & 0x7F);
                this.setcpubank(8, 0, this.prgregs[0] & 0x7F);
            }
        }
    }

    public void setupCHR() {
        switch (this.chrMode) {
            case 0: {
                this.setppubank(8, 0, this.chrregsA[7]);
                this.setppubankB(4, 0, this.chrregsB[3]);
                break;
            }
            case 1: {
                this.setppubank(4, 4, this.chrregsA[7]);
                this.setppubank(4, 0, this.chrregsA[3]);
                this.setppubankB(4, 0, this.chrregsB[3]);
                break;
            }
            case 2: {
                this.setppubank(2, 6, this.chrregsA[7]);
                this.setppubank(2, 4, this.chrregsA[5]);
                this.setppubank(2, 2, this.chrregsA[3]);
                this.setppubank(2, 0, this.chrregsA[1]);
                this.setppubankB(2, 2, this.chrregsB[3]);
                this.setppubankB(2, 0, this.chrregsB[1]);
                break;
            }
            case 3: {
                this.setppubank(1, 7, this.chrregsA[7]);
                this.setppubank(1, 6, this.chrregsA[6]);
                this.setppubank(1, 5, this.chrregsA[5]);
                this.setppubank(1, 4, this.chrregsA[4]);
                this.setppubank(1, 3, this.chrregsA[3]);
                this.setppubank(1, 2, this.chrregsA[2]);
                this.setppubank(1, 1, this.chrregsA[1]);
                this.setppubank(1, 0, this.chrregsA[0]);
                this.setppubankB(1, 3, this.chrregsB[3]);
                this.setppubankB(1, 2, this.chrregsB[2]);
                this.setppubankB(1, 1, this.chrregsB[1]);
                this.setppubankB(1, 0, this.chrregsB[0]);
            }
        }
        int i = 0;
        while (i < 8) {
            int n = i++;
            this.chr_map[n] = this.chr_map[n] + this.chrOr * 256 * 1024;
        }
        i = 0;
        while (i < 4) {
            int n = i++;
            this.chrmapB[n] = this.chrmapB[n] + this.chrOr * 256 * 1024;
        }
    }

    private void setppubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chr_map[i + bankpos] = 1024 * (banknum + i) % this.chrsize;
        }
    }

    private void setppubankB(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.chrmapB[i + bankpos] = 1024 * (banknum + i) % this.chrsize;
        }
    }

    private void setcpubank(int banksize, int bankpos, int banknum) {
        for (int i = 0; i < banksize; ++i) {
            this.prg_map[i + bankpos] = 1024 * (banknum * banksize + i) & this.prgsize - 1;
        }
    }

    @Override
    public int ppuRead(int addr) {
        if (addr < 8192) {
            if (++this.fetchcount == 3) {
                this.spritemode = true;
            }
            if (this.spritemode) {
                this.prevaddr = addr;
                return this.chr[this.chr_map[addr >> 10] + (addr & 0x3FF)];
            }
            this.prevaddr = addr;
            if (this.exramMode == 1) {
                if (this.exlatch == 2) {
                    ++this.exlatch;
                    return this.chr[(this.chrOr * 262144 | (this.exram[this.lastfetch] & 0x3F) * 4096 | addr & 0xFFF) % this.chr.length];
                }
                if (this.exlatch == 3) {
                    this.exlatch = 0;
                    return this.chr[(this.chrOr * 262144 | (this.exram[this.lastfetch] & 0x3F) * 4096 | addr & 0xFFF) % this.chr.length];
                }
            }
            return this.chr[this.chrmapB[addr >> 10 & 3] + (addr & 0x3FF)];
        }
        this.spritemode = false;
        this.fetchcount = 0;
        if (this.exramMode == 1) {
            if (this.exlatch == 0) {
                ++this.exlatch;
                this.lastfetch = addr & 0x3FF;
            } else if (this.exlatch == 1) {
                ++this.exlatch;
                int theone = this.exram[this.lastfetch];
                return (theone & 0xC0) >> 6 | (theone & 0xC0) >> 4 | (theone & 0xC0) >> 2 | theone & 0xC0;
            }
        }
        return super.ppuRead(addr);
    }

    @Override
    public void notifyscanline(int scanline) {
        this.scanline = scanline;
        if (this.scanctrEnable && scanline == this.scanctrLine - 1) {
            this.irqPend = true;
            ++this.cpu.interrupt;
        }
    }

    public void setMirroring(int ntsetup, int[] exram) {
        switch (ntsetup & 3) {
            case 0: {
                this.nt0 = this.pput0;
                break;
            }
            case 1: {
                this.nt0 = this.pput1;
                break;
            }
            case 2: {
                this.nt0 = exram;
                break;
            }
            case 3: {
                this.nt0 = this.fillnt;
            }
        }
        switch ((ntsetup >>= 2) & 3) {
            case 0: {
                this.nt1 = this.pput0;
                break;
            }
            case 1: {
                this.nt1 = this.pput1;
                break;
            }
            case 2: {
                this.nt1 = exram;
                break;
            }
            case 3: {
                this.nt1 = this.fillnt;
            }
        }
        switch ((ntsetup >>= 2) & 3) {
            case 0: {
                this.nt2 = this.pput0;
                break;
            }
            case 1: {
                this.nt2 = this.pput1;
                break;
            }
            case 2: {
                this.nt2 = exram;
                break;
            }
            case 3: {
                this.nt2 = this.fillnt;
            }
        }
        switch ((ntsetup >>= 2) & 3) {
            case 0: {
                this.nt3 = this.pput0;
                break;
            }
            case 1: {
                this.nt3 = this.pput1;
                break;
            }
            case 2: {
                this.nt3 = exram;
                break;
            }
            case 3: {
                this.nt3 = this.fillnt;
            }
        }
    }
}

