/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes.audio;

import com.grapeshot.halfnes.audio.ExpansionSoundChip;
import com.grapeshot.halfnes.utils;
import java.util.Arrays;

public class YMSoundChip
implements ExpansionSoundChip {
    private final adsr[] modenv_state = new adsr[6];
    private final adsr[] carenv_state = new adsr[6];
    private final int[] vol = new int[6];
    private final int[] freq = new int[6];
    private final int[] octave = new int[6];
    private final int[] instrument = new int[6];
    private final int[] carout = new int[6];
    private final int[] mod = new int[6];
    private final int[] oldmodout = new int[6];
    private final int[] out = new int[6];
    private final boolean[] key = new boolean[6];
    private final boolean[] sust = new boolean[6];
    private int fmctr = 0;
    private int amctr = 0;
    private double[] wave = new double[6];
    private double[] modenv_vol = new double[6];
    private double[] carenv_vol = new double[6];
    private final int[][] instdata = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {3, 33, 5, 6, 184, 130, 66, 39}, {19, 65, 19, 13, 216, 214, 35, 18}, {49, 17, 8, 8, 250, 154, 34, 2}, {49, 97, 24, 7, 120, 100, 48, 39}, {34, 33, 30, 6, 240, 118, 8, 40}, {2, 1, 6, 0, 240, 242, 3, 245}, {33, 97, 29, 7, 130, 129, 22, 7}, {35, 33, 26, 23, 207, 114, 37, 23}, {21, 17, 37, 0, 79, 113, 0, 17}, {133, 1, 18, 15, 153, 162, 64, 2}, {7, 193, 105, 7, 243, 245, 167, 18}, {113, 35, 13, 6, 102, 117, 35, 22}, {1, 2, 211, 5, 163, 146, 247, 82}, {97, 99, 12, 0, 148, 175, 52, 6}, {33, 98, 13, 0, 177, 160, 84, 23}};
    private static final int[] logsin = YMSoundChip.genlogsintbl();
    private static final int[] exp = YMSoundChip.genexptbl();
    private static final int[] am = YMSoundChip.genamtbl();
    private static final int[] vib = YMSoundChip.genvibtbl();
    private static final double[] multbl = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 12.0, 12.0, 15.0, 15.0};
    private static final int[] keyscaletbl = new int[]{0, 1536, 2048, 2368, 2560, 2752, 2880, 3008, 3072, 3200, 3264, 3328, 3392, 3456, 3520, 3584};
    int ch = 0;
    private int s;
    private static final int zerovol = 511;
    private static final int maxvol = 0;
    private static final double[] attack_tbl = new double[]{0.0, 0.0, 0.0, 0.0, 0.00147964, 0.001827788, 0.002219467, 0.002589363, 0.00295653, 0.003280789, 0.004438896, 0.005178727, 0.005918528, 0.007147843, 0.009131117, 0.010357663, 0.011837056, 0.014622722, 0.017718715, 0.020728745, 0.023675206, 0.029243774, 0.035121416, 0.041430652, 0.046655732, 0.058487549, 0.071032186, 0.082847896, 0.094709582, 0.121904762, 0.142064373, 0.165695793, 0.189349112, 0.234003656, 0.284128746, 0.331606218, 0.378698225, 0.468007313, 0.567627494, 0.663212435, 0.775757576, 0.934306569, 1.137777778, 1.32642487, 1.514792899, 1.868613139, 2.265486726, 2.639175258, 3.047619048, 3.657142857, 4.266666667, 4.740740741, 5.12, 6.095238095, 7.529411765, 8.533333333, 9.142857143, 11.63636364, 14.22222222, 18.28571429, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0, 511.0};
    private static final double[] decay_tbl = new double[]{0.0, 0.0, 0.0, 0.0, 1.22332E-4, 1.52316E-4, 1.75261E-4, 2.11944E-4, 2.44665E-4, 3.04632E-4, 3.65559E-4, 4.25651E-4, 4.8933E-4, 6.09264E-4, 7.31117E-4, 8.51302E-4, 9.78661E-4, 0.001173833, 0.00146223, 0.001702603, 0.001957321, 0.002437051, 0.002924478, 0.003405206, 0.003914672, 0.004874148, 0.005848888, 0.006808873, 0.007829225, 0.009748296, 0.011698044, 0.013620644, 0.01565845, 0.01949585, 0.023396088, 0.027242737, 0.031318816, 0.038994669, 0.046792177, 0.054479677, 0.063888196, 0.07992507, 0.093567251, 0.108982546, 0.125244618, 0.156002438, 0.188235294, 0.21787234, 0.250489237, 0.31181486, 0.374269006, 0.436115843, 0.500978474, 0.624390244, 0.748538012, 0.870748299, 1.003921569, 1.248780488, 1.497076023, 1.741496599, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031, 2.015748031};

    public YMSoundChip() {
        Arrays.fill((Object[])this.modenv_state, (Object)adsr.CUTOFF);
        Arrays.fill((Object[])this.carenv_state, (Object)adsr.CUTOFF);
        Arrays.fill(this.modenv_vol, 511.0);
        Arrays.fill(this.carenv_vol, 511.0);
    }

    public static int clamp(int a) {
        return a != (a & 0xFF) ? (a < 0 ? 0 : 255) : a;
    }

    private static int[] genvibtbl() {
        double l = 1789773.0;
        double f = 6.7;
        int[] tbl = new int[(int)Math.ceil(l / f)];
        for (int x = 0; x < tbl.length; ++x) {
            tbl[x] = (int)(48.0 * Math.sin(Math.PI * 2 * f * (double)x / l));
        }
        return tbl;
    }

    private static int[] genamtbl() {
        double l = 1789773.0;
        double f = 3.7;
        int depth = 128;
        int[] tbl = new int[(int)Math.ceil(l / f)];
        for (int x = 0; x < tbl.length; ++x) {
            tbl[x] = (int)((double)depth * Math.sin(Math.PI * 2 * f * (double)x / l) + (double)depth);
        }
        return tbl;
    }

    private static int[] genlogsintbl() {
        int[] tbl = new int[256];
        for (int i = 0; i < tbl.length; ++i) {
            tbl[i] = (int)Math.round(-Math.log(Math.sin(((double)i + 0.5) * Math.PI / 256.0 / 2.0)) / Math.log(2.0) * 256.0);
        }
        return tbl;
    }

    private static int[] genexptbl() {
        int[] tbl = new int[256];
        for (int i = 0; i < tbl.length; ++i) {
            tbl[i] = (int)Math.round((Math.pow(2.0, (double)i / 256.0) - 1.0) * 1024.0);
        }
        return tbl;
    }

    @Override
    public final void write(int register, int data) {
        switch (register) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.instdata[0][register & 7] = data;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                int n = register - 16;
                this.freq[n] = this.freq[n] & 0xF00 | data;
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                int m = register - 32;
                this.octave[m] = data >> 1 & 7;
                this.freq[m] = this.freq[m] & 0xFF | (data & 1) << 8;
                if (utils.getbit(data, 4) && !this.key[m]) {
                    this.carenv_state[m] = adsr.CUTOFF;
                    this.modenv_state[m] = adsr.CUTOFF;
                }
                this.key[m] = utils.getbit(data, 4);
                this.sust[m] = utils.getbit(data, 5);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                int j = register - 48;
                this.vol[j] = data & 0xF;
                this.instrument[j] = data >> 4 & 0xF;
                break;
            }
        }
    }

    @Override
    public final void clock(int cycle) {
        for (int i = 0; i < cycle; ++i) {
            int modks;
            ++this.ch;
            this.ch %= 6;
            int n = this.ch;
            this.wave[n] = this.wave[n] + 3.255208333333333E-4 * (double)(this.freq[this.ch] << this.octave[this.ch]);
            int[] inst = this.instdata[this.instrument[this.ch]];
            this.setenvelope(inst, this.modenv_state, this.modenv_vol, this.ch, false);
            this.setenvelope(inst, this.carenv_state, this.carenv_vol, this.ch, true);
            int keyscale = keyscaletbl[this.freq[this.ch] >> 5] - 512 * (7 - this.octave[this.ch]);
            if (keyscale < 0) {
                keyscale = 0;
            }
            modks = (modks = inst[2] >> 6) == 0 ? 0 : keyscale >> 3 - modks;
            int carks = inst[3] >> 6;
            carks = carks == 0 ? 0 : keyscale >> 3 - carks;
            int fb = ~inst[3] & 7;
            int mod_f = (int)((this.wave[this.ch] + (double)(this.mod[this.ch] + this.oldmodout[this.ch] >> 6 + fb)) * multbl[inst[0] & 0xF] + (double)(utils.getbit(inst[0], 6) ? vib[this.fmctr] : 0));
            this.mod[this.ch] = this.operator(mod_f, (inst[2] & 0x3F) * 32 + ((int)this.modenv_vol[this.ch] << 2) + modks + (utils.getbit(inst[0], 7) ? am[this.amctr] : 0), utils.getbit(inst[3], 3)) << 2;
            this.out[this.ch] = this.operator((this.mod[this.ch] + this.oldmodout[this.ch]) / 2 + (int)((double)(utils.getbit(inst[1], 6) ? vib[this.fmctr] : 0) + this.wave[this.ch] * multbl[inst[1] & 0xF]), this.vol[this.ch] * 128 + (utils.getbit(inst[1], 7) ? am[this.amctr] : 0) + carks + ((int)this.carenv_vol[this.ch] << 2), utils.getbit(inst[3], 4)) << 3;
            int n2 = this.ch;
            this.wave[n2] = this.wave[n2] % 1024.0;
            this.oldmodout[this.ch] = this.mod[this.ch];
            ++this.fmctr;
            this.fmctr %= vib.length;
            ++this.amctr;
            this.amctr %= am.length;
        }
    }

    private int operator(int phase, int gain, boolean rectify) {
        return this.exp(this.logsin(phase, rectify) + gain);
    }

    private int exp(int val) {
        if (val > 8191) {
            val = 8191;
        }
        int mantissa = exp[-val & 0xFF];
        int exponent = -val >> 8;
        int b = (mantissa + 1024 >> -exponent) * this.s;
        return b;
    }

    private int logsin(int x, boolean rectify) {
        switch (x >> 8 & 3) {
            case 0: {
                this.s = 1;
                return logsin[x & 0xFF];
            }
            case 1: {
                this.s = 1;
                return logsin[255 - (x & 0xFF)];
            }
            case 2: {
                this.s = rectify ? 0 : -1;
                return logsin[x & 0xFF];
            }
        }
        this.s = rectify ? 0 : -1;
        return logsin[255 - (x & 0xFF)];
    }

    @Override
    public final int getval() {
        return this.out[0] + this.out[1] + this.out[2] + this.out[3] + this.out[4] + this.out[5];
    }

    private void setenvelope(int[] instrument, adsr[] state, double[] vol, int ch, boolean isCarrier) {
        switch (state[ch]) {
            case CUTOFF: {
                if (vol[ch] < 511.0) {
                    int n = ch;
                    vol[n] = vol[n] + 2.0;
                    break;
                }
                vol[ch] = 511.0;
                if (!this.key[ch]) break;
                state[ch] = adsr.ATTACK;
                break;
            }
            case ATTACK: {
                if (vol[ch] > 0.01) {
                    int n = ch;
                    vol[n] = vol[n] - (vol[ch] + 17.0) / 272.0 * attack_tbl[(instrument[isCarrier ? 5 : 4] >> 4) * 4 + (utils.getbit(instrument[isCarrier ? 1 : 0], 4) ? this.octave[ch] << 1 : this.octave[ch] >> 1)];
                } else {
                    state[ch] = adsr.DECAY;
                }
                if (this.key[ch]) break;
                state[ch] = adsr.RELEASE;
                break;
            }
            case DECAY: {
                double d = vol[ch];
                int n = isCarrier ? 7 : 6;
                if (d < (double)((instrument[n] >> 4) * 32)) {
                    int n2 = ch;
                    vol[n2] = vol[n2] + decay_tbl[(instrument[isCarrier ? 5 : 4] & 0xF) * 4 + (utils.getbit(instrument[isCarrier ? 1 : 0], 4) ? this.octave[ch] << 1 : this.octave[ch] >> 1)];
                } else {
                    state[ch] = adsr.RELEASE;
                }
                if (this.key[ch]) break;
                state[ch] = adsr.RELEASE;
                break;
            }
            case RELEASE: {
                if (!this.key[ch] && vol[ch] < 511.0) {
                    if (this.sust[ch]) {
                        int n = ch;
                        vol[n] = vol[n] + 0.001;
                        break;
                    }
                    int n = ch;
                    vol[n] = vol[n] + 0.005;
                    break;
                }
                if (!(vol[ch] < 511.0)) break;
                if (utils.getbit(instrument[isCarrier ? 1 : 0], 5)) {
                    if (this.key[ch]) break;
                    state[ch] = adsr.SUSTRELEASE;
                    break;
                }
                int n = ch;
                vol[n] = vol[n] + decay_tbl[(instrument[isCarrier ? 7 : 6] & 0xF) * 4 + (utils.getbit(instrument[isCarrier ? 1 : 0], 4) ? this.octave[ch] << 1 : this.octave[ch] >> 1)];
                break;
            }
            case SUSTRELEASE: {
                if (!(vol[ch] < 511.0)) break;
                if (this.sust[ch]) {
                    int n = ch;
                    vol[n] = vol[n] + 1.0E-4;
                    break;
                }
                int n = ch;
                vol[n] = vol[n] + decay_tbl[(instrument[isCarrier ? 7 : 6] & 0xF) * 4 + (utils.getbit(instrument[isCarrier ? 1 : 0], 4) ? this.octave[ch] << 1 : this.octave[ch] >> 1)];
            }
        }
        if (vol[ch] < 0.0) {
            vol[ch] = 0.0;
        }
        if (vol[ch] > 511.0) {
            vol[ch] = 511.0;
        }
    }

    private static enum adsr {
        CUTOFF,
        ATTACK,
        DECAY,
        SUSTAIN,
        SUSTRELEASE,
        RELEASE;

    }
}

