/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.AudioOutInterface;
import com.grapeshot.halfnes.audio.CircularBuffer;

public class Reverberator
implements AudioOutInterface {
    AudioOutInterface iface;
    CircularBuffer cb;
    double echo;
    double lp_coef;
    double hp_coef;
    int lpaccum = 0;
    private int dckiller = 0;

    public Reverberator(AudioOutInterface i, int length, double echo_gain, double lp_coef, double hp_coef) {
        this.echo = echo_gain;
        this.lp_coef = lp_coef;
        this.hp_coef = hp_coef;
        this.iface = i;
        this.cb = new CircularBuffer(length);
    }

    private int lowpass_filter(int sample) {
        this.lpaccum = (int)((double)this.lpaccum - (double)(sample += this.lpaccum) * this.lp_coef);
        return this.lpaccum;
    }

    private int highpass_filter(int sample) {
        this.dckiller = (int)((double)this.dckiller - (double)(sample += this.dckiller) * this.hp_coef);
        this.dckiller += sample > 0 ? -1 : 1;
        return sample;
    }

    @Override
    public void outputSample(int sample) {
        if ((sample = (int)((double)sample - (double)this.cb.read() * this.echo)) < Short.MIN_VALUE) {
            sample = Short.MIN_VALUE;
        }
        if (sample > Short.MAX_VALUE) {
            sample = Short.MAX_VALUE;
        }
        this.cb.write(this.lowpass_filter(this.highpass_filter(sample)));
        if (this.iface != null) {
            this.iface.outputSample(sample);
        }
    }

    @Override
    public void flushFrame(boolean waitIfBufferFull) {
        if (this.iface != null) {
            this.iface.flushFrame(waitIfBufferFull);
        }
    }

    @Override
    public void pause() {
        if (this.iface != null) {
            this.iface.pause();
        }
    }

    @Override
    public void resume() {
        if (this.iface != null) {
            this.iface.resume();
        }
    }

    @Override
    public void destroy() {
        if (this.iface != null) {
            this.iface.destroy();
        }
    }

    @Override
    public boolean bufferHasLessThan(int samples) {
        if (this.iface != null) {
            return this.iface.bufferHasLessThan(samples);
        }
        return false;
    }
}

