/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.FileUtils;
import com.grapeshot.halfnes.mappers.BadMapperException;
import com.grapeshot.halfnes.mappers.Mapper;
import com.grapeshot.halfnes.utils;

public class ROMLoader {
    public String name;
    public int prgsize;
    public int chrsize;
    public Mapper.MirrorType scrolltype;
    public int mappertype;
    public int prgoff;
    public int chroff;
    public boolean savesram = false;
    private int[] therom;

    public ROMLoader(String filename) {
        this.therom = FileUtils.readfromfile(filename);
        this.name = filename;
    }

    public int[] ReadHeader(int len) {
        return this.load(len, -16);
    }

    public void parseInesheader() throws BadMapperException {
        int[] inesheader = this.ReadHeader(16);
        if (inesheader[0] != 78 || inesheader[1] != 69 || inesheader[2] != 83 || inesheader[3] != 26) {
            if (inesheader[0] == 85) {
                throw new BadMapperException("This is a UNIF file with the wrong extension");
            }
            throw new BadMapperException("iNES Header Invalid");
        }
        this.prgsize = 16384 * inesheader[4];
        if (this.prgsize == 0) {
            throw new BadMapperException("No PRG ROM size in header");
        }
        this.chrsize = 8192 * inesheader[5];
        this.scrolltype = utils.getbit(inesheader[6], 3) ? Mapper.MirrorType.FOUR_SCREEN_MIRROR : (utils.getbit(inesheader[6], 0) ? Mapper.MirrorType.V_MIRROR : Mapper.MirrorType.H_MIRROR);
        this.savesram = utils.getbit(inesheader[6], 1);
        this.mappertype = inesheader[6] >> 4;
        if (inesheader[11] + inesheader[12] + inesheader[13] + inesheader[14] + inesheader[15] == 0) {
            this.mappertype += inesheader[7] >> 4 << 4;
        }
        this.prgoff = 0;
        this.chroff = 0 + this.prgsize;
    }

    public int[] load(int size, int offset) {
        int[] bindata = new int[size];
        System.arraycopy(this.therom, offset + 16, bindata, 0, size);
        return bindata;
    }
}

