/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class PreferencesDialog
extends JDialog {
    Preferences prefs;
    private int[][] keys;
    private int screenScaling;
    private boolean okClicked = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxNTSC;
    private JCheckBox jCheckBoxSmoothVideo;
    private JCheckBox jCheckMaintainAspect;
    private JCheckBox jCheckSoundEnable;
    private JCheckBox jCheckSoundFiltering;
    private JTextField jField1A;
    private JTextField jField1B;
    private JTextField jField1Down;
    private JTextField jField1Left;
    private JTextField jField1Right;
    private JTextField jField1Select;
    private JTextField jField1Start;
    private JTextField jField1Up;
    private JTextField jField2A;
    private JTextField jField2B;
    private JTextField jField2Down;
    private JTextField jField2Left;
    private JTextField jField2Right;
    private JTextField jField2Select;
    private JTextField jField2Start;
    private JTextField jField2Up;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JComboBox jSampleRateBox;
    private JSpinner jSpinnerScale;
    private JSlider volumeSlider;

    public PreferencesDialog(Frame parent, Preferences prefs) {
        super(parent, true);
        int[][] keys = new int[][]{{prefs.getInt("keyUp1", 38), prefs.getInt("keyDown1", 40), prefs.getInt("keyLeft1", 37), prefs.getInt("keyRight1", 39), prefs.getInt("keyA1", 88), prefs.getInt("keyB1", 90), prefs.getInt("keySelect1", 16), prefs.getInt("keyStart1", 10)}, {prefs.getInt("keyUp2", 87), prefs.getInt("keyDown2", 83), prefs.getInt("keyLeft2", 65), prefs.getInt("keyRight2", 68), prefs.getInt("keyA2", 71), prefs.getInt("keyB2", 70), prefs.getInt("keySelect2", 82), prefs.getInt("keyStart2", 84)}};
        this.keys = keys;
        this.prefs = prefs;
        this.initComponents();
        this.setTitle("HalfNES Preferences");
        this.jField1Up.setText(KeyEvent.getKeyText(keys[0][0]));
        this.jField1Down.setText(KeyEvent.getKeyText(keys[0][1]));
        this.jField1Left.setText(KeyEvent.getKeyText(keys[0][2]));
        this.jField1Right.setText(KeyEvent.getKeyText(keys[0][3]));
        this.jField1A.setText(KeyEvent.getKeyText(keys[0][4]));
        this.jField1B.setText(KeyEvent.getKeyText(keys[0][5]));
        this.jField1Select.setText(KeyEvent.getKeyText(keys[0][6]));
        this.jField1Start.setText(KeyEvent.getKeyText(keys[0][7]));
        this.jField2Up.setText(KeyEvent.getKeyText(keys[1][0]));
        this.jField2Down.setText(KeyEvent.getKeyText(keys[1][1]));
        this.jField2Left.setText(KeyEvent.getKeyText(keys[1][2]));
        this.jField2Right.setText(KeyEvent.getKeyText(keys[1][3]));
        this.jField2A.setText(KeyEvent.getKeyText(keys[1][4]));
        this.jField2B.setText(KeyEvent.getKeyText(keys[1][5]));
        this.jField2Select.setText(KeyEvent.getKeyText(keys[1][6]));
        this.jField2Start.setText(KeyEvent.getKeyText(keys[1][7]));
        this.jCheckSoundEnable.setSelected(prefs.getBoolean("soundEnable", true));
        this.jCheckSoundFiltering.setSelected(prefs.getBoolean("soundFiltering", false));
        this.jCheckMaintainAspect.setSelected(prefs.getBoolean("maintainAspect", true));
        this.jCheckBoxNTSC.setSelected(prefs.getBoolean("TVEmulation", false));
        this.jButtonOK.setActionCommand("OK");
        this.jButtonCancel.setActionCommand("Cancel");
        this.screenScaling = prefs.getInt("screenScaling", 2);
        this.jSpinnerScale.setValue(this.screenScaling);
        this.jSampleRateBox.setSelectedItem(Integer.toString(prefs.getInt("sampleRate", 44100)));
        this.jCheckBoxSmoothVideo.setSelected(prefs.getBoolean("smoothScaling", false));
        this.volumeSlider.setValue(prefs.getInt("outputvol", 13107));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jCheckSoundEnable = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jField1Up = new JTextField();
        this.jField1Down = new JTextField();
        this.jField1Right = new JTextField();
        this.jField1Left = new JTextField();
        this.jField1Start = new JTextField();
        this.jField1Select = new JTextField();
        this.jField1B = new JTextField();
        this.jField1A = new JTextField();
        this.jField2Up = new JTextField();
        this.jField2Down = new JTextField();
        this.jField2Left = new JTextField();
        this.jField2Right = new JTextField();
        this.jField2A = new JTextField();
        this.jField2B = new JTextField();
        this.jField2Select = new JTextField();
        this.jField2Start = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSampleRateBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jCheckMaintainAspect = new JCheckBox();
        this.jLabel14 = new JLabel();
        this.jCheckSoundFiltering = new JCheckBox();
        this.jLabel16 = new JLabel();
        this.jLabel15 = new JLabel();
        this.volumeSlider = new JSlider();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jCheckBoxNTSC = new JCheckBox();
        this.jLabel19 = new JLabel();
        this.jSpinnerScale = new JSpinner();
        this.jLabel20 = new JLabel();
        this.jCheckBoxSmoothVideo = new JCheckBox();
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("OptionsDialog");
        this.setResizable(false);
        this.jLabel1.setText("Screen scaling: scale up ");
        this.jCheckSoundEnable.setText("Enable Sound");
        this.jLabel3.setText("Keybindings:");
        this.jLabel4.setText("Controller 1");
        this.jLabel5.setText("Controller 2");
        this.jLabel6.setText("Up");
        this.jLabel7.setText("Down");
        this.jLabel8.setText("Left");
        this.jLabel9.setText("Right");
        this.jLabel10.setText("A");
        this.jLabel11.setText("B");
        this.jLabel12.setText("Select");
        this.jLabel13.setText("Start");
        this.jField1Up.setMinimumSize(new Dimension(120, 20));
        this.jField1Up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jField2StartActionPerformed(evt);
            }
        });
        this.jField1Up.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField1UpKeyReleased(evt);
            }
        });
        this.jField1Down.setMinimumSize(new Dimension(120, 20));
        this.jField1Down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jField2StartActionPerformed(evt);
            }
        });
        this.jField1Down.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField1DownKeyReleased(evt);
            }
        });
        this.jField1Right.setMinimumSize(new Dimension(120, 20));
        this.jField1Right.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jField2StartActionPerformed(evt);
            }
        });
        this.jField1Right.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField1RightKeyReleased(evt);
            }
        });
        this.jField1Left.setMinimumSize(new Dimension(120, 20));
        this.jField1Left.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jField2StartActionPerformed(evt);
            }
        });
        this.jField1Left.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField1LeftKeyReleased(evt);
            }
        });
        this.jField1Start.setMinimumSize(new Dimension(120, 20));
        this.jField1Start.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField1StartKeyReleased(evt);
            }
        });
        this.jField1Select.setMinimumSize(new Dimension(120, 20));
        this.jField1Select.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField1SelectKeyReleased(evt);
            }
        });
        this.jField1B.setMinimumSize(new Dimension(120, 20));
        this.jField1B.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField1BKeyReleased(evt);
            }
        });
        this.jField1A.setMinimumSize(new Dimension(120, 20));
        this.jField1A.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField1AKeyReleased(evt);
            }
        });
        this.jField2Up.setMinimumSize(new Dimension(120, 20));
        this.jField2Up.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField2UpKeyReleased(evt);
            }
        });
        this.jField2Down.setMinimumSize(new Dimension(120, 20));
        this.jField2Down.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField2DownKeyReleased(evt);
            }
        });
        this.jField2Left.setMinimumSize(new Dimension(120, 20));
        this.jField2Left.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField2LeftKeyReleased(evt);
            }
        });
        this.jField2Right.setMinimumSize(new Dimension(120, 20));
        this.jField2Right.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField2RightKeyReleased(evt);
            }
        });
        this.jField2A.setMinimumSize(new Dimension(120, 20));
        this.jField2A.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField2AKeyReleased(evt);
            }
        });
        this.jField2B.setMinimumSize(new Dimension(120, 20));
        this.jField2B.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField2BKeyReleased(evt);
            }
        });
        this.jField2Select.setMinimumSize(new Dimension(120, 20));
        this.jField2Select.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField2SelectKeyReleased(evt);
            }
        });
        this.jField2Start.setMinimumSize(new Dimension(120, 20));
        this.jField2Start.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreferencesDialog.this.jField2StartKeyReleased(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jSampleRateBox.setModel(new DefaultComboBoxModel<String>(new String[]{"16000", "24000", "44100", "48000", "96000"}));
        this.jSampleRateBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jSampleRateBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Sample Rate:");
        this.jCheckMaintainAspect.setText("Maintain Aspect Ratio");
        this.jLabel14.setText("Sound:");
        this.jCheckSoundFiltering.setText("Enable Filtering (slow)");
        this.jCheckSoundFiltering.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jCheckSoundFilteringActionPerformed(evt);
            }
        });
        this.jLabel16.setText(" (click in text box and type a key to change)");
        this.jLabel15.setText("Output Volume:");
        this.volumeSlider.setMajorTickSpacing(8192);
        this.volumeSlider.setMaximum(16384);
        this.volumeSlider.setMinorTickSpacing(4096);
        this.volumeSlider.setPaintTicks(true);
        this.volumeSlider.setValue(80);
        this.jLabel17.setText("0");
        this.jLabel18.setText("100");
        this.jCheckBoxNTSC.setText("Use NTSC TV Filter (Experimental)");
        this.jCheckBoxNTSC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jCheckBoxNTSCActionPerformed(evt);
            }
        });
        this.jLabel19.setText("Video options:");
        this.jSpinnerScale.setModel(new SpinnerNumberModel(2, 1, 6, 1));
        this.jLabel20.setText("times");
        this.jCheckBoxSmoothVideo.setText("Use Smooth Scaling");
        this.jCheckBoxSmoothVideo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.jCheckBoxSmoothVideoActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel11).addComponent(this.jLabel13).addComponent(this.jLabel6).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jField1Right, -2, 60, -2).addComponent(this.jField1Left, -2, 60, -2).addComponent(this.jField1B, -2, 60, -2).addComponent(this.jField1A, -2, 60, -2).addComponent(this.jField1Start, -2, 60, -2).addComponent(this.jField1Select, -2, 60, -2).addComponent(this.jField1Up, -2, 60, -2).addComponent(this.jField1Down, -2, 60, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jField2Select, -2, 60, -2).addComponent(this.jField2B, -2, 60, -2).addComponent(this.jField2Start, -2, 60, -2).addComponent(this.jField2A, -2, 60, -2).addComponent(this.jField2Right, -2, 60, -2).addComponent(this.jField2Up, -2, 60, -2).addComponent(this.jField2Down, -2, 60, -2).addComponent(this.jField2Left, -2, 60, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 156, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.volumeSlider, -2, -1, -2).addComponent(this.jLabel14).addComponent(this.jCheckSoundEnable).addComponent(this.jCheckSoundFiltering).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSampleRateBox, -2, 83, -2)).addComponent(this.jLabel15).addGroup(layout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel18)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerScale, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel20, -2, 26, -2)).addComponent(this.jLabel19).addComponent(this.jCheckBoxNTSC).addComponent(this.jCheckMaintainAspect).addComponent(this.jCheckBoxSmoothVideo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)))))).addComponent(this.jLabel16).addComponent(this.jLabel3)).addGap(10, 10, 10)));
        layout.linkSize(0, this.jField1A, this.jField1B, this.jField1Down, this.jField1Left, this.jField1Right, this.jField1Select, this.jField1Start, this.jField1Up, this.jField2A, this.jField2B, this.jField2Down, this.jField2Left, this.jField2Right, this.jField2Select, this.jField2Start, this.jField2Up);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jSpinnerScale, -2, -1, -2).addComponent(this.jLabel20)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSmoothVideo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckMaintainAspect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxNTSC).addGap(12, 12, 12).addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckSoundEnable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckSoundFiltering).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSampleRateBox, -2, 20, -2)).addGap(3, 3, 3).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17).addComponent(this.jLabel18)).addGap(29, 29, 29)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jField2Up, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jField1Up, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Down, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Left, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Right, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jField2Right, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1A, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.jField2A, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.jField2Down, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jField2Left, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1B, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.jField2B, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Select, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.jField2Select, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jField1Start, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.jField2Start, -2, -1, -2)))))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(298, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        layout.linkSize(1, this.jField1A, this.jField1B, this.jField1Down, this.jField1Left, this.jField1Right, this.jField1Select, this.jField1Start, this.jField1Up, this.jField2A, this.jField2B, this.jField2Down, this.jField2Left, this.jField2Right, this.jField2Select, this.jField2Start, this.jField2Up);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if ("Cancel".equals(evt.getActionCommand())) {
            this.setVisible(false);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.prefs.putInt("keyUp1", this.keys[0][0]);
        this.prefs.putInt("keyDown1", this.keys[0][1]);
        this.prefs.putInt("keyLeft1", this.keys[0][2]);
        this.prefs.putInt("keyRight1", this.keys[0][3]);
        this.prefs.putInt("keyA1", this.keys[0][4]);
        this.prefs.putInt("keyB1", this.keys[0][5]);
        this.prefs.putInt("keySelect1", this.keys[0][6]);
        this.prefs.putInt("keyStart1", this.keys[0][7]);
        this.prefs.putInt("keyUp2", this.keys[1][0]);
        this.prefs.putInt("keyDown2", this.keys[1][1]);
        this.prefs.putInt("keyLeft2", this.keys[1][2]);
        this.prefs.putInt("keyRight2", this.keys[1][3]);
        this.prefs.putInt("keyA2", this.keys[1][4]);
        this.prefs.putInt("keyB2", this.keys[1][5]);
        this.prefs.putInt("keySelect2", this.keys[1][6]);
        this.prefs.putInt("keyStart2", this.keys[1][7]);
        this.prefs.putBoolean("soundEnable", this.jCheckSoundEnable.isSelected());
        this.prefs.putBoolean("soundFiltering", this.jCheckSoundFiltering.isSelected());
        this.prefs.putBoolean("maintainAspect", this.jCheckMaintainAspect.isSelected());
        this.prefs.putBoolean("TVEmulation", this.jCheckBoxNTSC.isSelected());
        this.screenScaling = (Integer)this.jSpinnerScale.getModel().getValue();
        this.prefs.putBoolean("smoothScaling", this.jCheckBoxSmoothVideo.isSelected());
        this.prefs.putInt("screenScaling", this.screenScaling);
        this.prefs.putInt("sampleRate", Integer.parseInt(this.jSampleRateBox.getSelectedItem().toString()));
        this.prefs.putInt("outputvol", this.volumeSlider.getValue());
        this.okClicked = true;
        this.setVisible(false);
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    private void jField1UpKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Up.setText(KeyEvent.getKeyText(k));
        this.keys[0][0] = k;
    }

    private void jField1DownKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Down.setText(KeyEvent.getKeyText(k));
        this.keys[0][1] = k;
    }

    private void jField1LeftKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Left.setText(KeyEvent.getKeyText(k));
        this.keys[0][2] = k;
    }

    private void jField1RightKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Right.setText(KeyEvent.getKeyText(k));
        this.keys[0][3] = k;
    }

    private void jField2StartActionPerformed(ActionEvent evt) {
    }

    private void jField1AKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1A.setText(KeyEvent.getKeyText(k));
        this.keys[0][4] = k;
    }

    private void jField1BKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1B.setText(KeyEvent.getKeyText(k));
        this.keys[0][5] = k;
    }

    private void jField1SelectKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Select.setText(KeyEvent.getKeyText(k));
        this.keys[0][6] = k;
    }

    private void jField1StartKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField1Start.setText(KeyEvent.getKeyText(k));
        this.keys[0][7] = k;
    }

    private void jField2UpKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Up.setText(KeyEvent.getKeyText(k));
        this.keys[1][0] = k;
    }

    private void jField2StartKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Start.setText(KeyEvent.getKeyText(k));
        this.keys[1][7] = k;
    }

    private void jField2DownKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Down.setText(KeyEvent.getKeyText(k));
        this.keys[1][1] = k;
    }

    private void jField2LeftKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Left.setText(KeyEvent.getKeyText(k));
        this.keys[1][2] = k;
    }

    private void jField2RightKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Right.setText(KeyEvent.getKeyText(k));
        this.keys[1][3] = k;
    }

    private void jField2AKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2A.setText(KeyEvent.getKeyText(k));
        this.keys[1][4] = k;
    }

    private void jField2BKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2B.setText(KeyEvent.getKeyText(k));
        this.keys[1][5] = k;
    }

    private void jField2SelectKeyReleased(KeyEvent evt) {
        int k = evt.getKeyCode();
        this.jField2Select.setText(KeyEvent.getKeyText(k));
        this.keys[1][6] = k;
    }

    private void jSampleRateBoxActionPerformed(ActionEvent evt) {
    }

    private void jCheckSoundFilteringActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxNTSCActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxSmoothVideoActionPerformed(ActionEvent evt) {
    }
}

