/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

public class NesColors {
    private static final double att = 0.7;
    public static final int[][] col = NesColors.GetNESColors();

    private static int[][] GetNESColors() {
        int[] colorarray = new int[]{0x757575, 2562959, 171, 4653215, 9371767, 11206675, 0xA70000, 8325888, 4402944, 18176, 20736, 16151, 1785695, 0, 0, 0, 0xBCBCBC, 29679, 2309103, 8585459, 0xBF00BF, 15138907, 14363392, 13324047, 9138944, 38656, 43776, 37691, 33675, 0, 0, 0, 0xFFFFFF, 0x3FBFFF, 6264831, 10980349, 0xF77BFF, 0xFF77B7, 16742243, 16751419, 0xF3BF3F, 8639251, 5234507, 5830808, 60379, 0x444444, 0, 0, 0xFFFFFF, 11266047, 13096959, 14142463, 0xFFC7FF, 16762843, 0xFFBFB3, 16767915, 16770979, 14942115, 11269055, 11796431, 0x9FFFF3, 0xAAAAAA, 0, 0};
        int i = 0;
        while (i < colorarray.length) {
            int n = i++;
            colorarray[n] = colorarray[n] | 0xFF000000;
        }
        int[][] colors = new int[8][colorarray.length];
        for (int j = 0; j < colorarray.length; ++j) {
            int col = colorarray[j];
            int r = NesColors.r(col);
            int b = NesColors.b(col);
            int g = NesColors.g(col);
            colors[0][j] = col;
            colors[1][j] = NesColors.compose_col(r, (double)g * 0.7, (double)b * 0.7);
            colors[2][j] = NesColors.compose_col((double)r * 0.7, g, (double)b * 0.7);
            colors[3][j] = NesColors.compose_col(r, g, (double)b * 0.7);
            colors[4][j] = NesColors.compose_col((double)r * 0.7, (double)g * 0.7, b);
            colors[5][j] = NesColors.compose_col(r, (double)g * 0.7, b);
            colors[6][j] = NesColors.compose_col((double)r * 0.7, g, b);
            colors[7][j] = NesColors.compose_col((double)r * 0.7, (double)g * 0.7, (double)b * 0.7);
        }
        return colors;
    }

    private static int r(int col) {
        return col >> 16 & 0xFF;
    }

    private static int g(int col) {
        return col >> 8 & 0xFF;
    }

    private static int b(int col) {
        return col & 0xFF;
    }

    private static int compose_col(double r, double g, double b) {
        return (((int)r & 0xFF) << 16) + (((int)g & 0xFF) << 8) + ((int)b & 0xFF) + -16777216;
    }
}

