/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.Renderer;
import java.awt.image.BufferedImage;

public class NTSCRenderer
extends Renderer {
    private int offset = 0;
    private int scanline = 0;
    private static final boolean VHS = false;
    private static final byte[][] colorphases = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1}, {1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    private static final double[][][] lumas = NTSCRenderer.genlumas();
    private static final int[][] coloremph = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    private int frames = 0;
    private final double[] i_filter = new double[12];
    private final double[] q_filter = new double[12];
    final double[] sample = new double[2728];
    private static final int[] colortbl = NTSCRenderer.genColorCorrectTbl();
    public static final double chroma_filterfreq = 3579000.0;
    public static final double pixel_rate = 4.295E7;
    private static final int coldelay = 12;
    private static final int[][] iqm = new int[][]{{255, -244, 158}, {255, 69, -165}, {255, 282, 434}};
    public static final int frame_w = 2112;
    int[] out = new int[2112];
    int[] frame = new int[506880];
    double[] xv = new double[5];
    double[] yv = new double[5];
    private static final double[] a = new double[]{2.143505E-4, 8.566037E-4, 1.284906E-4, 8.566037E-4, 9.726342E-4};
    private static final double[] b = new double[]{3.425455, -4.479272, 2.643718, -0.5933269};
    double hold = 0.0;

    public NTSCRenderer() {
        int hue = -80;
        double col_adjust = 1.6973125884016973;
        for (int j = 0; j < 12; ++j) {
            double angle = Math.PI * ((double)(hue + (j << 8)) / 1536.0 - 0.18333333333333332);
            this.i_filter[j] = -col_adjust * Math.cos(angle);
            this.q_filter[j] = col_adjust * Math.sin(angle);
        }
    }

    public static int[] genColorCorrectTbl() {
        int[] corr = new int[256];
        double brightness = 20.0;
        double contrast = 1.0;
        for (int i = 0; i < 256; ++i) {
            double br = ((double)i * contrast - 128.0 * contrast + 128.0 + brightness) / 255.0;
            corr[i] = NTSCRenderer.clamp((int)(255.0 * Math.pow(br, 1.3)));
        }
        return corr;
    }

    public static double[][][] genlumas() {
        double[][] lumas = new double[][]{{-0.117f, 0.0, 0.308f, 0.715f}, {0.397f, 0.681f, 1.0, 1.0}};
        double[][][] premultlumas = new double[lumas.length][lumas[0].length][2];
        for (int i = 0; i < lumas.length; ++i) {
            for (int j = 0; j < lumas[i].length; ++j) {
                premultlumas[i][j][0] = lumas[i][j];
                premultlumas[i][j][1] = lumas[i][j] * 0.735;
            }
        }
        return premultlumas;
    }

    public final double[] ntsc_encode(int[] nescolors, int pxloffset, int bgcolor, boolean dotcrawl) {
        int phase;
        int i;
        ++this.scanline;
        if (this.scanline > 239) {
            this.scanline = 0;
            ++this.frames;
            this.offset = (this.frames & 1) == 0 && dotcrawl ? 6 : 0;
        }
        this.offset = (this.offset + 4) % 12;
        int col = bgcolor & 0xF;
        int level = bgcolor >> 4 & 3;
        int emphasis = bgcolor >> 6;
        for (i = 400; i < 520; ++i) {
            phase = (i + this.offset) % 12;
            this.sample[i] = lumas[colorphases[col][phase]][level][coloremph[emphasis][phase]];
        }
        for (i = 2568; i < 2656; ++i) {
            phase = (i + this.offset) % 12;
            this.sample[i] = lumas[colorphases[col][phase]][level][coloremph[emphasis][phase]];
        }
        for (i = 520; i < 2568; ++i) {
            if ((i & 7) == 0) {
                col = nescolors[(i - 520 >> 3) + pxloffset];
                if ((col & 0xF) > 13) {
                    col = 15;
                }
                level = col >> 4 & 3;
                emphasis = col >> 6;
                col &= 0xF;
            }
            phase = (i + this.offset) % 12;
            this.sample[i] = lumas[colorphases[col][phase]][level][coloremph[emphasis][phase]];
        }
        return this.sample;
    }

    public final void ntsc_decode(double[] ntsc, int[] frame, int frameoff) {
        int cbst;
        double[] luma = new double[2728];
        double[] eye = new double[2728];
        double[] queue = new double[2728];
        this.box_filter(ntsc, luma, 12);
        this.highpass_filter(ntsc);
        double[] chroma = ntsc;
        switch (this.offset) {
            case 10: {
                cbst = 242;
                break;
            }
            case 2: {
                cbst = 250;
                break;
            }
            case 6: {
                cbst = 246;
                break;
            }
            case 4: {
                cbst = 248;
                break;
            }
            case 8: {
                cbst = 244;
                break;
            }
            default: {
                cbst = 240;
            }
        }
        int x = 492;
        int j = 0;
        int i = cbst - 12;
        while (i < 2620) {
            eye[i] = this.i_filter[j] * chroma[cbst];
            queue[i] = this.q_filter[j] * chroma[cbst];
            ++i;
            ++j;
            ++cbst;
            j %= 12;
        }
        this.lowpass_filter(eye, 0.04);
        this.lowpass_filter(queue, 0.03);
        for (i = 0; i < 2112; ++i) {
            frame[i + frameoff] = NTSCRenderer.compose_col(luma[++x] <= 0.0 ? 0 : colortbl[NTSCRenderer.clamp((int)((double)iqm[0][0] * luma[x] + (double)iqm[0][1] * eye[x] + (double)iqm[0][2] * queue[x]))], luma[x] <= 0.0 ? 0 : colortbl[NTSCRenderer.clamp((int)((double)iqm[1][0] * luma[x] + (double)iqm[1][1] * eye[x] + (double)iqm[1][2] * queue[x]))], luma[x] <= 0.0 ? 0 : colortbl[NTSCRenderer.clamp((int)((double)iqm[2][0] * luma[x] + (double)iqm[2][1] * eye[x] + (double)iqm[2][2] * queue[x]))]);
        }
    }

    private static int compose_col(int r, int g, int b) {
        return r << 16 | g << 8 | b | 0xFF000000;
    }

    public static int clamp(int a) {
        return a != (a & 0xFF) ? (a < 0 ? 0 : 255) : a;
    }

    @Override
    public BufferedImage render(int[] nespixels, int[] bgcolors, boolean dotcrawl) {
        for (int line = 0; line < 240; ++line) {
            this.ntsc_decode(this.ntsc_encode(nespixels, line * 256, bgcolors[line], dotcrawl), this.frame, line * 2112);
        }
        BufferedImage i = NTSCRenderer.getImageFromArray(this.frame, 16896, 2112, 224);
        return i;
    }

    public final void ch_filter(double[] filter_in, double[] filter_out) {
        for (int i = 358; i < 2656; ++i) {
            filter_out[i] = a[0] * filter_in[i] + a[1] * filter_in[i - 1] + a[2] * filter_in[i - 2] + a[3] * filter_in[i - 3] + a[4] * filter_in[i - 4] + b[0] * filter_out[i - 1] + b[1] * filter_out[i - 2] + b[2] * filter_out[i - 3] + b[3] * filter_out[i - 4];
        }
    }

    public final void box_filter(double[] in, double[] out, int order) {
        int l = in.length;
        double accum = 0.0;
        for (int i = 358; i < 2656; ++i) {
            out[i] = (accum += in[i] - in[i - order]) / (double)order;
        }
    }

    public final void lowpass_filter(double[] arr, double order) {
        double b = 0.0;
        for (int i = 358; i < 2656; ++i) {
            int n = i;
            arr[n] = arr[n] - b;
            arr[i] = b += arr[i] * order;
        }
    }

    public final void highpass_filter(double[] arr) {
        double b = 0.0;
        for (int i = 358; i < 2656; ++i) {
            int n = i;
            arr[n] = arr[n] + b;
            b -= arr[i] * 0.5;
        }
    }
}

