/*
 * Decompiled with CFR 0.152.
 */
package com.grapeshot.halfnes;

import com.grapeshot.halfnes.CPURAM;
import com.grapeshot.halfnes.utils;
import java.io.FileWriter;

public final class CPU {
    private final CPURAM ram;
    public int cycles;
    private int A;
    private int X;
    private int Y;
    private int S;
    public int PC;
    private boolean carryFlag = false;
    private boolean zeroFlag = false;
    private boolean interruptsDisabled = true;
    private boolean decimalModeFlag = false;
    private boolean overflowFlag = false;
    private boolean negativeFlag = false;
    private boolean previntflag = false;
    private int pb = 0;
    public int interrupt = 0;
    private static final int ntscframe = 29780;
    private static final boolean logging = false;
    private static final boolean decimalModeEnable = false;
    private boolean interruptDelay = false;
    private static final String[] opcodes = CPU.opcodes();
    FileWriter w;

    public CPU(CPURAM cpuram) {
        this.ram = cpuram;
    }

    public void init() {
        int i;
        for (i = 0; i < 2048; ++i) {
            this.ram.write(i, 255);
        }
        this.ram.write(8, 247);
        this.ram.write(9, 239);
        this.ram.write(10, 223);
        this.ram.write(15, 191);
        for (i = 16384; i <= 16399; ++i) {
            this.ram.write(i, 0);
        }
        this.ram.write(16405, 0);
        this.ram.write(16407, 0);
        this.cycles = 27394;
        this.A = 0;
        this.X = 0;
        this.Y = 0;
        this.S = 253;
        this.PC = this.ram.read(65533) * 256 + this.ram.read(65532);
    }

    public void reset() {
        this.PC = this.ram.read(65533) * 256 + this.ram.read(65532);
        this.ram.write(16405, 0);
        this.ram.write(16407, this.ram.read(16407));
        this.S -= 3;
        this.S &= 0xFF;
        this.interruptsDisabled = true;
    }

    public final void cycle(int scanline, int endpixel) {
        while (this.cycles * 3 < scanline * 341 + endpixel) {
            int lastcycle = this.cycles;
            this.runcycle(scanline, this.cycles * 3 - scanline * 341);
            this.ram.mapper.cpucycle(this.cycles - lastcycle);
        }
    }

    public final void runcycle(int scanline, int pixel) {
        this.ram.read(16384);
        if (this.interrupt > 0) {
            if (!this.interruptsDisabled && !this.interruptDelay) {
                this.interrupt();
                this.cycles += 7;
                return;
            }
            if (this.interruptDelay) {
                this.interruptDelay = false;
                if (!this.previntflag) {
                    this.interrupt();
                    this.cycles += 7;
                    return;
                }
            }
        }
        this.pb = 0;
        int instr = this.ram.read(this.PC++);
        switch (instr) {
            case 105: {
                this.adc(this.imm());
                this.cycles += 2;
                break;
            }
            case 101: {
                this.adc(this.zpg());
                this.cycles += 3;
                break;
            }
            case 117: {
                this.adc(this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 109: {
                this.adc(this.abs());
                this.cycles += 4;
                break;
            }
            case 125: {
                this.adc(this.abs(this.X, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 121: {
                this.adc(this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 97: {
                this.adc(this.indX());
                this.cycles += 6;
                break;
            }
            case 113: {
                this.adc(this.indY(dummy.ONCARRY));
                this.cycles += 5 + this.pb;
                break;
            }
            case 147: {
                this.ahx(this.indY(dummy.ALWAYS));
                this.cycles += 6;
                break;
            }
            case 159: {
                this.ahx(this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 5;
                break;
            }
            case 75: {
                this.alr(this.imm());
                this.cycles += 2;
                break;
            }
            case 11: {
                this.anc(this.imm());
                this.cycles += 2;
                break;
            }
            case 43: {
                this.anc(this.imm());
                this.cycles += 2;
                break;
            }
            case 41: {
                this.and(this.imm());
                this.cycles += 2;
                break;
            }
            case 37: {
                this.and(this.zpg());
                this.cycles += 3;
                break;
            }
            case 53: {
                this.and(this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 45: {
                this.and(this.abs());
                this.cycles += 4;
                break;
            }
            case 61: {
                this.and(this.abs(this.X, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 57: {
                this.and(this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 33: {
                this.and(this.indX());
                this.cycles += 6;
                break;
            }
            case 49: {
                this.and(this.indY(dummy.ONCARRY));
                this.cycles += 5 + this.pb;
                break;
            }
            case 107: {
                this.arr(this.imm());
                this.cycles += 2;
                break;
            }
            case 10: {
                this.aslA();
                this.cycles += 2;
                break;
            }
            case 6: {
                this.asl(this.zpg());
                this.cycles += 5;
                break;
            }
            case 22: {
                this.asl(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 14: {
                this.asl(this.abs());
                this.cycles += 6;
                break;
            }
            case 30: {
                this.asl(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 203: {
                this.axs(this.imm());
                this.cycles += 2;
                break;
            }
            case 36: {
                this.bit(this.zpg());
                this.cycles += 3;
                break;
            }
            case 44: {
                this.bit(this.abs());
                this.cycles += 4;
                break;
            }
            case 16: {
                this.branch(!this.negativeFlag);
                this.cycles += 2 + this.pb;
                break;
            }
            case 48: {
                this.branch(this.negativeFlag);
                this.cycles += 2 + this.pb;
                break;
            }
            case 80: {
                this.branch(!this.overflowFlag);
                this.cycles += 2 + this.pb;
                break;
            }
            case 112: {
                this.branch(this.overflowFlag);
                this.cycles += 2 + this.pb;
                break;
            }
            case 144: {
                this.branch(!this.carryFlag);
                this.cycles += 2 + this.pb;
                break;
            }
            case 176: {
                this.branch(this.carryFlag);
                this.cycles += 2 + this.pb;
                break;
            }
            case 208: {
                this.branch(!this.zeroFlag);
                this.cycles += 2 + this.pb;
                break;
            }
            case 240: {
                this.branch(this.zeroFlag);
                this.cycles += 2 + this.pb;
                break;
            }
            case 0: {
                this.breakinterrupt();
                this.cycles += 7;
                break;
            }
            case 201: {
                this.cmp(this.A, this.imm());
                this.cycles += 2;
                break;
            }
            case 197: {
                this.cmp(this.A, this.zpg());
                this.cycles += 3;
                break;
            }
            case 213: {
                this.cmp(this.A, this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 205: {
                this.cmp(this.A, this.abs());
                this.cycles += 4;
                break;
            }
            case 221: {
                this.cmp(this.A, this.abs(this.X, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 217: {
                this.cmp(this.A, this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 193: {
                this.cmp(this.A, this.indX());
                this.cycles += 6;
                break;
            }
            case 209: {
                this.cmp(this.A, this.indY(dummy.ONCARRY));
                this.cycles += 5 + this.pb;
                break;
            }
            case 224: {
                this.cmp(this.X, this.imm());
                this.cycles += 2;
                break;
            }
            case 228: {
                this.cmp(this.X, this.zpg());
                this.cycles += 3;
                break;
            }
            case 236: {
                this.cmp(this.X, this.abs());
                this.cycles += 4;
                break;
            }
            case 192: {
                this.cmp(this.Y, this.imm());
                this.cycles += 2;
                break;
            }
            case 196: {
                this.cmp(this.Y, this.zpg());
                this.cycles += 3;
                break;
            }
            case 204: {
                this.cmp(this.Y, this.abs());
                this.cycles += 4;
                break;
            }
            case 198: {
                this.dec(this.zpg());
                this.cycles += 5;
                break;
            }
            case 214: {
                this.dec(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 206: {
                this.dec(this.abs());
                this.cycles += 6;
                break;
            }
            case 222: {
                this.dec(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 195: {
                this.dcp(this.A, this.indX());
                this.cycles += 8;
                break;
            }
            case 211: {
                this.dcp(this.A, this.indY(dummy.ALWAYS));
                this.cycles += 8;
                break;
            }
            case 199: {
                this.dcp(this.A, this.zpg());
                this.cycles += 5;
                break;
            }
            case 215: {
                this.dcp(this.A, this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 219: {
                this.dcp(this.A, this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 207: {
                this.dcp(this.A, this.abs());
                this.cycles += 6;
                break;
            }
            case 223: {
                this.dcp(this.A, this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 73: {
                this.eor(this.imm());
                this.cycles += 2;
                break;
            }
            case 69: {
                this.eor(this.zpg());
                this.cycles += 3;
                break;
            }
            case 85: {
                this.eor(this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 77: {
                this.eor(this.abs());
                this.cycles += 4;
                break;
            }
            case 93: {
                this.eor(this.abs(this.X, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 89: {
                this.eor(this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 65: {
                this.eor(this.indX());
                this.cycles += 6;
                break;
            }
            case 81: {
                this.eor(this.indY(dummy.ONCARRY));
                this.cycles += 5 + this.pb;
                break;
            }
            case 24: {
                this.carryFlag = false;
                this.cycles += 2;
                break;
            }
            case 56: {
                this.carryFlag = true;
                this.cycles += 2;
                break;
            }
            case 88: {
                this.delayInterrupt();
                this.interruptsDisabled = false;
                this.cycles += 2;
                break;
            }
            case 120: {
                this.delayInterrupt();
                this.interruptsDisabled = true;
                this.cycles += 2;
                break;
            }
            case 184: {
                this.overflowFlag = false;
                this.cycles += 2;
                break;
            }
            case 216: {
                this.decimalModeFlag = false;
                this.cycles += 2;
                break;
            }
            case 248: {
                this.decimalModeFlag = true;
                this.cycles += 2;
                break;
            }
            case 230: {
                this.inc(this.zpg());
                this.cycles += 5;
                break;
            }
            case 246: {
                this.inc(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 238: {
                this.inc(this.abs());
                this.cycles += 6;
                break;
            }
            case 254: {
                this.inc(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 227: {
                this.isc(this.indX());
                this.cycles += 8;
                break;
            }
            case 243: {
                this.isc(this.indY(dummy.ALWAYS));
                this.cycles += 8;
                break;
            }
            case 231: {
                this.isc(this.zpg());
                this.cycles += 5;
                break;
            }
            case 247: {
                this.isc(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 251: {
                this.isc(this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 239: {
                this.isc(this.abs());
                this.cycles += 6;
                break;
            }
            case 255: {
                this.isc(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 76: {
                this.PC = this.abs();
                this.cycles += 3;
                break;
            }
            case 108: {
                this.PC = this.ind();
                this.cycles += 5;
                break;
            }
            case 32: {
                this.jsr(this.abs());
                this.cycles += 6;
                break;
            }
            case 2: 
            case 18: 
            case 34: 
            case 50: 
            case 66: 
            case 82: 
            case 98: 
            case 114: 
            case 146: 
            case 178: 
            case 210: 
            case 242: {
                System.err.println("KIL - CPU locked");
                this.ram.apu.nes.runEmulation = false;
                break;
            }
            case 187: {
                this.las(this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 163: {
                this.lax(this.indX());
                this.cycles += 6;
                break;
            }
            case 179: {
                this.lax(this.indY(dummy.ONCARRY));
                this.cycles += 5 + this.pb;
                break;
            }
            case 167: {
                this.lax(this.zpg());
                this.cycles += 3;
                break;
            }
            case 183: {
                this.lax(this.zpg(this.Y));
                this.cycles += 4;
                break;
            }
            case 171: {
                this.lax(this.imm());
                this.cycles += 2;
                break;
            }
            case 175: {
                this.lax(this.abs());
                this.cycles += 4;
                break;
            }
            case 191: {
                this.lax(this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 169: {
                this.lda(this.imm());
                this.cycles += 2;
                break;
            }
            case 165: {
                this.lda(this.zpg());
                this.cycles += 3;
                break;
            }
            case 181: {
                this.lda(this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 173: {
                this.lda(this.abs());
                this.cycles += 4;
                break;
            }
            case 189: {
                this.lda(this.abs(this.X, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 185: {
                this.lda(this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 161: {
                this.lda(this.indX());
                this.cycles += 6;
                break;
            }
            case 177: {
                this.lda(this.indY(dummy.ONCARRY));
                this.cycles += 5 + this.pb;
                break;
            }
            case 162: {
                this.ldx(this.imm());
                this.cycles += 2;
                break;
            }
            case 166: {
                this.ldx(this.zpg());
                this.cycles += 3;
                break;
            }
            case 182: {
                this.ldx(this.zpg(this.Y));
                this.cycles += 4;
                break;
            }
            case 174: {
                this.ldx(this.abs());
                this.cycles += 4;
                break;
            }
            case 190: {
                this.ldx(this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 160: {
                this.ldy(this.imm());
                this.cycles += 2;
                break;
            }
            case 164: {
                this.ldy(this.zpg());
                this.cycles += 3;
                break;
            }
            case 180: {
                this.ldy(this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 172: {
                this.ldy(this.abs());
                this.cycles += 4;
                break;
            }
            case 188: {
                this.ldy(this.abs(this.X, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 74: {
                this.lsrA();
                this.cycles += 2;
                break;
            }
            case 70: {
                this.lsr(this.zpg());
                this.cycles += 5;
                break;
            }
            case 86: {
                this.lsr(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 78: {
                this.lsr(this.abs());
                this.cycles += 6;
                break;
            }
            case 94: {
                this.lsr(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 26: 
            case 58: 
            case 90: 
            case 122: 
            case 218: 
            case 234: 
            case 250: {
                this.cycles += 2;
                break;
            }
            case 128: 
            case 130: 
            case 137: 
            case 194: 
            case 226: {
                this.imm();
                this.cycles += 2;
                break;
            }
            case 4: 
            case 68: 
            case 100: {
                this.zpg();
                this.cycles += 3;
                break;
            }
            case 20: 
            case 52: 
            case 84: 
            case 116: 
            case 212: 
            case 244: {
                this.zpg(this.X);
                this.cycles += 4;
                break;
            }
            case 12: {
                this.abs();
                this.cycles += 4;
                break;
            }
            case 28: 
            case 60: 
            case 92: 
            case 124: 
            case 220: 
            case 252: {
                this.abs(this.X, dummy.ONCARRY);
                this.cycles += 4 + this.pb;
                break;
            }
            case 9: {
                this.ora(this.imm());
                this.cycles += 2;
                break;
            }
            case 5: {
                this.ora(this.zpg());
                this.cycles += 3;
                break;
            }
            case 21: {
                this.ora(this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 13: {
                this.ora(this.abs());
                this.cycles += 4;
                break;
            }
            case 29: {
                this.ora(this.abs(this.X, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 25: {
                this.ora(this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 1: {
                this.ora(this.indX());
                this.cycles += 6;
                break;
            }
            case 17: {
                this.ora(this.indY(dummy.ONCARRY));
                this.cycles += 5 + this.pb;
                break;
            }
            case 170: {
                this.X = this.A;
                this.cycles += 2;
                this.setflags(this.A);
                break;
            }
            case 138: {
                this.A = this.X;
                this.cycles += 2;
                this.setflags(this.A);
                break;
            }
            case 202: {
                --this.X;
                this.X &= 0xFF;
                this.setflags(this.X);
                this.cycles += 2;
                break;
            }
            case 232: {
                ++this.X;
                this.X &= 0xFF;
                this.setflags(this.X);
                this.cycles += 2;
                break;
            }
            case 168: {
                this.Y = this.A;
                this.cycles += 2;
                this.setflags(this.A);
                break;
            }
            case 152: {
                this.A = this.Y;
                this.cycles += 2;
                this.setflags(this.A);
                break;
            }
            case 136: {
                --this.Y;
                this.Y &= 0xFF;
                this.setflags(this.Y);
                this.cycles += 2;
                break;
            }
            case 200: {
                ++this.Y;
                this.Y &= 0xFF;
                this.setflags(this.Y);
                this.cycles += 2;
                break;
            }
            case 35: {
                this.rla(this.indX());
                this.cycles += 8;
                break;
            }
            case 51: {
                this.rla(this.indY(dummy.ALWAYS));
                this.cycles += 8;
                break;
            }
            case 39: {
                this.rla(this.zpg());
                this.cycles += 5;
                break;
            }
            case 55: {
                this.rla(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 59: {
                this.rla(this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 47: {
                this.rla(this.abs());
                this.cycles += 6;
                break;
            }
            case 63: {
                this.rla(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 42: {
                this.rolA();
                this.cycles += 2;
                break;
            }
            case 38: {
                this.rol(this.zpg());
                this.cycles += 5;
                break;
            }
            case 54: {
                this.rol(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 46: {
                this.rol(this.abs());
                this.cycles += 6;
                break;
            }
            case 62: {
                this.rol(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 106: {
                this.rorA();
                this.cycles += 2;
                break;
            }
            case 102: {
                this.ror(this.zpg());
                this.cycles += 5;
                break;
            }
            case 118: {
                this.ror(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 110: {
                this.ror(this.abs());
                this.cycles += 6;
                break;
            }
            case 126: {
                this.ror(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 99: {
                this.rra(this.indX());
                this.cycles += 8;
                break;
            }
            case 115: {
                this.rra(this.indY(dummy.ALWAYS));
                this.cycles += 8;
                break;
            }
            case 103: {
                this.rra(this.zpg());
                this.cycles += 5;
                break;
            }
            case 119: {
                this.rra(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 123: {
                this.rra(this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 111: {
                this.rra(this.abs());
                this.cycles += 6;
                break;
            }
            case 127: {
                this.rra(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 64: {
                this.rti();
                this.cycles += 6;
                break;
            }
            case 96: {
                this.rts();
                this.cycles += 6;
                break;
            }
            case 131: {
                this.sax(this.indX());
                this.cycles += 6;
                break;
            }
            case 135: {
                this.sax(this.zpg());
                this.cycles += 3;
                break;
            }
            case 151: {
                this.sax(this.zpg(this.Y));
                this.cycles += 4;
                break;
            }
            case 143: {
                this.sax(this.abs());
                this.cycles += 4;
                break;
            }
            case 225: {
                this.sbc(this.indX());
                this.cycles += 6;
                break;
            }
            case 241: {
                this.sbc(this.indY(dummy.ONCARRY));
                this.cycles += 5 + this.pb;
                break;
            }
            case 229: {
                this.sbc(this.zpg());
                this.cycles += 3;
                break;
            }
            case 245: {
                this.sbc(this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 233: {
                this.sbc(this.imm());
                this.cycles += 2;
                break;
            }
            case 249: {
                this.sbc(this.abs(this.Y, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 235: {
                this.sbc(this.imm());
                this.cycles += 2;
                break;
            }
            case 237: {
                this.sbc(this.abs());
                this.cycles += 4;
                break;
            }
            case 253: {
                this.sbc(this.abs(this.X, dummy.ONCARRY));
                this.cycles += 4 + this.pb;
                break;
            }
            case 158: {
                this.shx(this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 5;
                break;
            }
            case 156: {
                this.shy(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 5;
                break;
            }
            case 3: {
                this.slo(this.indX());
                this.cycles += 8;
                break;
            }
            case 7: {
                this.slo(this.zpg());
                this.cycles += 5;
                break;
            }
            case 15: {
                this.slo(this.abs());
                this.cycles += 6;
                break;
            }
            case 19: {
                this.slo(this.indY(dummy.ALWAYS));
                this.cycles += 8;
                break;
            }
            case 23: {
                this.slo(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 27: {
                this.slo(this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 31: {
                this.slo(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 67: {
                this.sre(this.indX());
                this.cycles += 8;
                break;
            }
            case 83: {
                this.sre(this.indY(dummy.ALWAYS));
                this.cycles += 8;
                break;
            }
            case 71: {
                this.sre(this.zpg());
                this.cycles += 5;
                break;
            }
            case 87: {
                this.sre(this.zpg(this.X));
                this.cycles += 6;
                break;
            }
            case 91: {
                this.sre(this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 79: {
                this.sre(this.abs());
                this.cycles += 6;
                break;
            }
            case 95: {
                this.sre(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 7;
                break;
            }
            case 133: {
                this.sta(this.zpg());
                this.cycles += 3;
                break;
            }
            case 149: {
                this.sta(this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 141: {
                this.sta(this.abs());
                this.cycles += 4;
                break;
            }
            case 157: {
                this.sta(this.abs(this.X, dummy.ALWAYS));
                this.cycles += 5;
                break;
            }
            case 153: {
                this.sta(this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 5;
                break;
            }
            case 129: {
                this.sta(this.indX());
                this.cycles += 6;
                break;
            }
            case 145: {
                this.sta(this.indY(dummy.ALWAYS));
                this.cycles += 6;
                break;
            }
            case 154: {
                this.S = this.X;
                this.cycles += 2;
                break;
            }
            case 186: {
                this.X = this.S;
                this.cycles += 2;
                this.setflags(this.X);
                break;
            }
            case 72: {
                this.ram.read(this.PC + 1);
                this.push(this.A);
                this.cycles += 3;
                break;
            }
            case 104: {
                this.ram.read(this.PC + 1);
                this.A = this.pop();
                this.setflags(this.A);
                this.cycles += 4;
                break;
            }
            case 8: {
                this.ram.read(this.PC + 1);
                this.push(this.flagstobyte() | 0x10);
                this.cycles += 3;
                break;
            }
            case 40: {
                this.delayInterrupt();
                this.ram.read(this.PC + 1);
                this.bytetoflags(this.pop());
                this.cycles += 4;
                break;
            }
            case 134: {
                this.stx(this.zpg());
                this.cycles += 3;
                break;
            }
            case 150: {
                this.stx(this.zpg(this.Y));
                this.cycles += 4;
                break;
            }
            case 142: {
                this.stx(this.abs());
                this.cycles += 4;
                break;
            }
            case 132: {
                this.sty(this.zpg());
                this.cycles += 3;
                break;
            }
            case 148: {
                this.sty(this.zpg(this.X));
                this.cycles += 4;
                break;
            }
            case 140: {
                this.sty(this.abs());
                this.cycles += 4;
                break;
            }
            case 155: {
                this.tas(this.abs(this.Y, dummy.ALWAYS));
                this.cycles += 5;
                break;
            }
            case 139: {
                this.xaa(this.imm());
                this.cycles += 2;
                break;
            }
            default: {
                this.cycles += 2;
                System.err.println("Illegal opcode:" + utils.hex(instr) + " @ " + utils.hex(this.PC - 1));
            }
        }
        this.pb = 0;
        this.PC &= 0xFFFF;
    }

    private void delayInterrupt() {
        this.interruptDelay = true;
        this.previntflag = this.interruptsDisabled;
    }

    private void rol(int addr) {
        int data = this.ram.read(addr);
        this.ram.write(addr, data);
        data = data << 1 | (this.carryFlag ? 1 : 0);
        this.carryFlag = utils.getbit(data, 8);
        this.setflags(data &= 0xFF);
        this.ram.write(addr, data);
    }

    private void rolA() {
        this.A = this.A << 1 | (this.carryFlag ? 1 : 0);
        this.carryFlag = utils.getbit(this.A, 8);
        this.A &= 0xFF;
        this.setflags(this.A);
    }

    private void ror(int addr) {
        int data = this.ram.read(addr);
        this.ram.write(addr, data);
        boolean tmp = this.carryFlag;
        this.carryFlag = utils.getbit(data, 0);
        data >>= 1;
        data &= 0x7F;
        this.setflags(data |= tmp ? 128 : 0);
        this.ram.write(addr, data);
    }

    private void rorA() {
        boolean tmp = this.carryFlag;
        this.carryFlag = utils.getbit(this.A, 0);
        this.A >>= 1;
        this.A &= 0x7F;
        this.A |= tmp ? 128 : 0;
        this.setflags(this.A);
    }

    public void nmi() {
        this.push(this.PC >> 8);
        this.push(this.PC & 0xFF);
        this.push(this.flagstobyte() & 0xFFFFFFEF);
        this.PC = this.ram.read(65530) + (this.ram.read(65531) << 8);
        this.cycles += 7;
        this.interruptsDisabled = true;
    }

    private void interrupt() {
        this.push(this.PC >> 8);
        this.push(this.PC & 0xFF);
        this.push(this.flagstobyte() & 0xFFFFFFEF);
        this.PC = this.ram.read(65534) + (this.ram.read(65535) << 8);
        this.interruptsDisabled = true;
    }

    private void breakinterrupt() {
        this.ram.read(this.PC++);
        this.push(this.PC >> 8);
        this.push(this.PC & 0xFF);
        this.push(this.flagstobyte() | 0x10 | 0x20);
        this.PC = this.ram.read(65534) + (this.ram.read(65535) << 8);
        this.interruptsDisabled = true;
    }

    private void lsr(int addr) {
        int data = this.ram.read(addr);
        this.ram.write(addr, data);
        this.carryFlag = utils.getbit(data, 0);
        data >>= 1;
        this.ram.write(addr, data &= 0x7F);
        this.setflags(data);
    }

    private void lsrA() {
        this.carryFlag = utils.getbit(this.A, 0);
        this.A >>= 1;
        this.A &= 0x7F;
        this.setflags(this.A);
    }

    private void eor(int addr) {
        this.A ^= this.ram.read(addr);
        this.A &= 0xFF;
        this.setflags(this.A);
    }

    private void ora(int addr) {
        this.A |= this.ram.read(addr);
        this.A &= 0xFF;
        this.setflags(this.A);
    }

    private void bit(int addr) {
        int data = this.ram.read(addr);
        this.zeroFlag = (data & this.A) == 0;
        this.negativeFlag = utils.getbit(data, 7);
        this.overflowFlag = utils.getbit(data, 6);
    }

    private void jsr(int addr) {
        --this.PC;
        this.ram.read(this.PC);
        this.push(this.PC >> 8);
        this.push(this.PC & 0xFF);
        this.PC = addr;
    }

    private void rts() {
        this.ram.read(this.PC++);
        this.PC = this.pop() & 0xFF | this.pop() << 8;
        ++this.PC;
    }

    private void rti() {
        this.ram.read(this.PC++);
        this.bytetoflags(this.pop());
        this.PC = this.pop() & 0xFF | this.pop() << 8;
    }

    private int pop() {
        ++this.S;
        this.S &= 0xFF;
        return this.ram.read(256 + this.S);
    }

    private void push(int byteToPush) {
        this.ram.write(256 + (this.S & 0xFF), byteToPush);
        --this.S;
        this.S &= 0xFF;
    }

    private void branch(boolean isTaken) {
        if (isTaken) {
            int pcprev = this.PC + 1;
            this.PC = this.rel();
            if ((pcprev & 0xFF00) != (this.PC & 0xFF00)) {
                this.pb = 2;
            } else {
                ++this.cycles;
            }
        } else {
            this.rel();
        }
    }

    private void inc(int addr) {
        int tmp = this.ram.read(addr);
        this.ram.write(addr, tmp);
        ++tmp;
        this.ram.write(addr, tmp &= 0xFF);
        this.setflags(tmp);
    }

    private void dec(int addr) {
        int tmp = this.ram.read(addr);
        this.ram.write(addr, tmp);
        --tmp;
        this.ram.write(addr, tmp &= 0xFF);
        this.setflags(tmp);
    }

    private void adc(int addr) {
        int value = this.ram.read(addr);
        if (this.decimalModeFlag) {
            // empty if block
        }
        int result = value + this.A + (this.carryFlag ? 1 : 0);
        this.carryFlag = result >> 8 != 0;
        this.overflowFlag = ((this.A ^ value) & 0x80) == 0 && ((this.A ^ result) & 0x80) != 0;
        this.A = result & 0xFF;
        this.setflags(this.A);
    }

    private void sbc(int addr) {
        int value = this.ram.read(addr);
        if (this.decimalModeFlag) {
            // empty if block
        }
        int result = this.A - value - (this.carryFlag ? 0 : 1);
        this.carryFlag = result >> 8 == 0;
        this.overflowFlag = ((this.A ^ value) & 0x80) != 0 && ((this.A ^ result) & 0x80) != 0;
        this.A = result & 0xFF;
        this.setflags(this.A);
    }

    private void and(int addr) {
        this.A &= this.ram.read(addr);
        this.setflags(this.A);
    }

    private void asl(int addr) {
        int data = this.ram.read(addr);
        this.ram.write(addr, data);
        this.carryFlag = utils.getbit(data, 7);
        data <<= 1;
        this.setflags(data &= 0xFF);
        this.ram.write(addr, data);
    }

    private void aslA() {
        this.carryFlag = utils.getbit(this.A, 7);
        this.A <<= 1;
        this.A &= 0xFF;
        this.setflags(this.A);
    }

    private void cmp(int regval, int addr) {
        int result = regval - this.ram.read(addr);
        if (result < 0) {
            this.negativeFlag = utils.getbit(result, 7);
            this.carryFlag = false;
            this.zeroFlag = false;
        } else if (result == 0) {
            this.negativeFlag = false;
            this.carryFlag = true;
            this.zeroFlag = true;
        } else {
            this.negativeFlag = utils.getbit(result, 7);
            this.carryFlag = true;
            this.zeroFlag = false;
        }
    }

    private void lda(int addr) {
        this.A = this.ram.read(addr);
        this.setflags(this.A);
    }

    private void ldx(int addr) {
        this.X = this.ram.read(addr);
        this.setflags(this.X);
    }

    private void ldy(int addr) {
        this.Y = this.ram.read(addr);
        this.setflags(this.Y);
    }

    private void setflags(int result) {
        this.zeroFlag = result == 0;
        this.negativeFlag = utils.getbit(result, 7);
    }

    private void sta(int addr) {
        this.ram.write(addr, this.A);
    }

    private void stx(int addr) {
        this.ram.write(addr, this.X);
    }

    private void sty(int addr) {
        this.ram.write(addr, this.Y);
    }

    private void ahx(int addr) {
        int data = this.A & this.X & (addr >> 8) + 1 & 0xFF;
        int tmp = addr - this.Y & 0xFF;
        if (this.Y + tmp <= 255) {
            this.ram.write(addr, data);
        } else {
            this.ram.write(addr, this.ram.read(addr));
        }
    }

    private void alr(int addr) {
        this.and(addr);
        this.lsrA();
    }

    private void anc(int addr) {
        this.and(addr);
        this.carryFlag = this.negativeFlag;
    }

    private void arr(int addr) {
        this.A = (this.ram.read(addr) & this.A) >> 1 | (this.carryFlag ? 128 : 0);
        this.setflags(this.A);
        this.carryFlag = utils.getbit(this.A, 6);
        this.overflowFlag = this.carryFlag ^ utils.getbit(this.A, 5);
    }

    private void axs(int addr) {
        this.X = (this.A & this.X) - this.ram.read(addr);
        this.setflags(this.X);
        this.carryFlag = this.X >= 0;
    }

    private void dcp(int regval, int addr) {
        this.dec(addr);
        this.cmp(regval, addr);
    }

    private void las(int addr) {
        this.S &= this.ram.read(addr);
        this.A = this.X = this.S;
        this.setflags(this.S);
    }

    private void lax(int addr) {
        this.A = this.X = this.ram.read(addr);
        this.setflags(this.A);
    }

    private void isc(int addr) {
        this.inc(addr);
        this.sbc(addr);
    }

    private void rla(int addr) {
        this.rol(addr);
        this.and(addr);
    }

    private void rra(int addr) {
        this.ror(addr);
        this.adc(addr);
    }

    private void sax(int addr) {
        this.ram.write(addr, this.A & this.X & 0xFF);
    }

    private void shx(int addr) {
        int data = this.X & (addr >> 8) + 1 & 0xFF;
        int tmp = addr - this.Y & 0xFF;
        if (this.Y + tmp <= 255) {
            this.ram.write(addr, data);
        } else {
            this.ram.write(addr, this.ram.read(addr));
        }
    }

    private void shy(int addr) {
        int data = this.Y & (addr >> 8) + 1 & 0xFF;
        int tmp = addr - this.X & 0xFF;
        if (this.X + tmp <= 255) {
            this.ram.write(addr, data);
        } else {
            this.ram.write(addr, this.ram.read(addr));
        }
    }

    private void slo(int addr) {
        this.asl(addr);
        this.ora(addr);
    }

    private void sre(int addr) {
        this.lsr(addr);
        this.eor(addr);
    }

    private void tas(int addr) {
        this.S = this.A & this.X;
        int data = this.S & (addr >> 8) + 1 & 0xFF;
        int tmp = addr - this.Y & 0xFF;
        if (this.Y + tmp <= 255) {
            this.ram.write(addr, data);
        } else {
            this.ram.write(addr, this.ram.read(addr));
        }
    }

    private void xaa(int addr) {
        this.A = this.X & this.ram.read(addr);
        this.setflags(this.A);
    }

    protected final int imm() {
        return this.PC++;
    }

    protected final int zpg() {
        return this.ram.read(this.PC++);
    }

    protected final int zpg(int reg) {
        return this.ram.read(this.PC++) + reg & 0xFF;
    }

    protected final int rel() {
        return (byte)this.ram.read(this.PC++) + this.PC;
    }

    protected final int abs() {
        return this.ram.read(this.PC++) + (this.ram.read(this.PC++) << 8);
    }

    protected final int abs(int reg, dummy dummy2) {
        int addr;
        if ((addr = this.ram.read(this.PC++) | this.ram.read(this.PC++) << 8) >> 8 != addr + reg >> 8) {
            this.pb = 1;
        }
        if ((addr & 0xFF00) != (addr + reg & 0xFF00)) {
            if (dummy2 == dummy.ONCARRY) {
                this.ram.read(addr & 0xFF00 | addr + reg & 0xFF);
            }
        }
        if (dummy2 == dummy.ALWAYS) {
            this.ram.read(addr & 0xFF00 | addr + reg & 0xFF);
        }
        return addr + reg & 0xFFFF;
    }

    protected final int ind() {
        int readloc = this.abs();
        return this.ram.read(readloc) + (this.ram.read((readloc & 0xFF) == 255 ? readloc - 255 : readloc + 1) << 8);
    }

    protected final int indX() {
        int arg = this.ram.read(this.PC++);
        return this.ram.read(arg + this.X & 0xFF) + (this.ram.read(arg + 1 + this.X & 0xFF) << 8);
    }

    protected final int indY(dummy dummy2) {
        int arg;
        int addr;
        if ((addr = this.ram.read((arg = this.ram.read(this.PC++)) & 0xFF) | this.ram.read(arg + 1 & 0xFF) << 8) >> 8 != addr + this.Y >> 8) {
            this.pb = 1;
        }
        if ((addr & 0xFF00) != (addr + this.Y & 0xFF00)) {
            if (dummy2 == dummy.ONCARRY) {
                this.ram.read(addr & 0xFF00 | addr + this.Y & 0xFF);
            }
        }
        if (dummy2 == dummy.ALWAYS) {
            this.ram.read(addr & 0xFF00 | addr + this.Y & 0xFF);
        }
        return addr + this.Y & 0xFFFF;
    }

    public final int flagstobyte() {
        return (this.negativeFlag ? 128 : 0) | (this.overflowFlag ? 64 : 0) | 0x20 | (this.decimalModeFlag ? 8 : 0) | (this.interruptsDisabled ? 4 : 0) | (this.zeroFlag ? 2 : 0) | (this.carryFlag ? 1 : 0);
    }

    protected final void bytetoflags(int statusbyte) {
        this.negativeFlag = (statusbyte & 0x80) != 0;
        this.overflowFlag = (statusbyte & 0x40) != 0;
        this.decimalModeFlag = (statusbyte & 8) != 0;
        this.interruptsDisabled = (statusbyte & 4) != 0;
        this.zeroFlag = (statusbyte & 2) != 0;
        this.carryFlag = (statusbyte & 1) != 0;
    }

    public String status() {
        return " PC:" + utils.hex(this.PC) + " A:" + utils.hex(this.A) + " X:" + utils.hex(this.X) + " Y:" + utils.hex(this.Y) + " P:" + utils.hex(this.flagstobyte()) + " SP:" + utils.hex(this.S);
    }

    public void modcycles() {
        this.cycles %= 29780;
    }

    public static String[] opcodes() {
        String[] opcodes = new String[256];
        for (int i = 0; i < 256; ++i) {
            opcodes[i] = utils.hex(i) + "?";
        }
        opcodes[0] = "BRK";
        opcodes[1] = "ORA $(%2%1,x)";
        opcodes[2] = "KIL";
        opcodes[3] = "SLO $(%2%1,x)";
        opcodes[4] = "NOP $%1";
        opcodes[5] = "ORA $%1";
        opcodes[6] = "ASL $%1";
        opcodes[7] = "SLO $%1";
        opcodes[8] = "PHP";
        opcodes[9] = "ORA #$%1";
        opcodes[10] = "ASL A";
        opcodes[11] = "ANC #$%1";
        opcodes[12] = "NOP $%2%1";
        opcodes[13] = "ORA $%2%1";
        opcodes[14] = "ASL $%2%1";
        opcodes[15] = "SLO $%2%1";
        opcodes[16] = "BPL $%3";
        opcodes[17] = "ORA ($%1), y";
        opcodes[18] = "KIL";
        opcodes[19] = "SLO ($%1), y";
        opcodes[20] = "NOP $%1,x";
        opcodes[21] = "ORA $%1,x";
        opcodes[22] = "ASL $%1,x";
        opcodes[23] = "SLO $%1,x";
        opcodes[24] = "CLC";
        opcodes[25] = "ORA $%2%1,y";
        opcodes[26] = "NOP";
        opcodes[27] = "SLO $%2%1,y";
        opcodes[28] = "NOP $%2%1,x";
        opcodes[29] = "ORA $%2%1,x";
        opcodes[30] = "ASL $%2%1,x";
        opcodes[31] = "SLO $%2%1,x";
        opcodes[32] = "JSR $%2%1";
        opcodes[33] = "AND $(%2%1,x)";
        opcodes[34] = "KIL";
        opcodes[35] = "RLA $(%2%1,x)";
        opcodes[36] = "BIT $%1";
        opcodes[37] = "AND $%1";
        opcodes[38] = "ROL $%1";
        opcodes[39] = "RLA $%1";
        opcodes[40] = "PLP";
        opcodes[41] = "AND #$%1";
        opcodes[42] = "ROL";
        opcodes[43] = "ANC #$%1";
        opcodes[44] = "BIT $%2%1";
        opcodes[45] = "AND $%2%1";
        opcodes[46] = "ROL $%2%1";
        opcodes[47] = "RLA $%2%1";
        opcodes[48] = "BMI $%3";
        opcodes[49] = "AND ($%1), y";
        opcodes[50] = "KIL";
        opcodes[51] = "RLA ($%1), y";
        opcodes[52] = "NOP $%1,x";
        opcodes[53] = "AND $%1,x";
        opcodes[54] = "ROL $%1,x";
        opcodes[55] = "RLA $%1,x";
        opcodes[56] = "SEC";
        opcodes[57] = "AND $%2%1,y";
        opcodes[58] = "NOP";
        opcodes[59] = "RLA $%2%1,y";
        opcodes[60] = "NOP $%2%1,x";
        opcodes[61] = "AND $%2%1,x";
        opcodes[62] = "ROL $%2%1,x";
        opcodes[63] = "RLA $%2%1,x";
        opcodes[64] = "RTI";
        opcodes[65] = "EOR $(%2%1,x)";
        opcodes[66] = "KIL";
        opcodes[67] = "SRE $(%2%1,x)";
        opcodes[68] = "NOP $%1";
        opcodes[69] = "EOR $%1";
        opcodes[70] = "LSR $%1";
        opcodes[71] = "SRE $%1";
        opcodes[72] = "PHA";
        opcodes[73] = "EOR #$%1";
        opcodes[74] = "LSR";
        opcodes[75] = "ALR #$%1";
        opcodes[76] = "JMP $%2%1";
        opcodes[77] = "EOR $%2%1";
        opcodes[78] = "LSR $%2%1";
        opcodes[79] = "SRE $%2%1";
        opcodes[80] = "BVC $%3";
        opcodes[81] = "EOR ($%1), y";
        opcodes[82] = "KIL";
        opcodes[83] = "SRE ($%1), y";
        opcodes[84] = "NOP $%1,x";
        opcodes[85] = "EOR $%1,x";
        opcodes[86] = "LSR $%1,x";
        opcodes[87] = "SRE $%1,x";
        opcodes[88] = "CLI";
        opcodes[89] = "EOR $%2%1,y";
        opcodes[90] = "NOP";
        opcodes[91] = "SRE $%2%1,y";
        opcodes[92] = "NOP $%2%1,x";
        opcodes[93] = "EOR $%2%1,x";
        opcodes[94] = "LSR $%2%1,x";
        opcodes[95] = "SRE $%2%1,x";
        opcodes[96] = "RTS";
        opcodes[97] = "ADC $(%2%1,x)";
        opcodes[98] = "KIL";
        opcodes[99] = "RRA $(%2%1,x)";
        opcodes[100] = "NOP $%1";
        opcodes[101] = "ADC $%1";
        opcodes[102] = "ROR $%1";
        opcodes[103] = "RRA $%1";
        opcodes[104] = "PLA";
        opcodes[105] = "ADC #$%1";
        opcodes[106] = "ROR";
        opcodes[107] = "ARR #$%1";
        opcodes[108] = "JMP ($%2%1)";
        opcodes[109] = "ADC $%2%1";
        opcodes[110] = "ROR $%2%1";
        opcodes[111] = "RRA $%2%1";
        opcodes[112] = "BVS $%3";
        opcodes[113] = "ADC ($%1), y";
        opcodes[114] = "KIL";
        opcodes[115] = "RRA ($%1), y";
        opcodes[116] = "NOP $%1,x";
        opcodes[117] = "ADC $%1,x";
        opcodes[118] = "ROR $%1,x";
        opcodes[119] = "RRA $%1,x";
        opcodes[120] = "SEI";
        opcodes[121] = "ADC $%2%1,y";
        opcodes[122] = "NOP";
        opcodes[123] = "RRA $%2%1,y";
        opcodes[124] = "NOP $%2%1,x";
        opcodes[125] = "ADC $%2%1,x";
        opcodes[126] = "ROR $%2%1,x";
        opcodes[127] = "RRA $%2%1,x";
        opcodes[128] = "NOP #$%1";
        opcodes[129] = "STA $(%2%1,x)";
        opcodes[130] = "NOP #$%1";
        opcodes[131] = "SAX $(%2%1,x)";
        opcodes[132] = "STY $%1";
        opcodes[133] = "STA $%1";
        opcodes[134] = "STX $%1";
        opcodes[135] = "SAX $%1";
        opcodes[136] = "DEY";
        opcodes[137] = "NOP #$%1";
        opcodes[138] = "TXA";
        opcodes[139] = "XAA #$%1";
        opcodes[140] = "STY $%2%1";
        opcodes[141] = "STA $%2%1";
        opcodes[142] = "STX $%2%1";
        opcodes[143] = "SAX $%2%1";
        opcodes[144] = "BCC $%3";
        opcodes[145] = "STA ($%1), y";
        opcodes[146] = "KIL";
        opcodes[147] = "AHX ($%1), y";
        opcodes[148] = "STY $%1,x";
        opcodes[149] = "STA $%1,x";
        opcodes[150] = "STX $%1,y";
        opcodes[151] = "SAX $%1,y";
        opcodes[152] = "TYA";
        opcodes[153] = "STA $%2%1,y";
        opcodes[154] = "TXS";
        opcodes[155] = "TAS $%2%1,y";
        opcodes[156] = "SHY $%2%1,x";
        opcodes[157] = "STA $%2%1,x";
        opcodes[158] = "SHX $%2%1,y";
        opcodes[159] = "AHX $%2%1,y";
        opcodes[160] = "LDY #$%1";
        opcodes[161] = "LDA $(%2%1,x)";
        opcodes[162] = "LDX #$%1";
        opcodes[163] = "LAX $(%2%1,x)";
        opcodes[164] = "LDY $%1";
        opcodes[165] = "LDA $%1";
        opcodes[166] = "LDX $%1";
        opcodes[167] = "LAX $%1";
        opcodes[168] = "TAY";
        opcodes[169] = "LDA #$%1";
        opcodes[170] = "TAX";
        opcodes[171] = "LAX #$%1";
        opcodes[172] = "LDY $%2%1";
        opcodes[173] = "LDA $%2%1";
        opcodes[174] = "LDX $%2%1";
        opcodes[175] = "LAX $%2%1";
        opcodes[176] = "BCS $%3";
        opcodes[177] = "LDA ($%1), y";
        opcodes[178] = "KIL";
        opcodes[179] = "LAX ($%1), y";
        opcodes[180] = "LDY $%1,x";
        opcodes[181] = "LDA $%1,x";
        opcodes[182] = "LDX $%1,y";
        opcodes[183] = "LAX $%1,y";
        opcodes[184] = "CLV";
        opcodes[185] = "LDA $%2%1,y";
        opcodes[186] = "TSX";
        opcodes[187] = "LAS $%2%1,y";
        opcodes[188] = "LDY $%2%1,x";
        opcodes[189] = "LDA $%2%1,x";
        opcodes[190] = "LDX $%2%1,y";
        opcodes[191] = "LAX $%2%1,y";
        opcodes[192] = "CPY #$%1";
        opcodes[193] = "CMP $(%2%1,x)";
        opcodes[194] = "NOP #$%1";
        opcodes[195] = "DCP $(%2%1,x)";
        opcodes[196] = "CPY $%1";
        opcodes[197] = "CMP $%1";
        opcodes[198] = "DEC $%1";
        opcodes[199] = "DCP $%1";
        opcodes[200] = "INY";
        opcodes[201] = "CMP #$%1";
        opcodes[202] = "DEX";
        opcodes[203] = "CMP #$%1";
        opcodes[204] = "CPY $%2%1";
        opcodes[205] = "CMP $%2%1";
        opcodes[206] = "DEC $%2%1";
        opcodes[207] = "DCP $%2%1";
        opcodes[208] = "BNE $%3";
        opcodes[209] = "CMP ($%1), y";
        opcodes[210] = "KIL";
        opcodes[211] = "DCP ($%1), y";
        opcodes[212] = "NOP $%1,x";
        opcodes[213] = "CMP $%1,x";
        opcodes[214] = "DEC $%1,x";
        opcodes[215] = "DCP $%1,x";
        opcodes[216] = "CLD";
        opcodes[217] = "CMP $%2%1,y";
        opcodes[218] = "NOP";
        opcodes[220] = "NOP $%2%1,x";
        opcodes[221] = "CMP $%2%1,x";
        opcodes[222] = "DEC $%2%1,x";
        opcodes[223] = "DCP $%2%1,x";
        opcodes[224] = "CPX #$%1";
        opcodes[225] = "SBC $(%2%1,x)";
        opcodes[226] = "NOP #$%1";
        opcodes[227] = "ISC $(%2%1,x)";
        opcodes[228] = "CPX $%1";
        opcodes[229] = "SBC $%1";
        opcodes[230] = "INC $%1";
        opcodes[231] = "ISC $%1";
        opcodes[232] = "INX";
        opcodes[233] = "SBC #$%1";
        opcodes[234] = "NOP";
        opcodes[235] = "SBC #$%1";
        opcodes[236] = "CPX $%2%1";
        opcodes[237] = "SBC $%2%1";
        opcodes[238] = "INC $%2%1";
        opcodes[239] = "ISC $%2%1";
        opcodes[240] = "BEQ $%3";
        opcodes[241] = "SBC ($%1), y";
        opcodes[242] = "KIL";
        opcodes[243] = "ISC ($%1), y";
        opcodes[244] = "NOP $%1,x";
        opcodes[245] = "SBC $%1,x";
        opcodes[246] = "INC $%1,x";
        opcodes[247] = "ISC $%1,x";
        opcodes[248] = "SED";
        opcodes[249] = "SBC $%2%1,y";
        opcodes[250] = "NOP";
        opcodes[251] = "ISC $%2%1,y";
        opcodes[252] = "NOP $%2%1,x";
        opcodes[253] = "SBC $%2%1,x";
        opcodes[254] = "INC $%2%1,x";
        opcodes[255] = "ISC $%2%1,x";
        return opcodes;
    }

    private static enum dummy {
        ONCARRY,
        ALWAYS;

    }
}

